package com.jtauber.fop.fo.flow;

// FOP
import com.jtauber.fop.fo.*;
import com.jtauber.fop.fo.properties.*;
import com.jtauber.fop.fo.pagination.PageSequence;
import com.jtauber.fop.layout.Area;
import com.jtauber.fop.apps.FOPException;				   

// Java
import java.util.Enumeration;

public class StaticContent extends FObj {

    public static class Maker extends FObj.Maker {
	public FObj make(FObj parent, PropertyList propertyList)
	    throws FOPException {
	    return new StaticContent(parent, propertyList);
	}
    }

    public static FObj.Maker maker() {
	return new StaticContent.Maker();
    }

    PageSequence pageSequence;

    protected StaticContent(FObj parent, PropertyList propertyList)
	throws FOPException {
	super(parent, propertyList);
	this.name =  "fo:static-content";

	if (parent.getName().equals("fo:page-sequence")) {
	    this.pageSequence = (PageSequence) parent;
	} else {
	    throw new FOPException("static-content must be child of "
				   + "fo:page-sequence, not "
				   + parent.getName());  
	}
	String flowName = this.properties.get("flow-name").getString();

	pageSequence.setStaticContent(flowName, this);
    }
    
    public int layout(Area area) throws FOPException {
	return OK;
	// to do 
    }
}
