/*
 * Decompiled with CFR 0.152.
 */
package com.kvisco.xsl;

import com.kvisco.xsl.ExprResult;
import com.kvisco.xsl.InvalidExprException;
import com.kvisco.xsl.NodeExpr;
import com.kvisco.xsl.NodeSet;
import com.kvisco.xsl.ProcessorState;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class AttributeExpr
implements NodeExpr {
    String name = null;

    public AttributeExpr(String string) {
        this.name = string;
    }

    public ExprResult evaluate(Node node, ProcessorState processorState) throws InvalidExprException {
        NodeSet nodeSet = new NodeSet();
        if (node == null || this.name == null) {
            return nodeSet;
        }
        if (node.getNodeType() == 1) {
            Element element = (Element)node;
            if ("*".equals(this.name)) {
                NamedNodeMap namedNodeMap = element.getAttributes();
                if (namedNodeMap != null) {
                    int n = 0;
                    while (n < namedNodeMap.getLength()) {
                        nodeSet.add(namedNodeMap.item(n));
                        ++n;
                    }
                }
            } else {
                Attr attr = element.getAttributeNode(this.name);
                if (attr != null) {
                    nodeSet.add(attr);
                }
            }
        }
        return nodeSet;
    }

    public short getExprType() {
        return 1;
    }

    public String getName() {
        return this.name;
    }

    public short getNodeExprType() {
        return 1;
    }

    public boolean matches(Node node, Node node2, ProcessorState processorState) throws InvalidExprException {
        if (node == null) {
            return false;
        }
        if (node.getNodeType() == 2) {
            Attr attr = (Attr)node;
            String string = attr.getName();
            return "*".equals(this.name) || string.equals(this.name);
        }
        return false;
    }

    public String toString() {
        return this.name;
    }
}

