/*
 * Decompiled with CFR 0.152.
 */
package com.kvisco.xsl;

import com.kvisco.util.Iterator;
import com.kvisco.util.List;
import com.kvisco.util.QuickStack;
import com.kvisco.xml.XMLUtil;
import com.kvisco.xml.parser.DOMPackage;
import com.kvisco.xsl.AttributeValueTemplate;
import com.kvisco.xsl.ExprResult;
import com.kvisco.xsl.InvalidExprException;
import com.kvisco.xsl.NodeSet;
import com.kvisco.xsl.ProcessorCallback;
import com.kvisco.xsl.RuleProcessor;
import com.kvisco.xsl.ScriptHandler;
import com.kvisco.xsl.StringResult;
import com.kvisco.xsl.Variable;
import com.kvisco.xsl.VariableSet;
import com.kvisco.xsl.XSLStylesheet;
import java.util.Enumeration;
import java.util.Hashtable;
import org.w3c.dom.Attr;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class ProcessorState {
    private String DEFAULT_SCRIPT_HANDLER = "com.kvisco.scripting.ECMAScriptHandler";
    private String DEFAULT_LANGUAGE = "ECMASCRIPT";
    public static final String ECMASCRIPT = "ECMASCRIPT";
    public static final String JPYTHON = "JPYTHON";
    private static final String RESULT_NAME = "xslp:result";
    private static final String NO_DOC_ELEMENT = "xslp:result has been added, because nodes were being added to the result tree, but no document element was present. XSLT result tree's must be well-formed. ";
    private static final String MULITPLE_DOC_ELEMENTS = "xslp:result has been added, because an element was being added to the result tree at the document level, but a document element already existed. XSLT result tree's must be well-formed. ";
    private Hashtable parents = null;
    private Hashtable indexingInfo = null;
    private QuickStack calledTemplates = null;
    private Hashtable constants = null;
    private Hashtable documentOrders = null;
    private DOMPackage domPackage = null;
    private Hashtable idRefs = null;
    private ScriptHandler dScriptHandler = null;
    private ProcessorCallback processorCallback = null;
    private Hashtable scriptHandlers = null;
    private Hashtable avtCache = null;
    private Document sourceDoc = null;
    private Document resultDoc = null;
    private XSLStylesheet stylesheet = null;
    private QuickStack variableStack = null;
    private VariableSet globalVars = null;
    private List cyclicVarCheck = null;
    private QuickStack parameterStack = null;
    private QuickStack modes = null;
    private QuickStack xmlSpaceModes = null;
    private QuickStack nodeStack = null;
    private QuickStack nodeSetStack = null;

    protected ProcessorState(RuleProcessor ruleProcessor, Document document, XSLStylesheet xSLStylesheet, DOMPackage dOMPackage) {
        this.processorCallback = new ProcessorCallback(ruleProcessor, this);
        this.sourceDoc = document;
        this.stylesheet = xSLStylesheet;
        this.domPackage = dOMPackage;
        this.parents = new Hashtable();
        this.avtCache = new Hashtable();
        this.calledTemplates = new QuickStack();
        this.documentOrders = new Hashtable();
        this.indexingInfo = new Hashtable();
        this.variableStack = new QuickStack();
        this.parameterStack = new QuickStack();
        this.nodeSetStack = new QuickStack();
        this.nodeStack = new QuickStack();
        this.scriptHandlers = new Hashtable();
        this.xmlSpaceModes = new QuickStack();
        this.cyclicVarCheck = new List();
        this.resultDoc = dOMPackage.createDocument();
        this.globalVars = new VariableSet();
        this.variableStack.push(this.globalVars);
        this.parameterStack.push(new VariableSet());
        this.nodeStack.push(this.resultDoc);
        this.xmlSpaceModes.push("default");
        String string = this.stylesheet.getResultDocType();
        if (string != null) {
            dOMPackage.setDocumentType(this.resultDoc, string);
        }
    }

    protected void addScriptHandler(ScriptHandler scriptHandler, String string) {
        if (string != null && scriptHandler != null) {
            this.scriptHandlers.put(string.toUpperCase(), scriptHandler);
        }
    }

    protected void addToResultTree(Node node) {
        if (node == null) {
            return;
        }
        Node node2 = (Node)this.nodeStack.peek();
        switch (node.getNodeType()) {
            case 2: {
                Attr attr;
                Element element;
                if (node2.getNodeType() != 1 || (element = (Element)node2).getAttributeNode((attr = (Attr)node).getName()) != null) break;
                element.setAttribute(attr.getName(), attr.getValue());
                break;
            }
            case 1: {
                Element element;
                if (node2 == this.resultDoc && (element = this.resultDoc.getDocumentElement()) != null) {
                    this.resultDoc.removeChild(element);
                    Element element2 = this.resultDoc.createElement(RESULT_NAME);
                    this.resultDoc.appendChild(element2);
                    this.nodeStack.push(element2);
                    element2.appendChild(element);
                    node2 = element2;
                    Comment comment = this.resultDoc.createComment(MULITPLE_DOC_ELEMENTS);
                    node2.appendChild(comment);
                }
                node2.appendChild(node);
                break;
            }
            case 7: 
            case 8: {
                node2.appendChild(node);
                break;
            }
            case 3: {
                if (node2 == this.resultDoc) {
                    if (XMLUtil.isWhitespace(((Text)node).getData())) {
                        node2.appendChild(node);
                        break;
                    }
                    Element element = this.resultDoc.createElement(RESULT_NAME);
                    this.resultDoc.appendChild(element);
                    this.nodeStack.push(element);
                    node2 = element;
                    Comment comment = this.resultDoc.createComment(NO_DOC_ELEMENT);
                    node2.appendChild(comment);
                }
                node2.appendChild(node);
                break;
            }
            default: {
                if (node2 == this.resultDoc) {
                    Element element = this.resultDoc.createElement(RESULT_NAME);
                    this.resultDoc.appendChild(element);
                    this.nodeStack.push(element);
                    node2 = element;
                    Comment comment = this.resultDoc.createComment(NO_DOC_ELEMENT);
                    node2.appendChild(comment);
                }
                node2.appendChild(node);
            }
        }
    }

    private int childNumber(Node node) {
        int n = 0;
        Node node2 = node;
        while ((node2 = node2.getPreviousSibling()) != null) {
            ++n;
        }
        return n;
    }

    private Object createKey(Node node) {
        return new Integer(System.identityHashCode(node));
    }

    protected Node findParent(Attr attr) {
        if (attr == null) {
            return null;
        }
        Node node = (Node)this.parents.get(this.createKey(attr));
        if (node != null) {
            return node;
        }
        Document document = attr.getOwnerDocument();
        IndexState indexState = (IndexState)this.indexingInfo.get(document);
        if (indexState == null) {
            indexState = new IndexState();
            this.indexingInfo.put(document, indexState);
            indexState.next = document.getDocumentElement();
            if (indexState.next == null) {
                indexState.done = true;
            }
        }
        if (indexState.done) {
            return null;
        }
        boolean bl = false;
        boolean bl2 = false;
        while (!bl) {
            Node node2;
            NamedNodeMap namedNodeMap;
            if (indexState.next == null) {
                indexState.done = true;
                break;
            }
            if (!bl2 && indexState.next.getNodeType() == 1 && (namedNodeMap = (node2 = (Element)indexState.next).getAttributes()) != null) {
                int n = 0;
                while (n < namedNodeMap.getLength()) {
                    Node node3 = namedNodeMap.item(n);
                    this.parents.put(this.createKey(node3), node2);
                    if (attr == node3) {
                        bl = true;
                        node = node2;
                    }
                    ++n;
                }
            }
            if (!bl2 && indexState.next.hasChildNodes()) {
                node2 = indexState.next.getFirstChild();
                indexState.next = node2;
                continue;
            }
            if (indexState.next.getNextSibling() != null) {
                indexState.next = indexState.next.getNextSibling();
                bl2 = false;
                continue;
            }
            indexState.next = this.getParentNode(indexState.next);
            bl2 = true;
        }
        return node;
    }

    public String generateId(Node node) {
        StringBuffer stringBuffer = new StringBuffer("id");
        stringBuffer.append(System.identityHashCode(node.getOwnerDocument()));
        if (node.getNodeType() == 9) {
            return stringBuffer.toString();
        }
        int[] nArray = this.getDocumentOrder(node);
        int n = 1;
        while (n < nArray.length) {
            stringBuffer.append('_');
            stringBuffer.append(nArray[n]);
            ++n;
        }
        return stringBuffer.toString();
    }

    public AttributeValueTemplate getAttributeValueTemplate(String string) throws InvalidExprException {
        AttributeValueTemplate attributeValueTemplate = null;
        if (string != null && (attributeValueTemplate = (AttributeValueTemplate)this.avtCache.get(string)) == null) {
            attributeValueTemplate = new AttributeValueTemplate(string);
            this.avtCache.put(string, attributeValueTemplate);
        }
        return attributeValueTemplate;
    }

    public DOMPackage getDOMPackage() {
        return this.domPackage;
    }

    protected int[] getDocumentOrder(Node node) {
        int[] nArray = null;
        if (node == null) {
            nArray = new int[]{-1};
            return nArray;
        }
        Object object = this.createKey(node);
        nArray = (int[])this.documentOrders.get(object);
        if (nArray != null) {
            return nArray;
        }
        Node node2 = null;
        if (node.getNodeType() == 2) {
            node2 = this.findParent((Attr)node);
            if (node2 == null) {
                nArray = new int[]{0, 0, this.childNumber(node)};
            } else {
                int[] nArray2 = this.getDocumentOrder(node2);
                nArray = new int[nArray2.length + 2];
                System.arraycopy(nArray2, 0, nArray, 0, nArray2.length);
                nArray[nArray.length - 2] = 0;
                nArray[nArray.length - 1] = this.childNumber(node);
            }
        } else if (node.getNodeType() == 9) {
            nArray = new int[]{0};
        } else {
            node2 = this.getParentNode(node);
            int[] nArray3 = this.getDocumentOrder(this.getParentNode(node));
            nArray = new int[nArray3.length + 1];
            System.arraycopy(nArray3, 0, nArray, 0, nArray3.length);
            nArray[nArray.length - 1] = this.childNumber(node);
        }
        this.documentOrders.put(object, nArray);
        return nArray;
    }

    public Hashtable getIDReferences() {
        return this.idRefs;
    }

    protected QuickStack getInvocationStack() {
        return this.calledTemplates;
    }

    public QuickStack getNodeSetStack() {
        return this.nodeSetStack;
    }

    protected QuickStack getNodeStack() {
        return this.nodeStack;
    }

    protected QuickStack getParameterStack() {
        return this.parameterStack;
    }

    protected Node getParentNode(Node node) {
        if (node == null) {
            return null;
        }
        switch (node.getNodeType()) {
            case 2: {
                return this.findParent((Attr)node);
            }
        }
        return node.getParentNode();
    }

    public String getProperty(String string) {
        if (string == null) {
            return "";
        }
        String string2 = XMLUtil.getNameSpace(string);
        String string3 = XMLUtil.getLocalPart(string);
        String string4 = null;
        string4 = string2.length() == 0 ? System.getProperty(string3, "") : (string2.equals(this.stylesheet.getXSLNSPrefix()) ? this.processorCallback.getProperty(string3) : "");
        return string4;
    }

    protected Document getResultDocument() {
        return this.resultDoc;
    }

    public ScriptHandler getScriptHandler() {
        block5: {
            if (this.dScriptHandler != null) break block5;
            this.dScriptHandler = (ScriptHandler)this.scriptHandlers.get(this.DEFAULT_LANGUAGE);
            if (this.dScriptHandler == null) {
                try {
                    Class<?> clazz = Class.forName(this.DEFAULT_SCRIPT_HANDLER);
                    this.dScriptHandler = (ScriptHandler)clazz.newInstance();
                    this.dScriptHandler.initialize(this.processorCallback);
                    this.scriptHandlers.put(this.DEFAULT_LANGUAGE, this.dScriptHandler);
                }
                catch (ClassNotFoundException classNotFoundException) {
                }
                catch (IllegalAccessException illegalAccessException) {
                }
                catch (InstantiationException instantiationException) {}
            }
        }
        return this.dScriptHandler;
    }

    public ScriptHandler getScriptHandler(String string) {
        if (string == null || string.length() == 0) {
            return this.getScriptHandler();
        }
        ScriptHandler scriptHandler = (ScriptHandler)this.scriptHandlers.get(string.toUpperCase());
        if (scriptHandler == null && this.DEFAULT_LANGUAGE.equals(string)) {
            return this.getScriptHandler();
        }
        return scriptHandler;
    }

    public ScriptHandler getScriptHandler(String string, String string2) {
        Enumeration enumeration = this.scriptHandlers.elements();
        while (enumeration.hasMoreElements()) {
            ScriptHandler scriptHandler = (ScriptHandler)enumeration.nextElement();
            if (!scriptHandler.hasDefinedFunction(string, string2)) continue;
            return scriptHandler;
        }
        return null;
    }

    public String getStylesheetHref() {
        return this.stylesheet.getHref();
    }

    protected ExprResult getVariable(String string) {
        VariableSet variableSet = this.getVariableSet(string);
        ExprResult exprResult = null;
        if (variableSet == null) {
            Variable variable = this.stylesheet.getVariableDecl(string);
            if (variable != null) {
                if (!this.cyclicVarCheck.contains(string)) {
                    this.cyclicVarCheck.add(string);
                    exprResult = this.processorCallback.processVariable(variable, this.sourceDoc, this);
                    this.cyclicVarCheck.remove(string);
                    this.globalVars.put(string, exprResult);
                } else {
                    exprResult = new StringResult("#cyclic variable definition");
                }
            } else {
                return null;
            }
        }
        if (exprResult == null) {
            exprResult = variableSet.get(string);
        }
        switch (exprResult.getResultType()) {
            case 2: {
                exprResult = ((NodeSet)exprResult).copy();
                break;
            }
        }
        return exprResult;
    }

    protected VariableSet getVariableSet(String string) {
        if (string == null) {
            return null;
        }
        VariableSet variableSet = null;
        Iterator iterator = this.variableStack.iterator();
        while (iterator.hasNext()) {
            variableSet = (VariableSet)iterator.next();
            if (variableSet.get(string) != null) {
                return variableSet;
            }
            variableSet = null;
        }
        return variableSet;
    }

    protected QuickStack getVariableSets() {
        return this.variableStack;
    }

    public QuickStack getXMLSpaceModes() {
        return this.xmlSpaceModes;
    }

    protected void setDefaultScriptHandler(ScriptHandler scriptHandler) {
        this.dScriptHandler = scriptHandler;
    }

    protected void setIDReferences(Hashtable hashtable) {
        this.idRefs = hashtable;
    }

    class IndexState {
        Node next = null;
        boolean done = false;

        protected IndexState() {
        }
    }
}

