/*
 * Decompiled with CFR 0.152.
 */
package com.kvisco.xsl;

import com.kvisco.util.List;
import com.kvisco.xsl.AttributeValueTemplate;
import com.kvisco.xsl.InvalidExprException;
import com.kvisco.xsl.XSLException;
import com.kvisco.xsl.XSLStylesheet;
import com.kvisco.xsl.XSLText;
import java.util.Enumeration;
import java.util.Hashtable;
import org.w3c.dom.Attr;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;

public class XSLObject {
    private static final String DEFAULT_NAME = "xsl:element";
    public static final short APPLY_IMPORTS = 0;
    public static final short APPLY_TEMPLATES = 1;
    public static final short ARG = 2;
    public static final short ATTRIBUTE = 3;
    public static final short ATTRIBUTE_SET = 4;
    public static final short CALL_TEMPLATE = 5;
    public static final short CDATA = 6;
    public static final short CHOOSE = 7;
    public static final short COMMENT = 8;
    public static final short CONTENTS = 9;
    public static final short COPY = 10;
    public static final short COPY_OF = 11;
    public static final short ELEMENT = 12;
    public static final short FOR_EACH = 13;
    public static final short FUNCTIONS = 14;
    public static final short ID = 15;
    public static final short IF = 16;
    public static final short IMPORT = 17;
    public static final short INCLUDE = 18;
    public static final short KEY = 19;
    public static final short LITERAL = 20;
    public static final short LOCALE = 21;
    public static final short MESSAGE = 22;
    public static final short NUMBER = 23;
    public static final short OTHERWISE = 24;
    public static final short OUTPUT = 25;
    public static final short PARAM = 26;
    public static final short PARAM_VARIABLE = 27;
    public static final short PI = 28;
    public static final short PRESERVE_SPACE = 29;
    public static final short SORT = 30;
    public static final short STRIP_SPACE = 31;
    public static final short STYLESHEET = 32;
    public static final short TEMPLATE = 33;
    public static final short TEXT = 34;
    public static final short USE = 35;
    public static final short VALUE_OF = 36;
    public static final short VARIABLE = 37;
    public static final short WHEN = 38;
    public static final short ENTITY_REF = 39;
    public static final short SCRIPT = 40;
    private static final short MAX_TYPE = 41;
    private short type = (short)20;
    private Hashtable avtCache;
    private List children = null;
    private Hashtable attributes = null;
    private List readOnlyAttrs = null;
    private boolean allowActions = true;
    private XSLStylesheet parentStylesheet = null;
    private XSLObject parent = null;
    private String typeName = "xsl:object";
    private static Hashtable typeNames = null;

    public XSLObject(XSLStylesheet xSLStylesheet, short s) {
        if (typeNames == null) {
            typeNames = XSLObject.buildNameHash();
        }
        this.type = s;
        this.typeName = XSLObject.getNameFromType(s);
        this.parentStylesheet = xSLStylesheet;
        this.attributes = new Hashtable();
        this.children = new List(0);
        this.readOnlyAttrs = new List(0);
        this.avtCache = new Hashtable();
    }

    public boolean appendAction(XSLObject xSLObject) {
        if (!this.allowActions) {
            return false;
        }
        if (this.handleAction(xSLObject)) {
            return true;
        }
        if (xSLObject.getType() == 34) {
            XSLObject xSLObject2;
            XSLText xSLText = (XSLText)xSLObject;
            if (this.children.size() > 0 && (xSLObject2 = (XSLObject)this.children.get(this.children.size() - 1)).getType() == 34) {
                ((XSLText)xSLObject2).appendData(xSLText.getData());
                return true;
            }
        }
        this.children.add(xSLObject);
        xSLObject.setParentStylesheet(this.parentStylesheet);
        xSLObject.setParent(this);
        return true;
    }

    private static Hashtable buildNameHash() {
        Hashtable<String, Short> hashtable = new Hashtable<String, Short>();
        short s = 0;
        while (s < 41) {
            hashtable.put(XSLObject.getNameFromType(s), new Short(s));
            s = (short)(s + 1);
        }
        return hashtable;
    }

    protected void copyActions(XSLObject xSLObject) {
        List list = xSLObject.getActions();
        int n = 0;
        while (n < list.size()) {
            XSLObject xSLObject2 = (XSLObject)list.get(n);
            this.appendAction(xSLObject2);
            ++n;
        }
    }

    protected void copyAttributes(XSLObject xSLObject) {
        xSLObject.copyAttributesInto(this.attributes);
    }

    protected void copyAttributes(Element element) throws XSLException {
        NamedNodeMap namedNodeMap = element.getAttributes();
        if (namedNodeMap == null) {
            return;
        }
        int n = 0;
        while (n < namedNodeMap.getLength()) {
            Attr attr = (Attr)namedNodeMap.item(n);
            this.setAttribute(attr.getName(), attr.getValue());
            ++n;
        }
    }

    protected void copyAttributesInto(Hashtable hashtable) {
        Enumeration enumeration = this.attributes.keys();
        while (enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
            hashtable.put(k, this.attributes.get(k));
        }
    }

    protected void freeUnusedMemory(boolean bl) {
        this.children.trimToSize();
        this.readOnlyAttrs.trimToSize();
        if (bl) {
            int n = 0;
            while (n < this.children.size()) {
                XSLObject xSLObject = (XSLObject)this.children.get(n);
                xSLObject.freeUnusedMemory(true);
                ++n;
            }
        }
    }

    public List getActions() {
        return (List)this.children.clone();
    }

    public String getAttribute(String string) {
        if (string != null) {
            return (String)this.attributes.get(string);
        }
        return null;
    }

    public AttributeValueTemplate getAttributeAsAVT(String string) throws XSLException {
        if (string == null) {
            return null;
        }
        String string2 = this.getAttribute(string);
        AttributeValueTemplate attributeValueTemplate = null;
        if (string2 != null && string2.length() > 0 && (attributeValueTemplate = (AttributeValueTemplate)this.avtCache.get(string2)) == null) {
            try {
                attributeValueTemplate = new AttributeValueTemplate(string2);
                this.avtCache.put(string2, attributeValueTemplate);
            }
            catch (InvalidExprException invalidExprException) {
                throw new XSLException(5, invalidExprException.getMessage());
            }
        }
        return attributeValueTemplate;
    }

    public Enumeration getAttributeNames() {
        return this.attributes.keys();
    }

    private static String getNameFromType(short s) {
        switch (s) {
            case 0: {
                return "apply-imports";
            }
            case 1: {
                return "apply-templates";
            }
            case 3: {
                return "attribute";
            }
            case 4: {
                return "attribute-set";
            }
            case 5: {
                return "call-template";
            }
            case 6: {
                return "cdata";
            }
            case 7: {
                return "choose";
            }
            case 8: {
                return "comment";
            }
            case 10: {
                return "copy";
            }
            case 11: {
                return "copy-of";
            }
            case 12: {
                return "element";
            }
            case 39: {
                return "entity-ref";
            }
            case 13: {
                return "for-each";
            }
            case 14: {
                return "functions";
            }
            case 15: {
                return "id";
            }
            case 16: {
                return "if";
            }
            case 17: {
                return "import";
            }
            case 18: {
                return "include";
            }
            case 19: {
                return "key";
            }
            case 21: {
                return "locale";
            }
            case 22: {
                return "message";
            }
            case 23: {
                return "number";
            }
            case 24: {
                return "otherwise";
            }
            case 25: {
                return "output";
            }
            case 26: {
                return "param";
            }
            case 27: {
                return "param-variable";
            }
            case 28: {
                return "processing-instruction";
            }
            case 29: {
                return "preserve-space";
            }
            case 30: {
                return "sort";
            }
            case 31: {
                return "strip-space";
            }
            case 32: {
                return "stylesheet";
            }
            case 33: {
                return "template";
            }
            case 34: {
                return "text";
            }
            case 35: {
                return "use";
            }
            case 36: {
                return "value-of";
            }
            case 37: {
                return "variable";
            }
            case 38: {
                return "when";
            }
            case 40: {
                return "script";
            }
        }
        return DEFAULT_NAME;
    }

    public XSLObject getNearestAncestor(short s) {
        if (this.parent == null) {
            return null;
        }
        if (this.parent.getType() == s) {
            return this.parent;
        }
        return this.parent.getNearestAncestor(s);
    }

    public static String getNodeValue(Node node) {
        if (node == null) {
            return "";
        }
        switch (node.getNodeType()) {
            case 9: {
                return XSLObject.getNodeValue(((Document)node).getDocumentElement());
            }
            case 11: {
                StringBuffer stringBuffer = new StringBuffer();
                NodeList nodeList = node.getChildNodes();
                int n = 0;
                while (n < nodeList.getLength()) {
                    stringBuffer.append(XSLObject.getNodeValue(nodeList.item(n)));
                    ++n;
                }
                return stringBuffer.toString();
            }
            case 1: {
                return XSLObject.getText((Element)node);
            }
            case 2: {
                return ((Attr)node).getValue();
            }
            case 3: 
            case 4: {
                return ((Text)node).getData();
            }
            case 8: {
                return ((Comment)node).getData();
            }
            case 7: {
                return ((ProcessingInstruction)node).getData();
            }
        }
        return "";
    }

    protected XSLObject getParent() {
        return this.parent;
    }

    public XSLStylesheet getParentStylesheet() {
        return this.parentStylesheet;
    }

    public static String getText(Element element) {
        if (element == null) {
            return null;
        }
        NodeList nodeList = element.getChildNodes();
        int n = nodeList.getLength();
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        while (n2 < n) {
            Node node = nodeList.item(n2);
            switch (node.getNodeType()) {
                case 3: 
                case 4: {
                    if (n == 1) {
                        return ((Text)node).getData();
                    }
                    stringBuffer.append(((Text)node).getData());
                    break;
                }
                case 1: {
                    if (n == 1) {
                        return XSLObject.getText((Element)node);
                    }
                    stringBuffer.append(XSLObject.getText((Element)node));
                    break;
                }
            }
            ++n2;
        }
        return stringBuffer.toString();
    }

    public final short getType() {
        return this.type;
    }

    public static short getTypeFromName(String string) {
        Short s = (Short)typeNames.get(string);
        if (s == null) {
            return 20;
        }
        return s;
    }

    public String getTypeName() {
        return this.typeName;
    }

    protected boolean handleAction(XSLObject xSLObject) {
        return false;
    }

    protected void makeAttrReadOnly(String string) {
        this.readOnlyAttrs.add(string);
    }

    public void setAllowActions(boolean bl) {
        this.allowActions = bl;
    }

    public void setAttribute(String string, String string2) throws XSLException {
        if (string != null && string2 != null) {
            if (this.readOnlyAttrs.contains(string)) {
                StringBuffer stringBuffer = new StringBuffer("The attribute '");
                stringBuffer.append(string);
                stringBuffer.append("' has been set to read only for this ");
                stringBuffer.append(this.getTypeName());
                stringBuffer.append(" and cannot be changed.");
                throw new XSLException(stringBuffer.toString());
            }
            this.attributes.put(string, string2);
        }
    }

    protected void setParent(XSLObject xSLObject) {
        this.parent = xSLObject;
    }

    protected void setParentStylesheet(XSLStylesheet xSLStylesheet) {
        this.parentStylesheet = xSLStylesheet;
    }

    public void setTypeName(String string) {
        this.typeName = string;
    }
}

