/*
 * (C) Copyright Keith Visco 1999  All rights reserved.
 *
 * The program is provided "as is" without any warranty express or
 * implied, including the warranty of non-infringement and the implied
 * warranties of merchantibility and fitness for a particular purpose.
 * The Copyright owner will not be liable for any damages suffered by 
 * you as a result of using the Program. In no event will the Copyright
 * owner be liable for any special, indirect or consequential damages or 
 * lost profits even if the Copyright owner has been advised of the 
 * possibility of their occurrence.  
 */

package com.kvisco.xsl;

import org.w3c.dom.*;

/**
 * This class represents a MatchExpr
 * @author <a href="mailto:kvisco@ziplink.net">Keith Visco</a>
**/
public interface MatchExpr {
        
    /**
     * Determines if the given node is matched by this MatchExpr with
     * respect to the given context node.
     * @param node the node to determine a match for
     * @param context the Node which represents the current context
     * @param ps the current ProcessorState
     * @return true if the given node is matched by this MatchExpr
    **/
    public boolean matches(Node node, Node context, ProcessorState ps)
        throws InvalidExprException;
    
} //-- MatchExpr