/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.jsp;

import java.io.IOException;
import java.io.Writer;
import javax.servlet.ServletResponse;
import javax.servlet.jsp.JspWriter;
import org.gjt.jsp.JspConfig;
import org.gjt.jsp.JspMsg;

public class JspWriterImpl
extends JspWriter
implements JspMsg {
    protected ServletResponse response;
    protected Writer out;
    private String lineSeparator;
    private char[] cb;
    private int nChars;
    private int nextChar;
    private boolean flushed;
    protected boolean propagateClose = true;
    protected boolean allowFlushedClear = false;

    public int getRemaining() {
        return this.bufferSize - this.nextChar;
    }

    public void clear() throws IOException {
        this.nextChar = 0;
        if (this.flushed && !this.allowFlushedClear) {
            throw new IOException(JspConfig.getLocalizedMsg(199));
        }
    }

    public void clearBuffer() throws IOException {
        this.nextChar = 0;
    }

    public void flush() throws IOException {
        this.flushBuffer(false);
        if (this.out != null) {
            this.out.flush();
        }
    }

    public void close() throws IOException {
        this.flush();
        if (this.out != null) {
            if (this.propagateClose) {
                this.out.close();
            } else {
                this.out.flush();
            }
        }
    }

    private void flushBuffer(boolean bl) throws IOException {
        if (this.nextChar == 0 && this.bufferSize > 0) {
            return;
        }
        this.flushed = true;
        if (this.bufferSize <= 0) {
            return;
        }
        if (this.nextChar == 0) {
            return;
        }
        if (this.out == null) {
            this.out = this.response.getWriter();
        }
        if (bl && !this.autoFlush) {
            throw new IOException(JspConfig.getLocalizedMsg(198) + ": " + this.bufferSize);
        }
        this.out.write(this.cb, 0, this.nextChar);
        this.nextChar = 0;
    }

    void flushBuffer() throws IOException {
        this.flushBuffer(false);
    }

    public void write(int n) throws IOException {
        if (this.bufferSize > 0) {
            if (this.nextChar >= this.nChars) {
                this.flushBuffer(true);
            }
            this.cb[this.nextChar++] = (char)n;
        } else {
            if (this.out == null) {
                this.out = this.response.getWriter();
            }
            this.out.write(n);
        }
    }

    public void write(char[] cArray, int n, int n2) throws IOException {
        if (n2 >= this.nChars) {
            this.flushBuffer(true);
            if (this.out == null) {
                this.out = this.response.getWriter();
            }
            this.out.write(cArray, n, n2);
            return;
        }
        int n3 = n;
        int n4 = n + n2;
        while (n3 < n4) {
            int n5 = Math.min(this.nChars - this.nextChar, n4 - n3);
            System.arraycopy(cArray, n3, this.cb, this.nextChar, n5);
            n3 += n5;
            this.nextChar += n5;
            if (this.nextChar < this.nChars) continue;
            this.flushBuffer(true);
        }
    }

    public void write(String string) throws IOException {
        this.write(string, 0, string.length());
    }

    public void write(String string, int n, int n2) throws IOException {
        if (this.bufferSize > 0) {
            int n3 = n;
            int n4 = n + n2;
            while (n3 < n4) {
                int n5 = Math.min(this.nChars - this.nextChar, n4 - n3);
                string.getChars(n3, n3 + n5, this.cb, this.nextChar);
                n3 += n5;
                this.nextChar += n5;
                if (this.nextChar < this.nChars) continue;
                this.flushBuffer(true);
            }
        } else {
            this.flushed = true;
            if (this.out == null) {
                this.out = this.response.getWriter();
            }
            this.out.write(string, n, n2);
        }
    }

    public void newLine() throws IOException {
        this.write(this.lineSeparator);
    }

    public void print(boolean bl) throws IOException {
        this.write(bl ? "true" : "false");
    }

    public void print(char c) throws IOException {
        this.write(String.valueOf(c));
    }

    public void print(int n) throws IOException {
        this.write(String.valueOf(n));
    }

    public void print(long l) throws IOException {
        this.write(String.valueOf(l));
    }

    public void print(float f) throws IOException {
        this.write(String.valueOf(f));
    }

    public void print(double d) throws IOException {
        this.write(String.valueOf(d));
    }

    public void print(char[] cArray) throws IOException {
        ((Writer)((Object)this)).write(cArray);
    }

    public void print(String string) throws IOException {
        this.write(string == null ? "null" : string);
    }

    public void print(Object object) throws IOException {
        this.write(String.valueOf(object));
    }

    public void println() throws IOException {
        this.newLine();
    }

    public void println(boolean bl) throws IOException {
        this.print(bl);
        this.newLine();
    }

    public void println(char c) throws IOException {
        this.print(c);
        this.newLine();
    }

    public void println(int n) throws IOException {
        this.print(n);
        this.newLine();
    }

    public void println(long l) throws IOException {
        this.print(l);
        this.newLine();
    }

    public void println(float f) throws IOException {
        this.print(f);
        this.newLine();
    }

    public void println(double d) throws IOException {
        this.print(d);
        this.newLine();
    }

    public void println(char[] cArray) throws IOException {
        this.print(cArray);
        this.newLine();
    }

    public void println(String string) throws IOException {
        this.print(string);
        this.newLine();
    }

    public void println(Object object) throws IOException {
        this.print(object);
        this.newLine();
    }

    protected JspWriterImpl(ServletResponse servletResponse, int n, boolean bl) {
        super(n, bl);
        this.response = servletResponse;
        this.lineSeparator = System.getProperty("line.separator");
        this.cb = new char[n];
        this.nChars = n;
        this.nextChar = 0;
        this.flushed = false;
    }
}

