#include <stdio.h>
#include <dirent.h>
#include <string.h>
#include <sys/sysmacros.h>
#include <sys/stat.h>
#include <unistd.h>
#include "dbootstrap.h"

static dev_t my_device;
static char *my_device_name;

static int match_mount(const char *source, struct stat *i) {
	if ( S_ISBLK(i->st_mode) 
	 && (i->st_rdev == my_device)) {
		my_device_name=strdup(source);
		return -1; /*found one*/
	} else
		return 0;
}

char *block_device(char *name)
{
  struct stat s;
  char *buf;
  
 if(stat(name, &s))
   return (char *) NULL; /* non-existent */

  my_device=s.st_dev;
  my_device_name=NULL;
      /* recurse /dev to find the appropriate device for *name */  
  recursiveAction("/dev", TRUE, FALSE, FALSE, match_mount, NULL);
  
  if(my_device_name) {
    buf=strdup(my_device_name);
    free(my_device_name);
    return buf;
  }

	return (char *) NULL;
}
