#!/bin/sh
# (C) 1999 Felipe Bergo <bergo@seul.org>

# find uname

echo -n "checking for uname... "

QNAME="no"

if [ -x which ] ; then
 QNAME=`which uname`
else
 if [ -x /sbin/uname ] ; then
    QNAME=/sbin/uname
 fi
 if [ -x /usr/sbin/uname ] ; then
    QNAME=/usr/sbin/uname
 fi
 if [ -x /usr/bin/uname ] ; then
    QNAME=/usr/bin/uname
 fi
 if [ -x /bin/uname ] ; then
    QNAME=/bin/uname
 fi
fi

echo $QNAME

if [ $QNAME != "no" ] ; then
 echo -n "checking OS type... "
 J="$QNAME -s"
 SYSTRING=`$J`
 echo $SYSTRING

 if [ $SYSTRING != "Linux" ] ; then
   echo "************************************************"
   echo
   echo " The OS type string did not return \"Linux\"      "
   echo " as expected."
   echo " gPS requires some Linux-specific capabilities  "
   echo " and hardly will run on other Un*x systems.     "
   echo " The configure script will still continue and   "
   echo " probably gPS will compile correctly, but       "
   echo " probably won't list processes correctly. If it "
   echo " does, please e-mail me your \"uname -a\" output"
   echo " so that I can add your system to the           "
   echo " platform list.                                 "
   echo
   echo "************************************************"
   echo -n "<Press Enter>"
   read BLACKHOLE
   echo
 fi
fi

# check /proc

echo -n "checking for Linux /proc fs... "

J="ab"

if [ -d /proc ]; then
 J="d!"
fi

if [ -d /proc/1 ]; then
 J="ir$J"
fi

if [ -r /proc/1/stat ]; then
 J="we$J"
fi

if [ $J = "weird!" ]; then
 echo "yes"
else
 echo "no"
 echo "***************************************************"
 echo
 echo " Your system does not have a working /proc fs.     "
 echo " You may be running a kernel without /proc fs      "
 echo " support, a system with non-Linux /proc fs         "
 echo " (Solaris?) or a system without /proc fs at all.   "
 echo
 echo " The configure script will continue and gPS will   "
 echo " still be compiled, but without a working /proc fs "
 echo " no process information can be gathered.           "
 echo
 echo "***************************************************"
 echo -n "<Press Enter>"
 read BLACKHOLE
 echo
fi


