#include <stdlib.h>
#include <string.h>
#include "dialog.h"
#include "../diajava/proto.h"

class FIELD_CHECK_MULTI_VAL: public FIELD_CHECK_MULTI{
	int &numvar;
	int backup;
	char cvar;
	const int *vals;
	struct {
		int input;	// Current position in window */
		int scroll;	// Amount of horizontal scrolling so far */
	}x;
	char buf[20];
	int optlen;
	bool hexmode;
	/*~PROTOBEG~ FIELD_CHECK_MULTI_VAL */
public:
	FIELD_CHECK_MULTI_VAL (const char *_prompt,
		 int &_var,
		 const int _vals[],
		 const char *_options[],
		 bool _hexmode);
	void dokey (WINDOW *dialog,
		 int key,
		 FIELD_MSG&);
	void drawtxt (WINDOW *dialog);
private:
	int getcurval (void)const;
public:
	void gui_draw (int nof, int &);
	void gui_get (int nof);
	void html_draw (int nof);
	int html_validate (int nof);
	void reload (const char *dianame,
		 int nof);
	void restore (void);
	void save (void);
	void setcursor (WINDOW *dialog);
	/*~PROTOEND~ FIELD_CHECK_MULTI_VAL */
};

PUBLIC FIELD_CHECK_MULTI_VAL::FIELD_CHECK_MULTI_VAL(
	const char *_prompt,
	int &_var,
	const int _vals[],			// Value corresponding to the titles
	const char *_options[],
	bool _hexmode)
	: FIELD_CHECK_MULTI (_prompt,cvar,_options), numvar(_var)
{
	hexmode = _hexmode;
	backup = numvar;
	vals = _vals;
	reload(NULL,0);
	box.width += 10;
	x.input = x.scroll = 0;
	buf[0] = '\0';
	if (val == options.getnb()){
		snprintf (buf,sizeof(buf)-1,hexmode ? "%x": "%d",backup);
	}
	optlen = 0;
	for (int i=0; _options[i] != NULL; i++){
		const char *str = _options[i];
		optlen += strlen(str)+4+1;
	}
}

/*
	Compute the current value of the field.
	It is using either the value associated with the checkbox or
	the text input field
*/
PRIVATE int FIELD_CHECK_MULTI_VAL::getcurval() const
{
	int ret = 0;
	if (val == options.getnb()){
		if (buf[0] == '\0'){
			ret = vals[0];
		}else if (hexmode){
			sscanf (buf,"%x",&ret);
		}else{
			ret = atoi(buf);
		}
	}else{
		ret = vals[val];
	}
	return ret;
}


PUBLIC void FIELD_CHECK_MULTI_VAL::save( )
{
	numvar = getcurval();
}
PUBLIC void FIELD_CHECK_MULTI_VAL::restore( )
{
	numvar = backup;
	FIELD_CHECK_MULTI::restore();
}
PUBLIC void FIELD_CHECK_MULTI_VAL::reload(const char *dianame, int nof)
{
	int nbopt = options.getnb();
	for (int i=0; i<nbopt; i++){
		if (vals[i] == numvar){
			cvar = (char)i;
			break;
		}
		cvar = (char)(i+1);
	}
	FIELD_CHECK_MULTI::reload(dianame,nof);
	buf[0] = 0;
	if (val == options.getnb()){
		snprintf (buf,sizeof(buf)-1,hexmode ? "%x": "%d",backup);
	}
}

PUBLIC void FIELD_CHECK_MULTI_VAL::drawtxt (
	WINDOW *dialog)
{
	FIELD_CHECK_MULTI::drawtxt(dialog);
	wmove(dialog, box.y,box.x+optlen);
	if (val < options.getnb()){
		for (int i=0; i<10; i++){
			waddch (dialog,'_');
		}
	}else{
		for (int i=0; i<10 && buf[i] >= '0'; i++){
			waddch (dialog,buf[i]);
		}
	}
}

PUBLIC void FIELD_CHECK_MULTI_VAL::setcursor (WINDOW *dialog)
{
	if (val == options.getnb()){
		wmove (dialog,box.y,box.x+optlen+x.input-x.scroll);
	}else{
		FIELD_CHECK_MULTI::setcursor(dialog);
	}
}


PUBLIC void FIELD_CHECK_MULTI_VAL::dokey (
	WINDOW *dialog,
	int key,
	FIELD_MSG &)
{
	int nbopt = options.getnb();
	if (val == nbopt){
		// Now we are editing the text field
		int newval = -1;
		switch (key){
		case KEY_HOME:
			newval = 0;
			break;
		case KEY_LEFT:
			if (x.input == 0 && x.scroll == 0){
				newval = nbopt-1;
			}
			break;
		}
		if (newval != -1){
			val = newval;
			drawtxt (dialog);
		}else if (field_editline (dialog,false,key,10,box.y,box.x+optlen
			,10,x.input,x.scroll,buf)){
			drawtxt (dialog);
		}
	}else{
		char lastopt = (char)(nbopt-1);
		char newval = val;
		switch (key){
		case ' ':
		case KEY_RIGHT:
			newval = val + 1;
			break;
		case KEY_HOME:
			newval = 0;
			break;
		case 5:		/* ^E like Emacs */
		case KEY_END:
			newval = lastopt;
			break;
		case KEY_LEFT:
			if (newval == 0){
				newval = lastopt;
			}else{
				newval--;
			}
			break;
		}
		if (newval != val){
			val = newval;
			drawtxt (dialog);
		}
	}
}

PUBLIC void FIELD_CHECK_MULTI_VAL::html_draw(int nof)
{
	char key[100];
	format_htmlkey (key,nof);
	html_defvarcur(key,getcurval());
	FIELD_CHECK_MULTI::html_draw (nof);
	// We generate one more radio as compared with FIELD_CHECK_MULTI
	// The supplementary radio enable the text field
	int n = options.getnb();
	html_defvar ("radio",key,n,val == n ? "checked" : "");
	strcat (key,"-s");
	html_defvar ("text",key,buf,"size=10");
}
PUBLIC int FIELD_CHECK_MULTI_VAL::html_validate(int nof)
{
	int ret = -1;
	char key[100];
	format_htmlkey (key,nof);
	int oldval = atoi(html_getoldval(key));
	if (getcurval() == oldval){
		ret = 0;
		val = atoi(html_getval(key));
		strcat (key,"-s");
		strcpy_cut (buf,html_getval(key),10);
	}
	return ret;
}

PUBLIC void FIELD_CHECK_MULTI_VAL::gui_draw(int nof, int &)
{
	diagui_send_Label (prompt);
	int n = options.getnb();
	diagui_sendcmd (P_Form,"F%d\n",nof);
	for (int i=0; i<n; i++){
		const char *str = options.getitem(i)->get();
		char tmp[1000];
		diagui_sendcmd (P_Radio,"R%d %d %d %s\n",nof,i,i==val
			,diagui_quote(str,tmp));
	}
	diagui_sendcmd (P_Radio,"R%d %d %d %s\n",nof,n,n==val,"");
	char tmp[1000];
	diagui_sendcmd (P_String,"S%d %d %s\n",nof,10,diagui_quote(buf,tmp));
	diagui_sendcmd (P_End,"\n");
}
PUBLIC void FIELD_CHECK_MULTI_VAL::gui_get(int nof)
{
	val = atoi(diagui_getval('R',nof));
	strcpy_cut (buf,diagui_getval('S',nof),10);
}



PUBLIC FIELD_CHECK_MULTI *DIALOG::newf_chkm_num(
	const char *prompt,
	int &var,
	const int vals[],			// Value corresponding to the options
	const char *options[])
{
	FIELD_CHECK_MULTI *s = new FIELD_CHECK_MULTI_VAL(prompt,var,vals
		,options,false);
	add (s);
	return s;
}

PUBLIC FIELD_CHECK_MULTI *DIALOG::newf_chkm_hexnum(
	const char *prompt,
	int &var,
	const int vals[],			// Value corresponding to the options
	const char *options[])
{
	FIELD_CHECK_MULTI *s = new FIELD_CHECK_MULTI_VAL(prompt,var,vals
		,options,true);
	add (s);
	return s;
}


