#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <misc.h>
#include "internal.h"
#include "../paths.h"
#include "apache.m"
#include <userconf.h>
#include <subsys.h>
#include <translat.h>


static APACHE_HELP_FILE help_httpd ("httpd");

static const char subsys_httpd[]="httpd";
static LINUXCONF_SUBSYS subb (subsys_httpd,P_MSG_R(M_APACHE));


CONFIG_FILE httpd_conf ("/etc/httpd/conf/httpd.conf",help_httpd
		,CONFIGF_OPTIONNAL|CONFIGF_MANAGED,subsys_httpd);

static PRIVILEGE p_apache ("apache"
	,P_MSG_U(T_PRIVIAPACHE,"Apache administration")
	,P_MSG_U(T_SERVICES,"1-Services"));

/* #Specification: httpd config / principle
	Linuxconf supports the apache httpd server. While the apache server
	share most of its configuration file format with ncsa httpd, I have not
	made any attempt at "virtualizing" linuxconf. Linuxconf hope to really
	support Apache closer and closer.

	It is expect that linuxconf will grow into something more modular one
	day and modules will be available to manage other things than apache
	if this is needed.
*/

static const char HTTPD[]="HTTPD";
static const char PORT[]="Port";
#if 0
	static const char USER[]="User";
	static const char GROUP[]="Group";
#endif
static const char SERVERTYPE[]="ServerType";
static const char PIDFILE[]="PidFile";
static const char STARTSERVERS[]="StartServers";
static const char MAXCLIENTS[]="MaxClients";
static const char MAXREQUESTSPERCHILD[]="MaxRequestsPerChild";
static const char VIRTUALHOST[]="VirtualHost";
static const char TIMEOUT[]="Timeout";
static const char MINSPARESERVERS[]="MinSpareServers";
static const char MAXSPARESERVERS[]="MaxSpareServers";
static const char SCOREBOARDFILE[]="ScoreBoardFile";
static const char KEEPALIVE[]="KeepAlive";
static const char AUTHUSERFILE[] = "AuthUserFile";
static const char AUTHGROUPFILE[] = "AuthGroupFile";
static const char KEEPALIVETIMEOUT[]="KeepAliveTimeout";
static const char MAXKEEPALIVEREQ[] = "MaxKeepAliveRequests";

static const char SERVERADMIN[]="ServerAdmin";
static const char SERVERNAME[]="ServerName";
static const char SERVERALIAS[]="ServerAlias";
static const char SERVERROOT[]="ServerRoot";
static const char DOCUMENTROOT[]="DocumentRoot";
static const char ERRORLOG[]="ErrorLog";
static const char REFERERLOG[]="RefererLog";
static const char TRANSFERLOG[]="TransferLog";
static const char AGENTLOG[]="AgentLog";
static const char DIRECTORY[]="Directory";
static const char DIRECTORYMATCH[]="DirectoryMatch";
static const char FILES[] = "Files";
static const char FILESMATCH[] = "FilesMatch";
static const char INDEXES[]="Indexes";
static const char FOLLOWSYMLINKS[]="FollowSymlinks";
static const char ALLOWOVERRIDE[]="AllowOverride";
static const char HOSTNAMELOOKUPS[]="HostnameLookups";
static const char EXECCGI[]="ExecCgi";
static const char INCLUDES[]="Includes";
static const char INCLUDESNOEXEC[]="IncludesNOEXEC";
static const char MULTIVIEWS[]="MultiViews";
static const char SYMLINKSIFOWNERMATCH[]="SymLinksIfOwnerMatch";
static const char OPTIONS[]="Options";
static const char ALL[]="All";
static const char NONE[]="None";
static const char AUTHCONFIG[]="AuthConfig";
static const char FILEINFO[]="FileInfo";
static const char LIMIT[]="Limit";
static const char SCRIPTALIAS[]="ScriptAlias";
static const char SETUIDUSER[]="User";
static const char SETUIDGROUP[]="Group";
static const char NAMEVIRTUALHOST[]="NameVirtualHost";


static const char IFMODULE [] = "IfModule";
static const char SSLIDENT [] = "mod_ssl.c";
// mod_ssl parsing

static const char SSLPASSPHRASEDIALOG [] = "SSLPassPhraseDialog";
static const char SSLSESSIONCACHE [] = "SSLSessionCache";
static const char SSLMUTEX [] = "SSLMutex";
static const char SSLLOG [] = "SSLLog";
static const char SSLLOGLEVEL [] = "SSLLogLevel";
static const char SSLENGINE [] = "SSLEngine";
static const char SSLPROTO [] = "SSLProtocol";
static const char SSLCIPHERSUITE [] = "SSLCipherSuite";
static const char SSLCERTFILE [] = "SSLCertificateFile";
static const char SSLCERTKEYFILE [] = "SSLCertificateKeyFile";
static const char SSLCACERTPATH [] = "SSLCACertificatePath";
static const char SSLCAFILE [] = "SSLCACertificateFile";
static const char SSLVERIFYCLIENT [] = "SSLVerifyClient";
static const char SSLOPTIONS [] = "SSLOptions";
static const char SSLREQUIRESSL [] = "SSLRequireSSL";
static const char SSLREQUIRE [] = "SSLRequire";
static const char SSLRANDOMSEED [] = "SSLRandomSeed";
static const char SSLSESSIONCACHETIMEOUT [] = "SSLSessionCacheTimeout";
static const char SSLVERIFYDEPTH [] = "SSLVerifyDepth";

static const char LOADMODULE[] = "LoadModule";
static const char ADDMODULE[] = "AddModule";
static const char CLEARMODULELIST[] = "ClearModuleList";




PUBLIC HTTPD_UNKNOWN *HTTPD_UNKNOWNS::getitem(int no)
{
	return (HTTPD_UNKNOWN*)ARRAY::getitem(no);
}

PUBLIC HTTPD_DOMAIN *HTTPD_DOMAINS::getitem(int no)
{
	return (HTTPD_DOMAIN*)ARRAY::getitem(no);
}

static void writeif (
	FILE *fout,
	const char *prefix,
	const char *title,
	CSSTRING &s)
{
	if (!s.is_empty()){
		comment_write (s.comment,fout);
		fprintf (fout,"%s%s %s\n",prefix,title,s.get());
	}
}


PUBLIC void HTTPD_FEATURES::setallopt(int val)
{
	char cval = (val != 0) ? 1 : 0;
	symlinksifownermatch = cval;
	execcgi = cval;
	multiviews = cval;
	includes = cval;
	includesnoexec = cval;
	indexes=cval;
	followsymlinks=cval;
}

PUBLIC HTTPD_FEATURES::HTTPD_FEATURES()
{
	setallopt (0);
}

PUBLIC void HTTPD_OVERRIDE::write (const char *prefix, FILE *fout)
{
	char buf[1000];
	comment_write(comment,fout);
	int len = sprintf (buf,"%s%s",prefix,ALLOWOVERRIDE);
	int startlen = len;
	if (authconfig) len += sprintf (buf+len," %s",AUTHCONFIG);
	if (fileinfo) len += sprintf (buf+len," %s",FILEINFO);
	if (indexes) len += sprintf (buf+len," %s",INDEXES);
	if (limit) len += sprintf (buf+len," %s",LIMIT);
	if (options) len += sprintf (buf+len," %s",OPTIONS);

	if (startlen != len) fprintf (fout,"%s\n",buf);
}

PUBLIC void HTTPD_FEATURES::write (const char *prefix, FILE *fout)
{
	char buf[1000];
	comment_write(comment,fout);
	int len = sprintf (buf,"%s%s",prefix,OPTIONS);
	int startlen = len;
	if (execcgi) len += sprintf (buf+len," %s",EXECCGI);
	if (includes) len += sprintf (buf+len," %s",INCLUDES);
	if (includesnoexec) len += sprintf (buf+len," %s",INCLUDESNOEXEC);
	if (multiviews) len += sprintf (buf+len," %s",MULTIVIEWS);
	if (indexes) len += sprintf (buf+len," %s",INDEXES);
	if (followsymlinks) len += sprintf (buf+len," %s",FOLLOWSYMLINKS);
	if (symlinksifownermatch) len += sprintf (buf+len," %s",SYMLINKSIFOWNERMATCH);

	if (startlen != len) fprintf (fout,"%s\n",buf);
}

PRIVATE void HTTPD_DIR::init()
{
	SSLVerifyDepth = 1;
	SSLRequireSSL = 0;
}

PUBLIC HTTPD_DIR::HTTPD_DIR (const char *path)
{
	this->path.setfrom (path);
	init();
}
PUBLIC HTTPD_DIR::HTTPD_DIR ()
{
	init();
}

PUBLIC void HTTPD_DIR::write (FILE *fout)
{
	const char *prefix = "\t";

	if(dmode == d_DIR)
		fprintf (fout,"<%s %s>\n",DIRECTORY,path.get());
	else if(dmode == d_DIRMATCH)
		fprintf (fout,"<%s %s>\n",DIRECTORYMATCH,path.get());
	else if(dmode == d_FILE)
		fprintf (fout,"<%s %s>\n",FILES,path.get());
	else if(dmode == d_FILEMATCH)
		fprintf (fout,"<%s %s>\n",FILESMATCH,path.get());


	feats.write (prefix,fout);
	over.write(prefix,fout);

	int n = auths.getnb();

	for(int i = 0; i<n; i++){
		writeif (fout,prefix,AUTHUSERFILE,auths.getitem(i)->file);
	}

	writeif (fout,prefix,AUTHGROUPFILE,AuthGroupFile);

	writeif (fout,prefix,SSLCIPHERSUITE,SSLCipherSuite);
	writeif (fout,prefix,SSLVERIFYCLIENT,SSLVerifyClient);
	writeif (fout,prefix,SSLOPTIONS,SSLOptions);
	writeif (fout,prefix,SSLREQUIRE,SSLRequire);

	if(SSLRequireSSL) {
		comment_write(SSLRequireSSLC,fout);
		fprintf(fout,"%s%s\n",prefix,SSLREQUIRESSL);
	}
	if(SSLVerifyDepth != 1)	{
		comment_write(SSLVerifyDepthC,fout);
		fprintf(fout,"%s%s %d\n",prefix,SSLVERIFYDEPTH,SSLVerifyDepth);
	}
	for (int i=0; i<tbunknown.getnb(); i++){
		CSSTRING *cs = (CSSTRING*)tbunknown.getitem(i);
		comment_write (cs->comment,fout);
		fprintf (fout,"%s\n",cs->get());
	}

	if(dmode == d_DIR)
		fprintf (fout,"</%s>\n",DIRECTORY);
	else if(dmode == d_DIRMATCH)
		fprintf (fout,"</%s>\n",DIRECTORYMATCH);
	else if(dmode == d_FILE)
		fprintf (fout,"</%s>\n",FILES);
	else if(dmode == d_FILEMATCH)
		fprintf (fout,"</%s>\n",FILESMATCH);
}

PUBLIC void HTTPD_DIRS::write (FILE *fout)
{
	int n = getnb();
	for (int i=0; i<n; i++){
		getitem(i)->write (fout);
	}
}

PUBLIC HTTPD_DOMSSL::HTTPD_DOMSSL ()
{
	opts.SSLVerifyDepth = 1;
	opts.SSLSessionCacheTimeout = 300;
	opts.SSLEngine = 0;
}

PUBLIC void HTTPD_SSL::write(FILE *fout) {
	char *prefix = "";
	if(cwrite == true) {
		fprintf (fout,"<%s %s>\n",IFMODULE,SSLIDENT);

		writeif (fout,prefix,SSLCIPHERSUITE,opts.SSLCipherSuite);
		writeif (fout,prefix,SSLVERIFYCLIENT,opts.SSLVerifyClient);
		writeif (fout,prefix,SSLOPTIONS,opts.SSLOptions);
		writeif (fout,prefix,SSLPROTO,opts.SSLProtocol);
		writeif (fout,prefix,SSLCERTFILE,opts.SSLCertificateFile);
		writeif (fout,prefix,SSLCERTKEYFILE,opts.SSLCertificateKeyFile);
		writeif (fout,prefix,SSLLOG,opts.SSLLog);
		writeif (fout,prefix,SSLLOGLEVEL,opts.SSLLogLevel);
		writeif (fout,prefix,SSLCAFILE,opts.SSLCACertificateFile);
		writeif (fout,prefix,SSLCACERTPATH,opts.SSLCACertificatePath);
		writeif (fout,prefix,SSLMUTEX,SSLMutex);
		writeif (fout,prefix,SSLPASSPHRASEDIALOG,SSLPassPhraseDialog);
		writeif (fout,prefix,SSLSESSIONCACHE,SSLSessionCache);

		if(opts.SSLVerifyDepth != 1)	{
			comment_write(opts.SSLVerifyDepthC,fout);
			fprintf(fout,"%s%s %d\n",prefix,SSLVERIFYDEPTH,opts.SSLVerifyDepth);
		}

		if(opts.SSLSessionCacheTimeout != 300) {
			comment_write(opts.SSLSessionCacheTimeoutC,fout);
			fprintf(fout,"%s%s %d\n",prefix,SSLSESSIONCACHETIMEOUT
				,opts.SSLSessionCacheTimeout);
		}

		if(opts.SSLEngine) {
			comment_write(opts.SSLEngineC,fout);
			fprintf(fout,"%s%s %s\n",prefix,SSLENGINE,"on");
		}
		for (int i=0; i<SSLRandomSeed.getnb(); i++){
			CSSTRING *cs = (CSSTRING*)SSLRandomSeed.getitem(i);
			writeif (fout,prefix,SSLRANDOMSEED,*cs);
		}
		fprintf(fout,"</%s>\n",IFMODULE);
	}
}


PUBLIC void HTTPD_UNKNOWN::write(FILE *fout)
{
	fprintf(fout,"<%s %s>\n",name.get(), param.get());
  
	for (int i=0; i<dirs.getnb(); i++){
		dirs.getitem(i)->write(fout);
		fputs ("\n",fout);
	}

	for (int i=0; i<doms.getnb(); i++){
		doms.getitem(i)->write(fout);
		fputs ("\n",fout);
	}

	for (int i=0; i<tbunknown.getnb(); i++){
		CSSTRING *cs = (CSSTRING*)tbunknown.getitem(i);
		comment_write (cs->comment,fout);
		fprintf (fout,"%s\n",cs->get());
	}
	fprintf(fout,"</%s>\n",name.get());
}

PUBLIC void HTTPD_DOMSSL::write(const char *prefix, FILE *fout)
{
	writeif (fout,prefix,SSLCIPHERSUITE,opts.SSLCipherSuite);
	writeif (fout,prefix,SSLVERIFYCLIENT,opts.SSLVerifyClient);
	writeif (fout,prefix,SSLOPTIONS,opts.SSLOptions);
	writeif (fout,prefix,SSLPROTO,opts.SSLProtocol);
	writeif (fout,prefix,SSLCERTFILE,opts.SSLCertificateFile);
	writeif (fout,prefix,SSLCERTKEYFILE,opts.SSLCertificateKeyFile);
	writeif (fout,prefix,SSLLOG,opts.SSLLog);
	writeif (fout,prefix,SSLLOGLEVEL,opts.SSLLogLevel);
	writeif (fout,prefix,SSLCAFILE,opts.SSLCACertificateFile);
	writeif (fout,prefix,SSLCACERTPATH,opts.SSLCACertificatePath);

	if(opts.SSLVerifyDepth != 1)	{
		comment_write(opts.SSLVerifyDepthC,fout);
		fprintf(fout,"%s%s %d\n",prefix,SSLVERIFYDEPTH,opts.SSLVerifyDepth);
	}

	if(opts.SSLSessionCacheTimeout != 300) {
		comment_write(opts.SSLSessionCacheTimeoutC,fout);
		fprintf(fout,"%s%s %d\n",prefix,SSLSESSIONCACHETIMEOUT,
		opts.SSLSessionCacheTimeout);
	}

	if(opts.SSLEngine) {
		comment_write(opts.SSLEngineC,fout);
		fprintf(fout,"%s%s %s\n",prefix,SSLENGINE,"on");
	}
}


PUBLIC void HTTPD_DOMOPT::write(const char *prefix, FILE *fout)
{
	writeif (fout,prefix,SERVERADMIN,serveradmin);
	writeif (fout,prefix,NAMEVIRTUALHOST,namevhost);
	writeif (fout,prefix,SERVERNAME,servername);
	writeif (fout,prefix,DOCUMENTROOT,documentroot);
	writeif (fout,prefix,ERRORLOG,errorlog);
	writeif (fout,prefix,REFERERLOG,refererlog);
	writeif (fout,prefix,TRANSFERLOG,transferlog);
	writeif (fout,prefix,AGENTLOG,agentlog);
	writeif (fout,prefix,SCRIPTALIAS,scriptalias);
	writeif (fout,prefix,SETUIDUSER,setuiduser);
	writeif (fout,prefix,SETUIDGROUP,setuidgroup);	feats.write (prefix,fout);
	for (int i=0; i<unks.getnb(); i++){
		unks.getitem(i)->write(fout);
		fputs ("\n",fout);
	}
	for (int i=0; i<tbunknown.getnb(); i++){
		CSSTRING *cs = (CSSTRING*)tbunknown.getitem(i);
		comment_write (cs->comment,fout);
		fprintf (fout,"%s\n",cs->get());
	}
}

PUBLIC HTTPD_UNKNOWN::HTTPD_UNKNOWN(const char *cname, const char *cparam)
{
	name.setfrom (cname);
	param.setfrom (cparam);
}

PUBLIC HTTPD_UNKNOWN::HTTPD_UNKNOWN()
{
}

PUBLIC HTTPD_UNKNOWNS::HTTPD_UNKNOWNS()
{
}

PUBLIC HTTPD_USER *HTTPD_USERS::getitem(int no)
{
   return (HTTPD_USER *)ARRAY::getitem(no);
}
PUBLIC HTTPD_USERS::HTTPD_USERS (void) {

}
PUBLIC HTTPD_USERS *HTTPD_AUTHS::getitem(int no)
{
   return (HTTPD_USERS *)ARRAY::getitem(no);
}

PUBLIC HTTPD_DOMAIN::HTTPD_DOMAIN()
{
}
PUBLIC HTTPD_SSL::HTTPD_SSL() {
	opts.SSLVerifyDepth = 1;
	opts.SSLSessionCacheTimeout = 300;
	opts.SSLEngine = 0;
}

PUBLIC HTTPD_DOMAIN::HTTPD_DOMAIN(const char *domain)
{
	name.setfrom (domain);
}
PUBLIC void HTTPD_DOMAIN::write(FILE *fout)
{
	fprintf (fout,"<%s %s>\n",VIRTUALHOST,name.get());
	opt.write ("\t",fout);
	writeif (fout,"\t",SERVERALIAS,serveralias);
	dirs.write (fout);
	ssl.write ("\t",fout);
	fprintf (fout,"</%s>\n",VIRTUALHOST);
}

PUBLIC HTTPD_CONFIG::HTTPD_CONFIG()
{
	int sslmode = OUT;
	char *lastmod = NULL;
	mode = NORMAL;
	int omode = NORMAL; /* virtual domain old mode */
	int d_omode = NORMAL; /* directory old mode */
	port = 80;
	startservers = 5;
	maxkeepalivereq = 100;
	maxclients = 150;
	maxrequestsperchild = 30;
	minspareservers = 5;
	maxspareservers = 10;
	keepalive = 1;
	keepalive_timeout = 5;
	servertype = 0;
	hostnamelookups = 0;
	pidfile.setfrom ("logs/httpd.pid");
	#if 0
		user.setfrom ("nobody");
		group.setfrom ("nobody");
	#endif
	defdom.setuiduser.setfrom ("nobody");
	defdom.setuidgroup.setfrom ("nobody");
	timeout = 400;
	scoreboardfile.setfrom ("logs/apache_runtime_status");
	ClearModuleList = 0;
	FILE *fin = httpd_conf.fopen ("r");
	if (fin != NULL){
		char buf[3000];
		SSTRING comments;
		HTTPD_DOMOPT *dom = &defdom;
		HTTPD_DOMAIN *vdom = NULL;
		HTTPD_DIRS *ptdirs = &dirs;
		HTTPD_DIR *ptdir = NULL;
		HTTPD_DOMSSL *domssl = NULL;
		HTTPD_SSL *ssl = &defssl;
		HTTPD_FEATURES *ptfeats = &dom->feats;
		HTTPD_UNKNOWNS *unks = &dom->unks;
		HTTPD_UNKNOWN *unk = NULL;
		SSTRINGS *tbunk = &dom->tbunknown;

		while (fgets_comments(buf,sizeof(buf)-1,fin,comments)!=NULL){
			char *pt = str_skip (buf);
			if (*pt == '<'){
				pt++;
				bool endscope = false;
				if (*pt == '/'){
					endscope = true;
					pt++;
				}
				char *end = strchr (pt,'>');
				if (end != NULL) *end = '\0';
				char word[200],word2[200];
				char *arg = str_copyword (word,pt,sizeof(word));
				str_copyword (word2,arg,sizeof(word2));
				if (stricmp(word,VIRTUALHOST)==0){
					if (endscope){
						dom = &defdom;
						ptdirs = &dirs;
						unks = &dom->unks;
						domssl = NULL;
						vdom = NULL;
						tbunk = &dom->tbunknown;
						if (omode == UNKNOWN) mode = UNKNOWN;
					}else{
						vdom = new HTTPD_DOMAIN (word2);

						if(mode == NORMAL){
							domains.add (vdom);
							omode = NORMAL;

						}else if(mode == UNKNOWN) {
							unk->doms.add (vdom);

							omode = UNKNOWN;
							mode = NORMAL;
						}

						dom = &vdom->opt;
						ptdirs = &vdom->dirs;
						unks = &vdom->opt.unks;
						domssl = &vdom->ssl;
						ptfeats = &dom->feats;
						tbunk = &vdom->opt.tbunknown;
					}
					ptfeats = &dom->feats;
				}else if (stricmp(word,DIRECTORY)==0
					|| stricmp(word,DIRECTORYMATCH) == 0
					|| stricmp(word,FILES) == 0
					|| stricmp(word,FILESMATCH) == 0){
					if (endscope){
						dom = &defdom;
						ptdirs = &dirs;
						ptfeats = &dom->feats;
						unks = &dom->unks;
						tbunk = &dom->tbunknown;
						ptdir = NULL;
						if(d_omode == UNKNOWN) {
							mode = UNKNOWN;
							d_omode = NORMAL;
						}
					}else{
						ptdir = new HTTPD_DIR (word2);
						if(stricmp(word,DIRECTORY) == 0){
							ptdir->dmode = d_DIR;
						}else if(stricmp(word,DIRECTORYMATCH) == 0){
							ptdir->dmode = d_DIRMATCH;
						}else if(stricmp(word,FILES) == 0){
							ptdir->dmode = d_FILE;
						}else if(stricmp(word,FILESMATCH) == 0){
							ptdir->dmode = d_FILEMATCH;
						}
						if(mode == NORMAL) {
							ptdirs->add (ptdir);
						}else if(mode == UNKNOWN) {
							unk->dirs.add (ptdir);
							d_omode = UNKNOWN;
							mode = NORMAL;
/* if we reach this place, we are inside a <Unknown> directive and found a
<Directory> in it. We set the mode to normal so the parser will configure
this <Directory> as another one. d_omode is for when we reach </Directory>,
then we set mode to UNKNOWN again. The same thing applies to <VirtualHost>
  - Marcelo
*/
						}
						ptfeats = &ptdir->feats;
						unks = &ptdir->unks;
						tbunk = &ptdir->tbunknown;
					}
				}else if (stricmp(word,IFMODULE)==0
					&& !endscope
					&& stricmp(word2,SSLIDENT)==0) {
					sslmode = IN;
					ssl->cwrite = true;
					lastmod = (char *)malloc(sizeof(word2));
					if(lastmod != NULL){
						strncpy(lastmod,word2,sizeof(word2));
					}
				}else if (stricmp(word,IFMODULE)==0
					&& endscope
					&& lastmod != NULL
					&& stricmp(lastmod,SSLIDENT)==0) {
					free(lastmod);
					sslmode = OUT;
				}else{
					if(endscope){
						mode = NORMAL;
						unk = NULL;
					}else{
						unk = new HTTPD_UNKNOWN(word,word2);
						unks->add(unk);
						mode = UNKNOWN;
				 	}
				}
			}else{
				char word[200];
				const char *arg = str_copyword (word,pt,sizeof(word));
				arg = str_skip(arg);
				if(mode == NORMAL) {
					if(stricmp(word,LOADMODULE)==0) {
						CSSTRING *cs = new CSSTRING;
						cs->setfrom_c(arg,comments);
						lmodules.add(cs);
						continue;
					}
					if(stricmp(word,ADDMODULE)==0) {
						CSSTRING *cs = new CSSTRING;
						cs->setfrom_c(arg,comments);
						amodules.add(cs);
						continue;
					}
					if(stricmp(word,CLEARMODULELIST)==0) {
						ClearModuleList = 1;
						ClearModuleListC.setfrom(comments);
						continue;
					}
					if(sslmode == IN) {
						/* we are inside <IfModule mod_ssl.c>  */
						if (stricmp(word,SSLPASSPHRASEDIALOG)==0){
							ssl->SSLPassPhraseDialog.setfrom_c(arg,comments);
							continue;
						}else if (stricmp(word,SSLSESSIONCACHE)==0){
							ssl->SSLSessionCache.setfrom_c(arg,comments);
							continue;
						}else if (stricmp(word,SSLMUTEX)==0){
							ssl->SSLMutex.setfrom_c(arg,comments);
							continue;
						}else if (stricmp(word,SSLLOGLEVEL)==0){
							ssl->opts.SSLLogLevel.setfrom_c(arg,comments);
							continue;
						}else if (stricmp(word,SSLENGINE)==0 &&
									stricmp(arg,"on") == 0){
							ssl->opts.SSLEngineC.setfrom(comments);
							ssl->opts.SSLEngine = 1;
							continue;
						}else if (stricmp(word,SSLCERTKEYFILE)==0){
							ssl->opts.SSLCertificateKeyFile.setfrom_c(arg,comments);
							continue;
						}else if (stricmp(word,SSLPROTO)==0){
							ssl->opts.SSLProtocol.setfrom_c(arg,comments);
							continue;
						}else if (stricmp(word,SSLCIPHERSUITE)==0){
							ssl->opts.SSLCipherSuite.setfrom_c(arg,comments);
							continue;
						}else if (stricmp(word,SSLCERTFILE)==0){
							ssl->opts.SSLCertificateFile.setfrom_c(arg,comments);
							continue;
						}else if (stricmp(word,SSLCACERTPATH)==0){
							ssl->opts.SSLCACertificatePath.setfrom_c(arg,comments);
							continue;
						}else if (stricmp(word,SSLCAFILE)==0){
							ssl->opts.SSLCACertificateFile.setfrom_c(arg,comments);
							continue;
						}else if (stricmp(word,SSLSESSIONCACHE)==0){
							ssl->SSLSessionCache.setfrom_c(arg,comments);
							continue;
						}else if (stricmp(word,SSLLOG)==0){
							ssl->opts.SSLLog.setfrom_c(arg,comments);
							continue;
						}else if (stricmp(word,SSLOPTIONS)==0){
							ssl->opts.SSLOptions.setfrom_c(arg,comments);
							continue;
						}else if (stricmp(word,SSLSESSIONCACHETIMEOUT)==0){
							ssl->opts.SSLSessionCacheTimeoutC.setfrom(comments);
							ssl->opts.SSLSessionCacheTimeout = atoi(arg);
							continue;
						}else if (stricmp(word,SSLVERIFYDEPTH)==0){
							ssl->opts.SSLVerifyDepthC.setfrom(comments);
							ssl->opts.SSLVerifyDepth = atoi(arg);
							continue;
						}else if (stricmp(word,SSLVERIFYCLIENT)==0){
							ssl->opts.SSLVerifyClient.setfrom_c(arg,comments);
							continue;
						}else if (stricmp(word,SSLRANDOMSEED)==0){
							CSSTRING *cs = new CSSTRING;
							cs->setfrom_c (arg,comments);
							ssl->SSLRandomSeed.add (cs);
							continue;
						}
					}
					if (ptdir != NULL) { 
                       if (stricmp(word,AUTHUSERFILE)==0){
                           HTTPD_USERS *users = new HTTPD_USERS;
                           users->file.setfrom_c(arg,comments);
                           ptdir->auths.add(users);
                           continue;
                       }else if (stricmp(word,AUTHGROUPFILE)==0){
							ptdir->AuthGroupFile.setfrom_c(arg,comments);
							continue;
                       /* directory ssl options */
                       }else if (stricmp(word,SSLCIPHERSUITE)==0){
							ptdir->SSLCipherSuite.setfrom_c(arg,comments);
							continue;
						}else if (stricmp(word,SSLOPTIONS)==0){
							ptdir->SSLOptions.setfrom_c(arg,comments);
							continue;
						}else if (stricmp(word,SSLREQUIRE)==0){
							ptdir->SSLRequire.setfrom_c(arg,comments);
							continue;
						}else if (stricmp(word,SSLVERIFYCLIENT)==0){
							ptdir->SSLVerifyClient.setfrom_c(arg,comments);
							continue;
						}else if (stricmp(word,SSLREQUIRESSL)==0){
							ptdir->SSLRequireSSLC.setfrom(comments);
							ptdir->SSLRequireSSL = 1;
							continue;
						}
					}
					if (domssl != NULL) { /* vhost ssl options */
						if (stricmp(word,SSLPROTO)==0){
							domssl->opts.SSLProtocol.setfrom_c(arg,comments);
							continue;
						}else if (stricmp(word,SSLVERIFYCLIENT)==0){
							domssl->opts.SSLVerifyClient.setfrom_c(arg,comments);
							continue;
						}else if (stricmp(word,SSLCIPHERSUITE)==0){
							domssl->opts.SSLCipherSuite.setfrom_c(arg,comments);
							continue;
						}else if (stricmp(word,SSLCERTFILE)==0){
							domssl->opts.SSLCertificateFile.setfrom_c(arg,comments);
							continue;
						}else if (stricmp(word,SSLCACERTPATH)==0){
							domssl->opts.SSLCACertificatePath.setfrom_c(arg,comments);
							continue;
						}else if (stricmp(word,SSLCAFILE)==0){
							domssl->opts.SSLCACertificateFile.setfrom_c(arg,comments);
							continue;
						}else if (stricmp(word,SSLCERTKEYFILE)==0){
							domssl->opts.SSLCertificateKeyFile.setfrom_c(arg,comments);
							continue;
						}else if (stricmp(word,SSLLOG)==0){
							domssl->opts.SSLLog.setfrom_c(arg,comments);
							continue;
						}else if (stricmp(word,SSLLOGLEVEL)==0){
							domssl->opts.SSLLogLevel.setfrom_c(arg,comments);
							continue;
						}else if (stricmp(word,SSLVERIFYDEPTH)==0){
							domssl->opts.SSLVerifyDepthC.setfrom(comments);
							domssl->opts.SSLVerifyDepth = atoi(arg);
							continue;
						}else if (stricmp(word,SSLENGINE)==0 &&
									stricmp(arg,"on") == 0){
							domssl->opts.SSLEngineC.setfrom(comments);
							domssl->opts.SSLEngine = 1;
							continue;
						}else if (stricmp(word,SSLOPTIONS)==0){
							domssl->opts.SSLOptions.setfrom_c(arg,comments);
							continue;
						}
					}
					if (stricmp(word,SERVERADMIN)==0){
						dom->serveradmin.setfrom_c(arg,comments);
					}else if (stricmp(word,NAMEVIRTUALHOST)==0){
						dom->namevhost.setfrom_c(arg,comments);
					}else if (stricmp(word,SERVERNAME)==0){
						dom->servername.setfrom_c(arg,comments);
					}else if (stricmp(word,SERVERALIAS)==0
						&& vdom != NULL){
						vdom->serveralias.setfrom_c(arg,comments);
					}else if (stricmp(word,DOCUMENTROOT)==0){
						dom->documentroot.setfrom_c(arg,comments);
					}else if (stricmp(word,ERRORLOG)==0){
						dom->errorlog.setfrom_c(arg,comments);
					}else if (stricmp(word,REFERERLOG)==0){
						dom->refererlog.setfrom_c(arg,comments);
					}else if (stricmp(word,TRANSFERLOG)==0){
						dom->transferlog.setfrom_c(arg,comments);
					}else if (stricmp(word,AGENTLOG)==0){
						dom->agentlog.setfrom_c(arg,comments);
					}else if (stricmp(word,SCRIPTALIAS)==0){
						dom->scriptalias.setfrom_c(arg,comments);
					}else if (stricmp(word,SETUIDUSER)==0){
						dom->setuiduser.setfrom_c(arg,comments);
					}else if (stricmp(word,SETUIDGROUP)==0){
						dom->setuidgroup.setfrom_c(arg,comments);
 					}else if (stricmp(word,ALLOWOVERRIDE)==0){
						if (ptdir == NULL){
							xconf_error ("allow ptdir ==NULL");
						}else{
							HTTPD_OVERRIDE *ptover = &ptdir->over;
							while (1){
								ptover->comment.setfrom(comments);
								arg=str_copyword(word,arg,sizeof(word));
								if (word[0] == '\0'){
									break;
								}else if (stricmp(word,NONE)==0){
									ptover->setallopt(0);
								}else if (stricmp(word,ALL)==0){
									ptover->setallopt(1);
								}else if (stricmp(word,AUTHCONFIG)==0){
									ptover->authconfig = 1;
								}else if (stricmp(word,FILEINFO)==0){
									ptover->fileinfo = 1;
								}else if (stricmp(word,INDEXES)==0){
									ptover->indexes = 1;
								}else if (stricmp(word,LIMIT)==0){
									ptover->limit = 1;
								}else if (stricmp(word,OPTIONS)==0){
									ptover->options = 1;
								}
							}
						}
					}else if (stricmp(word,PORT)==0){
						comment_port.setfrom (comments);
						port = atoi(arg);
					#if 0
						}else if (stricmp(word,USER)==0){
							user.setfrom_c (arg,comments);
						}else if (stricmp(word,GROUP)==0){
							group.setfrom_c (arg,comments);
					#endif
					}else if (stricmp(word,SERVERTYPE)==0){
						comment_servertype.setfrom (comments);
						servertype = stricmp(arg,"standalone") == 0 ? 0 : 1;
					}else if (stricmp(word,SERVERROOT)==0){
						serverroot.setfrom_c (arg,comments);
					}else if (stricmp(word,PIDFILE)==0){
						pidfile.setfrom_c (arg,comments);
					}else if (stricmp(word,STARTSERVERS)==0){
						comment_startservers.setfrom (comments);
						startservers = atoi(arg);
					}else if (stricmp(word,MAXCLIENTS)==0){
						comment_maxclients.setfrom (comments);
						maxclients = atoi(arg);
					}else if (stricmp(word,MAXREQUESTSPERCHILD)==0){
						comment_maxrequestsperchild.setfrom (comments);
						maxrequestsperchild = atoi(arg);
					}else if (stricmp(word,TIMEOUT)==0){
						comment_timeout.setfrom (comments);
						timeout = atoi(arg);
					}else if (stricmp(word,MINSPARESERVERS)==0){
						comment_minspareservers.setfrom (comments);
						minspareservers = atoi(arg);
					}else if (stricmp(word,MAXSPARESERVERS)==0){
						comment_maxspareservers.setfrom (comments);
						maxspareservers = atoi(arg);
					}else if (stricmp(word,KEEPALIVE)==0){
						if(stricmp(arg,"off") == 0) {
							comment_keepalive.setfrom (comments);
							keepalive = 0;
						}
					}else if (stricmp(word,MAXKEEPALIVEREQ)==0){
						comment_keepalivereq.setfrom(comments);
						maxkeepalivereq = atoi(arg);
					}else if (stricmp(word,KEEPALIVETIMEOUT)==0){
						comment_keepalive_timeout.setfrom (comments);
						keepalive_timeout = atoi(arg);
					}else if (stricmp(word,SCOREBOARDFILE)==0){
						scoreboardfile.setfrom_c (arg,comments);
					}else if (stricmp(word,HOSTNAMELOOKUPS)==0){
						comment_hostnamelookups.setfrom (comments);
						hostnamelookups = stricmp (arg,"on")==0;
					}else if (stricmp(word,OPTIONS)==0){
						while (1){
							arg=str_copyword(word,arg,sizeof(word));
							ptfeats->comment.setfrom(comments);
							if (word[0] == '\0'){
								break;
							}else if (stricmp(word,ALL)==0){
								ptfeats->setallopt (1);
							}else if (stricmp(word,NONE)==0){
								ptfeats->setallopt (0);
							}else if (stricmp(word,INDEXES)==0){
								ptfeats->indexes = 1;
							}else if (stricmp(word,MULTIVIEWS)==0){
								ptfeats->multiviews = 1;
							}else if (stricmp(word,FOLLOWSYMLINKS)==0){
								ptfeats->followsymlinks = 1;
							}else if (stricmp(word,SYMLINKSIFOWNERMATCH)==0){
								ptfeats->symlinksifownermatch = 1;
							}else if (stricmp(word,INCLUDES)==0){
								ptfeats->includes = 1;
							}else if (stricmp(word,INCLUDESNOEXEC)==0){
								ptfeats->includesnoexec = 1;
							}else if (stricmp(word,EXECCGI)==0){
								ptfeats->execcgi = 1;
							}
						}
					}else{
						CSSTRING *cs = new CSSTRING;
						cs->setcomment (comments);
						cs->setfrom (buf);
						tbunk->add (cs);
					}
				}else if (mode == UNKNOWN) {
					CSSTRING *cs = new CSSTRING;
					cs->setcomment (comments);
					cs->setfrom (buf);
					unk->tbunknown.add(cs);
				}
			}
		}
		fclose (fin);
	}
}

PUBLIC int HTTPD_CONFIG::write ()
{
	int ret = -1;
	FILE *fout = httpd_conf.fopen (&p_apache,"w");
	if (fout != NULL){
		comment_write (comment_servertype,fout);
		fprintf (fout,"%s %s\n",SERVERTYPE,servertype ? "inetd" : "standalone");
		comment_write (comment_port,fout);
		fprintf (fout,"%s %d\n",PORT,port);
		comment_write (comment_startservers,fout);
		fprintf (fout,"%s %d\n",STARTSERVERS,startservers);
		comment_write (comment_minspareservers,fout);
		fprintf (fout,"%s %d\n",MINSPARESERVERS,minspareservers);
		comment_write (comment_maxspareservers,fout);
		fprintf (fout,"%s %d\n",MAXSPARESERVERS,maxspareservers);
		if(!keepalive) {
			comment_write (comment_keepalive,fout);
			fprintf (fout,"%s off\n",KEEPALIVE);
		}
		comment_write (comment_keepalive_timeout,fout);
		fprintf (fout,"%s %d\n",MAXKEEPALIVEREQ,maxkeepalivereq);
		comment_write (comment_keepalivereq,fout);
		fprintf (fout,"%s %d\n",KEEPALIVETIMEOUT,keepalive_timeout);
		comment_write (comment_maxclients,fout);
		fprintf (fout,"%s %d\n",MAXCLIENTS,maxclients);
		comment_write (comment_maxrequestsperchild,fout);
		fprintf (fout,"%s %d\n",MAXREQUESTSPERCHILD,maxrequestsperchild);
		comment_write (pidfile.comment,fout);
		fprintf (fout,"%s %s\n",PIDFILE,pidfile.get());
		comment_write (comment_timeout,fout);
		fprintf (fout,"%s %d\n",TIMEOUT,timeout);
		#if 0
			comment_write (user.comment,fout);
			fprintf (fout,"%s %s\n",USER,user.get());
			comment_write (group.comment,fout);
			fprintf (fout,"%s %s\n",GROUP,group.get());
		#endif
		comment_write (scoreboardfile.comment,fout);
		fprintf (fout,"%s %s\n",SCOREBOARDFILE,scoreboardfile.get());
		comment_write (serverroot.comment, fout);
		fprintf (fout,"%s %s\n",SERVERROOT,serverroot.get());

		comment_write (comment_hostnamelookups, fout);
		fprintf (fout,"%s %s\n",HOSTNAMELOOKUPS
			,hostnamelookups ? "on" : "off");

		for (int i=0; i<lmodules.getnb(); i++){
			CSSTRING *cs = (CSSTRING*)lmodules.getitem(i);
			writeif (fout,"",LOADMODULE,*cs);
		}
		if(ClearModuleList) {
			fprintf(fout,"%s\n",CLEARMODULELIST);
			comment_write(ClearModuleListC,fout);
		}
		for (int i=0; i<amodules.getnb(); i++){
			CSSTRING *cs = (CSSTRING*)amodules.getitem(i);
			writeif (fout,"",ADDMODULE,*cs);
		}


		defdom.write ("",fout);
		fprintf (fout,"\n");
		int i;
		for (i=0; i<dirs.getnb(); i++){
			dirs.getitem(i)->write(fout);
			fputs ("\n",fout);
		}
		for (i=0; i<domains.getnb(); i++){
				domains.getitem(i)->write(fout);
				fputs ("\n",fout);
		}
		for (i=0; i<unks.getnb(); i++){
			unks.getitem(i)->write(fout);
			fputs ("\n",fout);
		}
		defssl.write(fout);
		ret = fclose (fout);
	}
	return ret;
}
