#------------------------------------------------------------------------------
# Main Wcb package module.
#
# Copyright (c) 1999  Csaba Nemethi (E-mail: csaba.nemethi@t-online.de)
#------------------------------------------------------------------------------

package require Tcl 8
package require Tk  8

namespace eval wcb {
    #
    # Variables:
    #
    variable version 1.1
    variable library [file dirname [info script]]

    #
    # Basic procedures:
    #
    namespace export	callback cancel replace extend

    #
    # Simple before-insert callback routines for entry widgets:
    #
    namespace export	checkStrForAlpha checkStrForNum checkStrForAlnum \
			convStrToUpper convStrToLower

    #
    # Helper procs needed in some before-insert
    # callback routines for entry widgets:
    #
    namespace export	postInsertEntryText postInsertEntryLen

    #
    # Further before-insert callback routines for entry widgets:
    #
    namespace export	checkEntryForInt checkEntryForReal checkEntryLen

    #
    # Simple before-insert callback routines for text widgets:
    #
    namespace export	checkStrsForAlpha checkStrsForNum checkStrsForAlnum \
			convStrsToUpper convStrsToLower
}

package provide Wcb $wcb::version

lappend auto_path [file join $wcb::library scripts]
