/*
   set_therm: a sample program to setup a Netwinder Rev4/5 thermostat
   Copyright 1998  woody@corelcomputer.com

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <stdio.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/ioctl.h>
#include <fcntl.h>
#include <errno.h>
#include <stdlib.h>
#include <unistd.h>

#include "therm.h"


int
main (int argc, char **argv)
{

  int fd = 0;
  int uTemp = 0;
  int uTemp1 = 0;
  char *basename;
  char *p;
  struct THERM_SETTING th_new;
  struct THERM_SETTING th_old;

// printf("\nargc=%d, argv:[0]=%s, [1]=%s.\n\n",
  //   argc,argv[0],argv[1]);

  basename = (p = strrchr (argv[0], '/')) ? p + 1 : argv[0];

  if (argc < 2)
    {
      fprintf (stderr, "\nNetWinder Thermostat setting program, Corel Computer 1998.\nUsage: %s temperature HI [LO] (-55 ... 125 C).\n\n",
	       basename);
    }
  else if ((uTemp1 = sscanf (argv[1], "%d", &th_new.hi)) <= 0)
    {
      fprintf (stderr, "%s: unable to parse temperature (\"%s\")???.\n",
	       basename, argv[1]);
      return EXIT_FAILURE;
    }
  else if (!((argc == 3) && ((uTemp1 = sscanf (argv[2], "%d", &uTemp)) > 0)))
    {
      uTemp = th_new.hi - 2;
      fprintf (stderr, "Thermostat LO not specified, setting to %d.\n", uTemp);
    }
  th_new.lo = uTemp;

  fd = open ("/dev/temperature", O_RDWR);
  if (fd < 0)
    {
      printf ("Error %d opening /dev/temperature\n", fd);
      return EXIT_FAILURE;
    }
// else
  //  {
  //    printf("/dev/temperature open OK, rc = 0x%X.\n",fd);
  //  }


  ioctl (fd, CMD_GET_THERMOSTATE2, &th_old);
  if (!errno)
    printf ("Current thermostat setting: HI %d, LO %d...\n", th_old.hi, th_old.lo);
  else
    printf ("Error 0x%X getting thermostate setting.\n", errno);

  if (argc >= 2)
    {
      ioctl (fd, CMD_SET_THERMOSTATE2, &th_new);
      if (!errno)
	printf ("New thermostat setting: HI %d, LO %d...\n", th_new.hi, th_new.lo);
      else
	printf ("Error 0x%X setting thermostat.\n", errno);
    }

  ioctl (fd, CMD_GET_TEMPERATURE2, &uTemp1);
  if (!errno)
    ioctl (fd, CMD_GET_STATUS, &uTemp);

  if (!errno)
    printf ("Current temperature: %d.%d, status 0x%02X...\n",
	    uTemp1 >> 1, (uTemp1 & 1) ? 5 : 0, uTemp);
  else
    printf ("Error 0x%X getting temperature.\n", errno);

  if (close (fd) != 0)
    printf ("Error closing /dev/temperature\n");

  return EXIT_SUCCESS;
}
