#ifndef MBR_H
#define MBR_H

/* This file defines the interface to the encapsulated binary file
   produced by ld. */

extern u_int8_t _binary_mbr_b_start[];
extern u_int8_t _binary_mbr_b_end[];
extern u_int8_t _binary_mbr_b_size[];

#define MBR_START _binary_mbr_b_start
#define MBR_END _binary_mbr_b_end
#define MBR_SIZE ((unsigned long)_binary_mbr_b_size)

/* This defines the format of the parameters in the MBR.  It must
   match the code (mbr.S).  Everything uses uchars so that packing
   will work (unless something strange happens). */
struct mbr_params {
  u_int8_t sig[6]; /* This must be at the top */
#define MP_SIG "NDTmbr"
  u_int8_t ver_compat[2];
#define MP_VERSION 0
  u_int8_t version[2];
  u_int8_t flags;
#define MP_FLAG_EN1 1
#define MP_FLAG_EN2 2
#define MP_FLAG_EN3 4
#define MP_FLAG_EN4 8
#define MP_FLAG_ENF 16
#define MP_FLAG_ENA 128
  u_int8_t deflt;
#define MP_DEFLT_BITS 7
#define MP_DEFLT_ISHIFT 64
#define MP_DEFLT_IKEY 128
  u_int8_t delay;
#define MP_DELAY_INT 0xff
  u_int8_t drive;
#define MP_DRIVE_UNSET 0xff
};

#endif
