(****************************************************************************)
(*                 The Calculus of Inductive Constructions                  *)
(*                                                                          *)
(*                                Projet Coq                                *)
(*                                                                          *)
(*                     INRIA        LRI-CNRS        ENS-CNRS                *)
(*              Rocquencourt         Orsay          Lyon                    *)
(*                                                                          *)
(*                                 Coq V6.3                                 *)
(*                               July 1st 1999                              *)
(*                                                                          *)
(****************************************************************************)
(*                                  mhm.ml                                  *)
(****************************************************************************)

type ('a,'b) t = ('a,'b) Hashtabl.t;;
type ('a,'b) frozen_t = ('a,'b) Hashtabl.frozen_t;;

let create = Hashtabl.create;;
let empty = Hashtabl.clear;;
let map = Hashtabl.find;;

let in_dom m k =
    try (map m k;true) with Not_found -> false;;

let add m (k,v) =
    if not (in_dom m k) then
        Hashtabl.add m k v
    else failwith "mhm__add";;

let rmv = Hashtabl.remove;;
let app f m = Hashtabl.do_table (fun k v -> f(k,v)) m;;
let freeze = Hashtabl.freeze;;
let unfreeze = Hashtabl.unfreeze;;
let dom m =
    let l = ref []
    in app (fun (k,_) -> if not(List.mem k !l) & in_dom m k then l := k::!l) m;
       !l
;;

let toList m =
let l = dom m
in List.map (fun k -> (k,map m k)) l
;;

let remap m k v =
    rmv m k;
    add m (k,v)
;;

let set_meanlen t n = Hashtabl.set_meanlen t n;;

(* $Id: mhm.ml,v 1.7 1999/06/29 07:47:18 loiseleu Exp $ *)
