(****************************************************************************)
(*                 The Calculus of Inductive Constructions                  *)
(*                                                                          *)
(*                                Projet Coq                                *)
(*                                                                          *)
(*                     INRIA        LRI-CNRS        ENS-CNRS                *)
(*              Rocquencourt         Orsay          Lyon                    *)
(*                                                                          *)
(*                                 Coq V6.3                                 *)
(*                               July 1st 1999                              *)
(*                                                                          *)
(****************************************************************************)
(*                              hidentac.ml                                 *)
(****************************************************************************)

(* This tactics go through the interpreter. They left a trace in the proof
    tree when they are called.
*)

open Proof_trees;;
open Tacmach;;
open Tacentries;;
open Term;;


let h_clear ids         = v_clear  [(CLAUSE ids)];;
let h_move dep id1 id2  = 
 (if dep then v_move else v_move_dep) [IDENTIFIER id1;IDENTIFIER id2];;
let h_contradiction     = v_contradiction [];;
let h_reflexivity       = v_reflexivity   [];;
let h_symmetry          = v_symmetry      [];;
let h_assumption        = v_assumption    [];;
let h_absurd c          = v_absurd [(CONSTR c)];;
let h_exact  c          = v_exact  [(CONSTR c)];;
let h_one_constructor i = v_constructor [(INTEGER i)];;
let h_any_constructor   = v_constructor [];;
let h_transitivity c    = v_transitivity [(CONSTR c)];;
let h_simplest_left     = v_left [(CBINDINGS [])];;
let h_simplest_right    = v_right [(CBINDINGS [])];;
let h_split     c       = v_split [(CONSTR c);(CBINDINGS [])];;
let h_apply c s         = v_apply  [(CONSTR c);(CBINDINGS s)];;
let h_simplest_apply c  = v_apply  [(CONSTR c);(CBINDINGS [])];;
let h_cut      c        = v_cut [(CONSTR c)];;
let h_simplest_elim c   = v_elim [(CONSTR c);(CBINDINGS [])];;
let h_elimType     c    = v_elimType [(CONSTR c)];;
let h_inductionInt  i   = v_induction[(INTEGER i)];;
let h_inductionId   id  = v_induction[(IDENTIFIER id)];;
let h_simplest_case   c = v_case [(CONSTR c);(CBINDINGS [])];;
let h_caseType        c = v_caseType [(CONSTR c)];;
let h_destructInt  i    = v_destruct [(INTEGER i)];;
let h_destructId   id   = v_destruct [(IDENTIFIER id)];;


