indexing
	description: "GEL feature"
	status: "See notice at end of class"
	author: "Sam O'Connor"
	date: "$Date: 1999/10/31 10:36:44 $"
	revision: "$Revision: 1.1.1.1 $"

class
	GEL_FEATURE

creation

	make

feature -- Initialization

	make (new_klass: GEL_CLASS; new_name: STRING) is
		require
			valid_klass: new_klass /= Void
			valid_new_name: new_name /= Void and new_name.count > 0
		do
			create args.make
			create postconditions.make
			create locals.make
			create pre_do.make
			create main_do.make
			create preconditions.make
			klass := new_klass
			name := clone (new_name)
			name.to_lower
			derive_short_name
			if short_name /= Void and then (short_name.substring_index ("new", 1)) = 1 then
				short_name.replace_substring ("make", 1, 3)
				set_creation
			end
			klass.features.extend (Current)
		end

feature -- Access

	klass: GEL_CLASS

	name: STRING
			-- Name of feature

	short_name: STRING
			-- Shortened name

	derive_short_name is
			-- Get a shorted name by trying to strip
			-- class name from the head
		local
			cn: STRING
			i: INTEGER
			rwc: RESERVED_WORD_CHECKER
		do
			create rwc.make
			cn := clone (klass.name)
			cn.to_lower
			cn.append ("_")
			i := name.substring_index (cn, 1);
			if i > 0 and name.count > cn.count+1 then
				short_name := name.substring (cn.count+1, name.count)
				if rwc.is_reserved (short_name) then
					short_name := Void
				end
			else
				short_name := Void
			end
		end

	set_short_name (new_short_name: STRING) is
		do
			short_name := new_short_name
		end

	type: STRING
			-- Eiffel return type

	set_type (new_type: STRING) is
		do
			type := clone (new_type)
			type.to_upper
		end

	args: LINKED_LIST[GEL_ARGUMENT]
			-- Arguments of feature

	is_creation: BOOLEAN

	set_creation is
		do
			is_creation := True
		end

	set_not_creation is
		do
			is_creation := False
		end

	comment: STRING

	set_comment (new_comment: STRING) is
		do
			comment := new_comment
		end

	preconditions: LINKED_LIST[STRING]

	locals: LINKED_LIST[STRING]

	pre_do: LINKED_LIST[STRING]

	main_do: LINKED_LIST[STRING]
	
	postconditions: LINKED_LIST[STRING]

feature -- Conversion to Eiffel text

	text: STRING is
			-- Eiffel text of feature
		local
			r: FMT_STRING
			do_list: LINKED_LIST[STRING]
		do
			create r.make
			create do_list.make
			Result := r
			r.append ("%T^^^ is%N")
			r.inject (name_text)
			r.inject (args_text)
			r.inject (type_text)
			r.append (comment_text)
			r.append (block_text ("require", preconditions))
			r.append (block_text ("local", locals))
			do_list.append (pre_do)
			do_list.append (main_do)
			r.append (block_text ("do", do_list))
			r.append (block_text ("ensure", postconditions))
			r.append ("%T%Tend%N%N")
		end

	name_text: STRING is
			-- Eiffel text of name
		do
			create {FMT_STRING} Result.make
			if short_name /= Void then
				Result.append (short_name)
				--Result.append (", ")
			else
				Result.append (name)
			end
		end

	type_text: STRING is
			-- Eiffel text of return type
		do
			create {FMT_STRING} Result.make
			if type /= Void then
				Result.append (": ")
				Result.append (type)
			end
		end

	args_text: STRING is
			-- Eiffel text of arguments
		local
			i: INTEGER
		do
			create {FMT_STRING} Result.make
			if args.count > 0 then
				i := args.index
				Result.append (" (")
				from args.start
				until args.after
				loop
					Result.append (args.item.name)
					Result.append (": ")
					if args.item.type.is_equal ("char") then
						Result.append ("INTEGER")
					else
						Result.append (args.item.type)
					end
					if args.index /= args.count then
						Result.append ("; ")
					end
					args.forth
				end
				Result.append (")")
				args.go_i_th (i)
			end
		end

	comment_text: STRING is
			-- Eiffel text of comment
		local
			r: FMT_STRING
		do
			create r.make
			Result := r
			if comment /= Void then
				r.append ("%T%T%T-- ^ %N")
				r.inject (comment)
			end
		end

	block_text (block_name: STRING; statements: LINKED_LIST[STRING]): STRING is
			-- Eiffel text from statemets in a linked list
		local
			i: INTEGER
		do
			create {FMT_STRING} Result.make
			i := statements.index
			from
				statements.start
				if not statements.after then
					Result.append ("%T%T")
					Result.append (block_name)
					Result.append ("%N")
				end
			until
				statements.after
			loop
				Result.append ("%T%T%T")
				Result.append (statements.item)
				Result.append ("%N")
				statements.forth
			end
			statements.go_i_th (i)
		end

invariant

	valid_postconditions: postconditions /= Void

	valid_preconditions: preconditions /= Void

	valid_name: name /= Void

	valid_args: args /= Void

end -- class GEL_FEATURE


--!-----------------------------------------------------------------------------
--! The GOTE converter. It converts GTK+ Objects To Eiffel.
--! Copyright (C) 1999 Sam O'Connor
--!
--! This program is free software; you can redistribute it and/or modify
--! it under the terms of the GNU General Public License as published by
--! the Free Software Foundation; either version 2 of the License, or
--! (at your option) any later version.
--!
--! This program is distributed in the hope that it will be useful,
--! but WITHOUT ANY WARRANTY; without even the implied warranty of
--! MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--! GNU General Public License for more details.
--!
--! You should have received a copy of the GNU General Public License
--! along with this program; if not, write to the Free Software
--! Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
--!
--! See file "licence" for more information.
--!-----------------------------------------------------------------------------
