-- Copyright (C) 1999 Dave E Martin XXIII and others
-- Licensed under Eiffel Forum Freeware License, version 1;
-- (see forum.txt)
--
indexing
	description: "wrapper for GdkUpdateType enum"
	note: "You will probably want to declare this as expanded when using as %
		%an attribute or local, most of the time"
	author: "Dave E Martin XXIII"
	genesis: "199905120536 utc"
	version: "v 0.3.3 GTK+ 1.2.x"
	gtk_version: "1.2"
	cvs: "$Id: gtk_position_value.e,v 1.3 1999/10/03 02:07:19 richieb Exp $"

class GTK_POSITION_VALUE

feature -- query
	value: INTEGER

feature -- command
	set_value (the_value: INTEGER) is
		require
			value_valid: First__ <= the_value and the_value <= Last__
		do
			value := the_value
		ensure
			value_set: value = the_value
		end

feature -- constants
		-- C enums start at 0
	First__: INTEGER is 0
	Left: INTEGER is 0
	Right: INTEGER is 1
	Top: INTEGER is 2
	Bottom: INTEGER is 3
	Last__: INTEGER is 3

invariant
	value_valid: First__ <= value and value <= Last__ -- if this fails then
		-- either the C code is broken, doing undocumented things, or this class
		-- needs to be updated because its in violation of consistent_with_c_enum.
	-- HERE check, "comment" assertions must be at the end? (ISE is insisting
	-- this with a non-descript error 157, what does ETL say?)
	consistent_with_c_enum: -- the constants match their corresponding C enum
		-- values
end -- GTK_POSITION_VALUE
