/* IMPORTANT: Read the comment below on how to compile this file.  It
 * is NOT sufficient to just hand it to the C compiler.  It must first
 * be preprocessed.
 */
/* 
 * This file has been generated by 
 *
 *                 D. Richard Hipp
 *                 drh@world.std.com
 *
 * The contributions of Dr. Hipp are placed in the public domain.  However,
 * portions of this file are subject to the copyrights shown below.
 *
 * The changes necessary to use TclX are by Michael Schumacher at
 * mike@hightec.saarlink.de.
 *
 * Copyright (c) 1990-1993 The Regents of the University of California.
 * All rights reserved.
 *
 * Permission is hereby granted, without written agreement and without
 * license or royalty fees, to use, copy, modify, and distribute this
 * software and its documentation for any purpose, provided that the
 * above copyright notice and the following two paragraphs appear in
 * all copies of this software.
 * 
 * IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY FOR
 * DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT
 * OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF THE UNIVERSITY OF
 * CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY
 * AND FITNESS FOR A PARTICULAR PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND THE UNIVERSITY OF CALIFORNIA HAS NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
 */
/*
**
** The function Et_Eval() is an extension of Tcl_VarEval().
**
** The first and second arguments are the name of the file which
** contains the call to Et_Eval() and the line number within that
** file from which Et_Eval() was called.  This information is used
** to print an error message to stderr if necessary.
**
** The third argument is a format string built from three characters:
** 's', 'd', and 'f'.  This format string determines the number and
** type of subsequent arguments.  Each 's' in the format string
** corresponds to a string argument, each 'd' cooresponds to an integer,
** and each 'f' corresponds to a double.
**
** A format string may now also contain a 'q' character.  'q' means that
** the any of the characters which have special meaning to the Tcl
** interpreter (any of  "{", "}", "[", "\"", "\\" or "$") are escaped.
**
** The operation of Et_Eval() is to concatenate all arguments and
** send the result to Tcl_GlobalEval().  The return of Tcl_GlobalEval()
** is returned from Et_Eval().
**
** In addition to Et_Eval(), this file defines three other functions:
**
**      Et_EvalInt()
**      Et_EvalString()
**      Et_EvalDouble()
**
** In each of these other functions, the value returned is not the status
** string from Tcl_VarEval(), but rather the result string.  The result
** string is converted to an integer or a double for Et_EvalInt() and
** Et_EvalDouble(), respectively.
**
**      Et_EvalInclude()
**
** This function is used to implement the ET_INCLUDE() macro of the ET
** system.  It takes two arguments which are the name of a file and 
** null-terminated string containing the contents of that file.  The
** the function simply calls Tcl_GlobalEval on the string, and then prints
** an appropriate error message if something goes wrong.
**
** The Tcl/Tk interpreter used by all these functions is obtained from
** the global variable "Tcl_Interp *Et_Interp;".  This variable
** should be set to a valid interpreter before calling any function
** in this file.
**
** The function Et_InstallCmd() creates a new command for the
** Tcl/Tk interpreter pointed to by the global variable Et_Interp.
** This function was added in support of the ET_INSTALL_COMMANDS macro.
**
** All of the above functions are normally called from ET macros, not
** directly by the user.  The next set of functions are called directly
** by the user:
**
**     Et_Init(int *,char **);
**     Et_ReadStdin(void);
**     Et_MainLoop(void);
**
** The Et_Init() function should be the first function called from within
** the main() procedure of an application.  This function initializes the
** ET interpreter.  Command line arguments used by the interpreter are
** removed from  argc and argv.
**
** Et_MainLoop() should be the last function in the main() procedure.  It
** implements the event loop.
**
** If the function Et_ReadStdin() is called prior to Et_MainLoop(), then
** arrangements are made to read standard input and pass the results to
** the ET interpreter.
**
********************* HOW TO COMPILE THIS FILE **************************
**
** This file is mostly C code, but it is not completely C code.  It can
** not be handed to the C compiler directory, but must first be preprocessed
** using the "et2c" macro preprocessors.
**
** In order to compile this file, you have to know the directories which
** contains the Tcl/Tk startup scripts.  These directories is often
** /usr/local/lib/tcl7.4 and /usr/local/lib/tk4.0, but may vary from system
** to system.  They will also probably be different if you are using Tk3.6.
** An additional directory will be added to the list if you are using
** TclX.  Whatever these directories are, assume that you have defined
** an environment variable TCLINC which contains each directory preceeded
** by a "-I".  Like this:
**
**      TCLINC= -I/usr/local/lib/tcl7.4 -I/usr/local/lib/tk4.0
**
** With such a variable, the actual ET library source files are generated as
** follows:
**
**         et2c $TCLINC et40.c >et.c
**
** The resulting .c file can be then compiled using any ANSI-C Compiler.
*/
/* For K&R code compile with -DK_AND_R */
#include "tk.h"
#ifdef K_AND_R
#include <varargs.h>
#define const
#else
#include <stdarg.h>
#endif
#include <ctype.h>

/*
** Some external functions used
*/
extern void exit();
extern char *strrchr();
extern void free();
extern int read();
extern int isatty();

/*
** The following variable points to the Tcl/Tk interpreter which is
** used by all functions in this file.
*/
Tcl_Interp *Et_Interp = 0;

/* The next variables are made available as a convenience to the
** ET programmer. */
Tk_Window Et_MainWindow;      /* The main window of the application */
Display *Et_Display;          /* The X11 display holding the main window */

/* This flag is TRUE if all scripts processed by ET() macros should
** be printed to standard output.   This variable is linked to a
** Tcl/Tk variable by the same name.
*/
static int et_trace_flag = 0;

/*
** This is the function which does most of the work.  All the Et_EvalXXXX()
** functions call this core to process the variable-length argument list,
** and then do different things with the return parameter
*/
static int
Et_VaEval(fileName,lineNumber,format,ap)
const char *fileName;      /* Name of the file containing the ET macro */
int lineNumber;            /* Line number of start of ET macro */
const char *format;        /* Format string */
va_list ap;                /* Pointer to the argument list */
{
  int i;                     /* Loop counter */
  int retc;                  /* Return code from Tcl_Eval() */
  char *buf;                 /* Buffer to hold the Tcl command string  */
  char *cp;                  /* For scanning strings */
  char c;                    /* Next character being scanned */
  char *next;                /* Pointer to the next unused slot in buf[] */
  int spaceNeeded;           /* Amount of spaced needed in buf to hold
                             ** the entire Tcl command string */
  va_list firstArg;          /* A pointer to the first argument of the
                             ** variant part of the argument list. */
  char smallSpace[40];       /* A space large enough to hold the ascii
                             ** value of an integer or floating point number */
  char bigSpace[1000];       /* The initial buffer.  Hopefully this is enough,
                             ** but if not we can malloc() for more */

  if( Et_Interp==0 ){
    fprintf(stderr,
      "ERROR: %s line %d: Et_Interp does not point to a valid Tk interpreter\n",
      fileName,lineNumber);
    return TCL_ERROR;
  }

  /* Make a pass thru the argument list and tally up the size of the
  ** buffer needed */
  firstArg = ap;
  spaceNeeded = 1;   /* One for the null-terminator */
  for(i=0; format[i]; i++){
    switch( format[i] ){
      case 's':    /* A string */
        spaceNeeded += strlen(va_arg(ap,char*));
        break;

      case 'd':    /* An integer */
        spaceNeeded += 20;
        (void)va_arg(ap,int);
        break;

      case 'f':    /* A double */
        spaceNeeded += 20;
        (void)va_arg(ap,double);
        break;

      case 'q':    /* A quoted string */
        cp = va_arg(ap,char*);
        while( (c=*cp++)!=0 ){
          if( c=='$' || c=='[' || c=='\"' || c=='\\' || c=='{' || c=='}' ){
            spaceNeeded++;
          }
          spaceNeeded++;
	}
        break;
    }
  }

  /* Get a buf which is large enough to hold it all */
  if( spaceNeeded<=sizeof(bigSpace) ){
    buf = bigSpace;
  }else{
    extern char *malloc();
    buf = malloc( spaceNeeded );
    if( buf==0 ){
       sprintf(bigSpace,"File %s line %d: can't allocate %d bytes of memory",
          fileName,lineNumber,spaceNeeded);
       Tcl_AppendResult(Et_Interp,bigSpace,0);
       return TCL_ERROR;
    }
  }

  /* Now make another pass thru the argument list in order to
  ** build the Tcl command string */
  ap = firstArg;
  next = buf;
  for(i=0; format[i]; i++){
    char *str;       /* Pointer to a source string which is to be
                     ** copied into buf */
    switch( format[i] ){
      case 's':    /* A string */
        str = va_arg(ap,char*);
        break;

      case 'd':    /* An integer */
        str = smallSpace;
        sprintf(str,"%d",va_arg(ap,int));
        break;

      case 'f':    /* A double */
        str = smallSpace;
        sprintf(str,"%g",va_arg(ap,double));
        break;

      case 'q':    /* A quoted string */
        str = va_arg(ap,char*);
        while( (c=*str)!=0 ){
          if( c=='$' || c=='[' || c=='\"' || c=='\\' || c=='{' || c=='}' ){
            *next++ = '\\';
	  }
          *next++ = c;
          str++;
	}
        break;

      default:     /* Can't happen */
        str = "";
        break;
    }
    while( (*next++ = *str++)!=0 );
    next--;
  }

  /* Evaluate the Tcl command string.  Generate an error message
  ** if an error occurs */
  retc = Tcl_GlobalEval(Et_Interp,buf);
  if( et_trace_flag ){
    char *cp = buf;
    while( *cp ){
      if( *cp=='\\' && cp[1]=='\n' ){ *cp=' '; cp[1]=' '; }
      cp++;
    }
    printf("%s\n",buf);
  }
  if( retc==TCL_ERROR ){
    char buf[40];
    fprintf(stderr,"ERROR at %s line %d: %s\n",
       fileName,Et_Interp->errorLine + lineNumber - 1,Et_Interp->result);
    sprintf(buf,"%d",Et_Interp->errorLine + lineNumber + 1);
    Tcl_VarEval(Et_Interp,"tkerror {",fileName," line ",buf,"}",0);
  }

  /* clean up and return */
  if( buf!=bigSpace ) free(buf);
  return retc;
}

/*
** This version of Et_Eval() evaluates a single string as the Tcl command,
** just as Tcl_Eval() would.  The difference is in the processing of
** error message.  This function is called by the ET_INCLUDE() macro.
** Et_Eval() could have been used, but this version avoids an extra
** copy of the script from one buffer into another.
*/
void
Et_EvalInclude(zFilename,script)
const char *zFilename; /* The file from which the script was origanally taken */
char *script;          /* The Tcl/Tk command script */
{
  if( Et_Interp==0 ){
    fprintf(stderr,
      "ERROR: %s: Et_Interp does not point to a valid Tk interpreter\n",
      zFilename);
    return;
  }
  if( Tcl_GlobalEval(Et_Interp,script)==TCL_ERROR ){
    char buf[40];
    fprintf(stderr,"ERROR at %s line %d: %s\n",
       zFilename,Et_Interp->errorLine,Et_Interp->result);
    sprintf(buf,"%d",Et_Interp->errorLine);
    Tcl_VarEval(Et_Interp,"tkerror {",zFilename," line ",buf,"}",0);
  }
}

/*
** Execute the Tcl/Tk command string and return an status code
*/
#ifdef K_AND_R
int
Et_Eval(va_alist)
va_dcl
{
  va_list ap;                /* Pointer to the argument list */
  int retc;                  /* The Tcl_Eval() return code */
  char *filename;            /* The filename */
  int lineNumber;            /* The line number */
  char *format;              /* The format string */

  va_start(ap);
  filename = va_arg(ap,char*);
  lineNumber = va_arg(ap,int);
  format = va_arg(ap,char*);
  retc = Et_VaEval(filename,lineNumber,format,ap);
  va_end(ap);
  return retc;
}
#else
int Et_Eval(const char *filename, int lineNumber, const char *format, ...){
  va_list ap;
  int retc;
  va_start(ap,format);
  retc = Et_VaEval(filename,lineNumber,format,ap);
  va_end(ap);
  return retc;
}
#endif

/*
** Execute the Tcl/Tk command string and return the result string
*/
#ifdef K_AND_R
char *
Et_EvalString(va_alist)
va_dcl
{
  va_list ap;                /* Pointer to the argument list */
  int status;                /* The status returned from Et_VaEval() */
  char *filename;            /* The filename */
  int lineNumber;            /* The line number */
  char *format;              /* The format string */

  va_start(ap);
  filename = va_arg(ap,char*);
  lineNumber = va_arg(ap,int);
  format = va_arg(ap,char*);
  status = Et_VaEval(filename,lineNumber,format,ap);
  va_end(ap);
  return Et_Interp->result;
}
#else
char *
Et_EvalString(const char *filename, int lineNumber, const char *format, ...){
  va_list ap;
  int status;
  va_start(ap,format);
  status = Et_VaEval(filename,lineNumber,format,ap);
  va_end(ap);
  return Et_Interp->result;
}
#endif

/*
** Execute the Tcl/Tk command string and return the result converted
** into an integer
*/
#ifdef K_AND_R
int
Et_EvalInt(va_alist)
va_dcl
{
  va_list ap;                /* Pointer to the argument list */
  int status;                /* The status returned from Et_VaEval() */
  char *filename;            /* The filename */
  int lineNumber;            /* The line number */
  char *format;              /* The format string */
  int iReturn;               /* Value returned */

  va_start(ap);
  filename = va_arg(ap,char*);
  lineNumber = va_arg(ap,int);
  format = va_arg(ap,char*);
  status = Et_VaEval(filename,lineNumber,format,ap);
  va_end(ap);
  if( status!=TCL_OK 
  || Tcl_GetInt(Et_Interp,Et_Interp->result,&iReturn)!=TCL_OK ){
    iReturn = 0;
  }
  return iReturn;
}
#else
int
Et_EvalInt(const char *filename, int lineNumber, const char *format, ...){
  va_list ap;
  int status;
  int iReturn;
  va_start(ap,format);
  status = Et_VaEval(filename,lineNumber,format,ap);
  va_end(ap);
  if( status!=TCL_OK 
  || Tcl_GetInt(Et_Interp,Et_Interp->result,&iReturn)!=TCL_OK ){
    iReturn = 0;
  }
  return iReturn;
}
#endif

/*
** Execute the Tcl/Tk command string and return the result converted
** into an double
*/
#ifdef K_AND_R
double
Et_EvalDouble(va_alist)
va_dcl
{
  va_list ap;                /* Pointer to the argument list */
  int status;                /* The status returned from Et_VaEval() */
  double rReturn;            /* Value returned by this function */

  va_start(ap);
  status = Et_VaEval(ap);
  va_end(ap);
  if( status!=TCL_OK 
  || Tcl_GetDouble(Et_Interp,Et_Interp->result,&rReturn)!=TCL_OK ){
    rReturn = 0.0;
  }
  return rReturn;
}
#else
double
Et_EvalDouble(const char *filename, int lineNumber, const char *format, ...){
  va_list ap;
  int status;
  double rReturn;            /* Value returned by this function */

  va_start(ap,format);
  status = Et_VaEval(filename,lineNumber,format,ap);
  va_end(ap);
  if( status!=TCL_OK 
  || Tcl_GetDouble(Et_Interp,Et_Interp->result,&rReturn)!=TCL_OK ){
    rReturn = 0.0;
  }
  return rReturn;
}
#endif

/*
** Install a new command into the interpreter.
*/
#ifdef K_AND_R
void
Et_InstallCommand(zName,cmdProc)
char *zName;         /* Name of the command */
int (*cmdProc)();    /* Procedure which implements the command */
{
  Tcl_CreateCommand(Et_Interp,zName,cmdProc,Tk_MainWindow(Et_Interp),0);
}
#else
void
Et_InstallCommand(
  char *zName, 
  int (*cmdProc)(void*,struct Tcl_Interp*,int,char**)
){
  Tcl_CreateCommand(Et_Interp,zName,cmdProc,Tk_MainWindow(Et_Interp),0);
}
#endif

/*
** Initialize the Tcl/Tk interpreter.
**
** This is a highly modified version of "main()" from the
** file "tkMain.c" in the standard Tcl/Tk distribution.
*/
void
Et_Init(pargc,argv)
int *pargc;
char **argv;
{
    Tk_Window mainWindow;	/* The main window for the application.  If
				 * NULL then the application no longer
				 * exists. */
    Tcl_Interp *interp;		/* Interpreter for this application. */
    char class[60];
    int argc;
    char *args, *p;
    char buf[20];
    int code;

    /*
     * Static variables used for parsing command line options.
     */
    static int synchronize = 0;
    static char *fileName = NULL;
    static char *name = NULL;
    static char *display = NULL;
    static char *geometry = NULL;
    static Tk_ArgvInfo argTable[] = {
        {"-geometry", TK_ARGV_STRING, 0, (char*)&geometry,
         "Initial geometry for window"},
        {"-display",  TK_ARGV_STRING, 0, (char*)&display,
         "Display to use"},
        {"-name",     TK_ARGV_STRING, 0, (char*)&name,
         "Name to use for application"},
        {"-sync",     TK_ARGV_CONSTANT, (char*)1, (char*)&synchronize,
         "Use synchronous mode for display server"},
        { 0, TK_ARGV_END, 0, 0, 0}
    };

    Et_Interp = interp = Tcl_CreateInterp();

    /*
     * Parse command-line arguments.
     */

    if (Tk_ParseArgv(interp, 0, pargc, argv, argTable, 0) != TCL_OK) {
	fprintf(stderr, "%s\n", interp->result);
	exit(3);
    }
    argc = *pargc;
    if (name == NULL) {
        p = fileName ? fileName : argv[0];
	name = strrchr(p, '/');
	if (name != NULL) {
	    name++;
	} else {
	    name = p;
	}
    }


    /*
     * If a display was specified, put it into the DISPLAY
     * environment variable so that it will be available for
     * any sub-processes created by us.
     */
    if (display != NULL) {
	Tcl_SetVar2(interp, "env", "DISPLAY", display, TCL_GLOBAL_ONLY);
    }

    /*
     * Initialize the Tk application and its extensions.
     */
    sprintf(class,"%.*s",(int)sizeof(class)-1,name);
    if( islower(class[0]) ) class[0] = toupper(class[0]);
    /* if( class[0]=='X' && islower(class[1]) ) class[1] = toupper(class[1]); */
    mainWindow = Tk_CreateMainWindow(interp, display, name, class);
    if (mainWindow == NULL) {
	fprintf(stderr, "%s\n", interp->result);
	exit(4);
    }
    if (synchronize) {
	XSynchronize(Tk_Display(mainWindow), True);
    }
    /* Tk_GeometryRequest(mainWindow, 200, 200); */

    /* Set up some convenience global variables.
    **
    ** This only works if there is a single display and screen.  But, then
    ** again, ET only works with a single screen...
    */
    Et_MainWindow = mainWindow;
    Et_Display = Tk_Display(mainWindow);

    /*
     * Make command-line arguments available in the Tcl variables "argc"
     * and "argv".  Also set the "geometry" variable from the geometry
     * specified on the command line.
     */
    args = Tcl_Merge(argc-1, argv+1);
    Tcl_SetVar(interp, "argv", args, TCL_GLOBAL_ONLY);
    ckfree(args);
    sprintf(buf, "%d", argc-1);
    Tcl_SetVar(interp, "argc", buf, TCL_GLOBAL_ONLY);
    Tcl_SetVar(interp, "argv0", fileName ? fileName : argv[0],TCL_GLOBAL_ONLY);
    if (geometry != NULL) {
	Tcl_SetVar(interp, "geometry", geometry, TCL_GLOBAL_ONLY);
    }

    /*
     * Set the "tcl_interactive" variable.
     */
    Tcl_SetVar(interp, "tcl_interactive", "0", TCL_GLOBAL_ONLY);

    /*
     * Create variables "cmd_name" and "cmd_dir" which contain the
     * base name of the application and the name of the directory 
     * which contains the executable for the application.
     */
    ET(
      set cmd_name [file tail $argv0]
      set cmd_dir [file dirname $argv0]
      if "![file readable $argv0] || ![file isfile $argv0]" {
        foreach i [split $env(PATH) :] {
          if "[file readable $i/$cmd_name] && [file isfile $i/$cmd_name]" {
            set cmd_dir $i
            break;
          }
        }
      }
    );

    /*
     * Execute the start-up Tcl/Tk scripts. In the standard version of
     * wish, these are read from the library at run-time.  In this version
     * the scripts are compiled in.
     *
     * Some startup scripts contain "source" commands.  (Ex: tk.tcl in
     * Tk4.0).  This won't do for a stand-alone program.  For that reason,
     * the "source" command is disabled while the startup scripts are
     * being read.
     */
#ifndef ET_DYNAMIC
     ET( rename source __source__; proc source {args} {} );
#endif
     ET_INCLUDE( init.tcl );
     ET_INCLUDE( tk.tcl );
     ET_INCLUDE( button.tcl );
     ET_INCLUDE( dialog.tcl );
     ET_INCLUDE( entry.tcl );
     ET_INCLUDE( focus.tcl );
     ET_INCLUDE( listbox.tcl );
     ET_INCLUDE( menu.tcl );
     ET_INCLUDE( obsolete.tcl );
     ET_INCLUDE( optionMenu.tcl );
     ET_INCLUDE( palette.tcl );
     ET_INCLUDE( parray.tcl );
     ET_INCLUDE( text.tcl );
     ET_INCLUDE( scale.tcl );
     ET_INCLUDE( scrollbar.tcl );
     ET_INCLUDE( tearoff.tcl );
     ET_INCLUDE( tkerror.tcl );
#ifndef ET_DYNAMIC
     ET( rename source {}; rename __source__ source );
#endif

    /*
     * Set the geometry of the main window, if requested.
     */
    if (geometry != NULL) {
	code = Tcl_VarEval(interp, "wm geometry . ", geometry, (char *) NULL);
	if (code != TCL_OK) {
	    fprintf(stderr, "%s\n", interp->result);
	}
    }

    /* Set the et_trace_flag */
    Tcl_LinkVar(interp, "et_trace_flag", (char*)&et_trace_flag, TCL_LINK_INT);

    /* Clean up before returning to the main program */
    Tcl_ResetResult(interp);
}

/*
** Process Tk events until the last window is destroyed, then return.
*/
void
Et_MainLoop(){
    Tk_MainLoop();
}

/*
** Static variables used by the interactive Tcl/Tk processing
*/
static Tcl_DString command;	/* Used to assemble lines of terminal input
				 * into Tcl commands. */
static int tty;			/* Non-zero means standard input is a
				 * terminal-like device.  Zero means it's
				 * a file. */


/*
 *----------------------------------------------------------------------
 *
 * Prompt --
 *
 *	Issue a prompt on standard output, or invoke a script
 *	to issue the prompt.
 *
 * Results:
 *	None.
 *
 * Side effects:
 *	A prompt gets output, and a Tcl script may be evaluated
 *	in interp.
 *
 *----------------------------------------------------------------------
 */
static void
Prompt(interp, partial)
    Tcl_Interp *interp;			/* Interpreter to use for prompting. */
    int partial;			/* Non-zero means there already
					 * exists a partial command, so use
					 * the secondary prompt. */
{
    char *promptCmd;
    int code;

    promptCmd = Tcl_GetVar(interp,
	partial ? "tcl_prompt2" : "tcl_prompt1", TCL_GLOBAL_ONLY);
    if (promptCmd == NULL) {
	defaultPrompt:
	if (!partial) {
	    fputs("% ", stdout);
	}
    } else {
	code = Tcl_Eval(interp, promptCmd);
	if (code != TCL_OK) {
	    Tcl_AddErrorInfo(interp,
		    "\n    (script that generates prompt)");
	    fprintf(stderr, "%s\n", interp->result);
	    goto defaultPrompt;
	}
    }
    fflush(stdout);
}

/*
 *----------------------------------------------------------------------
 *
 * StdinProc --
 *
 *	This procedure is invoked by the event dispatcher whenever
 *	standard input becomes readable.  It grabs the next line of
 *	input characters, adds them to a command being assembled, and
 *	executes the command if it's complete.
 *
 * Results:
 *	None.
 *
 * Side effects:
 *	Could be almost arbitrary, depending on the command that's
 *	typed.
 *
 *----------------------------------------------------------------------
 */

    /* ARGSUSED */
static void
StdinProc(clientData, mask)
    ClientData clientData;		/* Not used. */
    int mask;				/* Not used. */
{
    char input[4000];
    static int gotPartial = 0;
    char *cmd;
    int code, count;

    count = read(fileno(stdin), input, sizeof(input)-1);
    if (count <= 0) {
	if (!gotPartial) {
	    if (tty) {
		Tcl_Eval(Et_Interp, "exit");
		exit(6);
	    } else {
		Tk_DeleteFileHandler(0);
	    }
	    return;
	} else {
	    count = 0;
	}
    }
    cmd = Tcl_DStringAppend(&command, input, count);
    if (count != 0) {
	if ((input[count-1] != '\n') && (input[count-1] != ';')) {
	    gotPartial = 1;
	    goto prompt;
	}
	if (!Tcl_CommandComplete(cmd)) {
	    gotPartial = 1;
	    goto prompt;
	}
    }
    gotPartial = 0;

    /*
     * Disable the stdin file handler while evaluating the command;
     * otherwise if the command re-enters the event loop we might
     * process commands from stdin before the current command is
     * finished.  Among other things, this will trash the text of the
     * command being evaluated.
     */

    Tk_CreateFileHandler(0, 0, StdinProc, (ClientData) 0);
    code = Tcl_RecordAndEval(Et_Interp, cmd, 0);
    Tk_CreateFileHandler(0, TK_READABLE, StdinProc, (ClientData) 0);
    Tcl_DStringFree(&command);
    if (*Et_Interp->result != 0) {
	if ((code != TCL_OK) || (tty)) {
	    printf("%s\n", Et_Interp->result);
	}
    }

    /*
     * Output a prompt.
     */
 prompt:
    if( tty ) Prompt(Et_Interp, gotPartial);
}

/*
** Make arrangements to read and interpret standard input
*/
void
Et_ReadStdin()
{
  tty = isatty(0);
  Tk_CreateFileHandler(0, TK_READABLE, StdinProc, (ClientData) 0);
  if( tty )
  { Tcl_SetVar(Et_Interp, "tcl_interactive", "1", TCL_GLOBAL_ONLY);
    ET(
      if ![info exists tcl_prompt1] {
        set tcl_prompt1 { puts -nonewline stdout [file tail $argv0]> }
      }
      if ![info exists tcl_prompt2] {
        set tcl_prompt2 { puts -nonewline stdout => }
      }
    );
    Prompt(Et_Interp, 0);
  }
  Tcl_DStringInit(&command);
}
