{
  $Id: scribble-simple.pp,v 1.2 1999/05/10 19:18:23 peter Exp $

  Converted from C to Pascal by Frank Loemker
  <floemker@techfak.uni-bielefeld.de>
}
program scribblesimple;
uses
  glib,gdk,gtk;

{ Backing pixmap for drawing area }
const
  pixmap : PGdkPixmap = nil;

{ Create a new backing pixmap of the appropriate size }
function configure_event (widget : pGtkWidget; event: pGdkEventConfigure):boolean; cdecl;
begin
  if pixmap<>nil then
    gdk_pixmap_unref(pixmap);

  pixmap := gdk_pixmap_new(widget^.window,
                           widget^.allocation.width,
                           widget^.allocation.height,
                           -1);
  gdk_draw_rectangle (pixmap,
                      PGtkStyle(widget^.thestyle)^.white_gc,
                      gint(TRUE),
                      0, 0,
                      widget^.allocation.width,
                      widget^.allocation.height);

  configure_event := TRUE;
end;

{ Redraw the screen from the backing pixmap }
function expose_event (widget : pGtkWidget ; event : pGdkEventExpose ) : boolean; cdecl;
begin
  gdk_draw_pixmap(widget^.window,
                  PGtkStyle(widget^.thestyle)^.fg_gc[GTK_WIDGET_STATE (widget)],
                  pixmap,
                  event^.area.x, event^.area.y,
                  event^.area.x, event^.area.y,
                  event^.area.width, event^.area.height);
  expose_event:= FALSE;
end;

{ Draw a rectangle on the screen }
procedure draw_brush (widget : pGtkWidget ; x, y: gint16);
var update_rect : TGdkRectangle;
begin
  update_rect.x := x - 5;
  update_rect.y := y - 5;
  update_rect.width := 10;
  update_rect.height := 10;
  gdk_draw_rectangle (pixmap,
                      PGtkStyle(widget^.thestyle)^.black_gc,
                      gint(TRUE),
                      update_rect.x, update_rect.y,
                      update_rect.width, update_rect.height);
  gtk_widget_draw (widget, @update_rect);
end;

function button_press_event (widget : pGtkWidget ; event: pGdkEventButton ) : boolean; cdecl;
begin
  if (event^.button = 1) and (pixmap <> nil) then begin
    draw_brush (widget, trunc(event^.x), trunc(event^.y));
  end;
  button_press_event := TRUE;
end;

function motion_notify_event (widget : pGtkWidget ; event: pGdkEventMotion ) : boolean; cdecl;
var x, y : longint ;
  state  : TGdkModifierType;
begin
  if (event^.is_hint<>0) then begin
    gdk_window_get_pointer (event^.window, @x, @y, @state);
  end else begin
    x := trunc(event^.x);
    y := trunc(event^.y);
    state := event^.state;
  end;

  if ((state and GDK_BUTTON1_MASK)<>0) and (pixmap <> nil) then
    draw_brush (widget, x, y);

  motion_notify_event := TRUE;
end;

procedure quit;
begin
  gtk_exit (0);
end;

var window, drawing_area, vbox, button : pGtkWidget;
begin
  gtk_init (@argc, @argv);
  gtk_rc_init;

  window := gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_widget_set_name (window, 'Test Input');

  vbox := gtk_vbox_new (gint(FALSE), 0);
  gtk_container_add (pGTKCONTAINER (window), vbox);
  gtk_widget_show (vbox);

  gtk_signal_connect (pGTKOBJECT (window), 'destroy',
                      GTK_SIGNAL_FUNC (@quit), nil);

  { Create the drawing area }

  drawing_area := gtk_drawing_area_new ();
  gtk_drawing_area_size (pGTKDRAWINGAREA (drawing_area), 200, 200);
  gtk_box_pack_start (pGTKBOX (vbox), drawing_area, gint(TRUE), gint(TRUE), 0);

  gtk_widget_show (drawing_area);

  { Signals used to handle backing pixmap }

  gtk_signal_connect (pGTKOBJECT (drawing_area), 'expose_event',
                      GTK_SIGNAL_FUNC (@expose_event), nil);
  gtk_signal_connect (pGTKOBJECT(drawing_area),'configure_event',
                      GTK_SIGNAL_FUNC (@configure_event), nil);

  { Event signals }

  gtk_signal_connect (pGTKOBJECT (drawing_area), 'motion_notify_event',
                      GTK_SIGNAL_FUNC (@motion_notify_event), nil);
  gtk_signal_connect (pGTKOBJECT (drawing_area), 'button_press_event',
                      GTK_SIGNAL_FUNC (@button_press_event), nil);

  gtk_widget_set_events (drawing_area, GDK_EXPOSURE_MASK
                         or GDK_LEAVE_NOTIFY_MASK
                         or GDK_BUTTON_PRESS_MASK
                         or GDK_POINTER_MOTION_MASK
                         or GDK_POINTER_MOTION_HINT_MASK);

  { .. And a quit button }
  button := gtk_button_new_with_label ('Quit');
  gtk_box_pack_start (pGTKBOX (vbox), button, gint(FALSE), gint(FALSE), 0);

  gtk_signal_connect_object (pGTKOBJECT (button), 'clicked',
                             GTK_SIGNAL_FUNC (@gtk_widget_destroy),
                             pGTKOBJECT (window));
  gtk_widget_show (button);

  gtk_widget_show (window);

  gtk_main ();
end.
{
  $Log: scribble-simple.pp,v $
  Revision 1.2  1999/05/10 19:18:23  peter
    * more fixes for the examples to work

  Revision 1.1  1999/05/10 09:02:36  peter
    * gtk 1.2 port working

  Revision 1.3  1999/02/02 16:13:37  michael
  + Applied second patch from Frank Loemker

  Revision 1.2  1998/10/22 11:37:31  peter
    * fixes for win32

  Revision 1.1  1998/10/21 22:27:01  peter
    + initial version

}
