#!/bin/sh
#
# Bourne shell script to compare File in directory ./Vary with
# original in directory ./Okay and print differences if any.
# If no differences it echoes a dot to show progress.
# If differences, touches file CHECK_FAILED
#
# Usage: Compare.sh Okay Vary File

OKAY=$1
VARY=$2
FILE=$3

	if [ ! -d ${OKAY} ] ;
	then
	    echo "Creating directory ${OKAY}" ;
	    /bin/mkdir ${OKAY};
	fi
	if [ ! -f ${OKAY}/${FILE} ] ;
	then
	    echo "${FILE} is new" ;
	    /bin/cp ${FILE} ${OKAY}/${FILE} ;
	fi
	if /usr/bin/cmp ${OKAY}/${FILE} ${FILE} ;
	then
	    /bin/rm -f -f ${FILE} ;
	    echo '.' | gawk '{printf("%s",$1);}' ;
	else
	    touch CHECK_FAILED
	    echo "--------------------------------------------------" ;
	    echo "Differences in ${OKAY}/${FILE}  ${VARY}/${FILE} :" ;
	    if [ ! -d ${VARY} ] ;
	    then
		echo "Creating directory ${VARY}" ;
		/bin/mkdir ${VARY} ;
	    fi
	    /bin/mv ${FILE} ${VARY}/${FILE} ;
	    /usr/bin/diff ${OKAY}/${FILE} ${VARY}/${FILE} ;
	fi
	exit 0
