------------------------------------------------------------------------------
--                                                                          --
--                            GCH COMPONENTS                                --
--                                                                          --
--                     G C H . U N I T _ C H E C K E R                      --
--                                                                          --
--                              B o d y                                     --
--                                                                          --
--                                                                          --
--              Copyright (c) 1999, Vitali Sh.Kaufman.                      --
--                                                                          --
--  Gch is distributed as free software; that is with full sources          --
--  and in the hope that it will be useful, but WITHOUT ANY WARRANTY;       --
--  without even the implied warranty of MERCHANTABILITY or FITNESS         --
--  FOR A PARTICULAR PURPOSE. You can freely copy, modify and redistribute  --
--  this software, provided that full sources are available for the version --
--  being distribute (original and modified), and for a modified version,   --
--  any changes that you have made are clearly indicated.                   --
--                                                                          --
--  Gch was developed by Vitali Sh. Kaufman using a prototype               --
--  and consultations by Sergey I. Rybin.                                   --
------------------------------------------------------------------------------

with Ada.Text_IO;                use Ada.Text_IO;
with Ada.Characters.Handling;    use Ada.Characters.Handling;

with Asis;                       use Asis;

with Asis.Compilation_Units;     use Asis.Compilation_Units;
with Asis.Iterator;              use Asis.Iterator;
with Asis.Extensions;            use Asis.Extensions;
with Asis.Elements;              use Asis.Elements;

with Gch.Rules;
with Gch.Globals;

package body Gch.Unit_Checker is


   -----------------------
   -- Local subprograms --
   -----------------------

   ------------------------------------------------
   -- Actuals for instantiating Traverse_Element --
   ------------------------------------------------

   procedure Check_Element
     (Element : in     Asis.Element;
      Control : in out Traverse_Control;
      State   : in out Boolean)
   --  Checks all the rules for a given ELement, used as the actual for
   --  Pre-Operation
   is
   Rule : Gch.Rules.Rule_Record;

   begin

        for I in Gch.Rules.Rules'Range loop
           Rule := Gch.Rules.Rules(I);
           Gch.Rules.Current_Rule := I;
           -- stores current rule index
           -- to be accessed by rule checking functions

           if Rule.On then  -- Rule.On is set using rules.ini
              if not Rule.Rule_To_Check (Element) then
                 Gch.Rules.Add_Violation (Element, I);
                 State := False;
              end if;
           end if;
        end loop;

   end Check_Element;


   --  Placeholder for Post_Operation

   procedure No_Op
     (Element : in     Asis.Element;
      Control : in out Traverse_Control;
      State   : in out Boolean)
   is
   begin
      null;
   end No_Op;

   procedure Check_Unit_Elements is new Traverse_Element
     (State_Information => Boolean,
      Pre_Operation     => Check_Element,
      Post_Operation    => No_Op);
   -- Checks an unit using just pre-operations for each element

   procedure Check_Whole_Unit
      (Unit : Asis.Compilation_Unit;
      State       : in out Boolean);
   -- Checks the whole unit calling "final" rule checking functions
   -- for rules that require such finalization

   procedure Check_Whole_Unit
      (Unit : Asis.Compilation_Unit;  -- ??
      State       : in out Boolean)  -- ??
   is
   Rule : Gch.Rules.Rule_Record;

   begin

        for I in Gch.Rules.Rules'Range loop
           Rule := Gch.Rules.Rules(I);
           Gch.Rules.Current_Rule := I;
           -- stores current rule index
           -- to be accessed by rule checking functions

           if Rule.Global and then
              not Rule.Rule_To_Check(Nil_Element)
           then
              State := False;  --###VK do we really need this?
           end if;
        end loop;

   end Check_Whole_Unit;

   ------------------
   -- Unit_Checker --
   ------------------

   procedure Unit_Checker
     (Unit_To_Check : Asis.Compilation_Unit;
      Success       : in out Boolean)
   is
      Check_Control : Traverse_Control := Continue;
   begin

      Success := True;                                    --  ???

      Check_Unit_Elements
        (Element    => Unit_Declaration (Unit_To_Check),
         Control => Check_Control,
         State   => Success);

      Check_Whole_Unit
      (Unit => Unit_To_Check,
      State => Success);

   end Unit_Checker;

end Gch.Unit_Checker;