/* $Header: /cvs/gnome/gIDE/src/gI_debug.h,v 1.2 1999/11/06 17:45:39 jpr Exp $ */
/* gIDE
 * Copyright (C) 1998-2000 Steffen Kern
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef GI_DEBUG_H
#define GI_DEBUG_H

#include <gtk/gtk.h>

/*
 * Prototypes for 'gI_debug.c'
 */
void debug_debug( GtkWidget *widget, gpointer data );
gI_debug_window *gI_debug_window_new( gI_document *document );
void gI_debug_window_destroy( GtkWidget *widget, gI_debug_window *dw );
void debug_set_breakpoint( GtkWidget *widget, gpointer data );
void debug_step_over( GtkWidget *widget, gpointer data );
void debug_step_into( GtkWidget *widget, gpointer data );
void debug_break( GtkWidget *widget, gpointer data );
void debug_stop_debug( GtkWidget *widget, gpointer data );
void debug_attach( GtkWidget *widget, gpointer data );
gI_brkpnt *gI_brkpnt_new();
gI_gdbcmd *gI_gdbcmd_new();
void gI_debug_window_parse_state( gI_debug_window *dw, gchar *buf );
gI_watch_window *gI_watch_window_new();
void gI_watch_window_destroy( GtkWidget *widget, gI_watch_window *ww );
gI_brkpnt_window *gI_brkpnt_window_new();
void gI_brkpnt_window_destroy( GtkWidget *widget, gI_brkpnt_window *bpw );
gI_bt_window *gI_bt_window_new();
void gI_bt_window_destroy( GtkWidget *widget, gI_bt_window *bt );


/* status of a command in the gdb command queue */
#define N_GDBCMD_TODO 1	/* not send yet */	
#define N_GDBCMD_DONE 2	/* sent */

/* state of gdb */
#define N_GDB_UNDEF 0	/* undefined, set on initialization */ 
#define N_GDB_IDLE 1	/* idle, prompt is there */
#define N_GDB_RUNNING 2	/* running, that does not have to mean that the program is running, it just means that gdb is busy */
#define N_GDB_BREAK 3	/* break */

/* wait for a special kind of debugger output, we want to parse */
#define N_WAIT_NOTHING 0
#define N_WAIT_BREAKPOINTS 1
#define N_WAIT_EXPRESSIONS_G 2
#define N_WAIT_EXPRESSIONS 3
#define N_WAIT_PROMPT 4
#define N_WAIT_BACKTRACE 5
#define N_WAIT_WHATIS 6
#define N_WAIT_EVALEXPR 7
#define N_WAIT_EXCEPTIONS 8

/* the gdb prompt */
#define GDB_PROMPT "(gdb) "

#endif

