/* $Header: /cvs/gnome/gIDE/src/gI_toolbar.c,v 1.1 1999/12/04 03:00:24 jpr Exp $ */
/* gIDE
 * Copyright (C) 1998-2000 Steffen Kern
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <config.h>
#include <gnome.h>
#include <gdk/gdkkeysyms.h>
#include <stdio.h>
#include <string.h>
#include "structs.h"
#include "gI_file.h"
#include "gI_edit.h"
#include "gI_search.h"
#include "gI_prefs.h"
#include "gI_toolbar.h"
#include "gI_hilite.h"
#include "gI_help.h"

/* externs */
extern gI_config *cfg;
extern glong ro_not_change;


/*
 ---------------------------------------------------------------------
     Function: create_toolbar()
     Desc: Creates Toolbar
 ---------------------------------------------------------------------
*/
void
gI_create_toolbar (GtkWidget *app, GtkWidget *vbox)
{
	GnomeDockItem *dockitem;

	/* First, check to see if Custom toolbar is enabled, if it is, find out which buttons are
	   enabled and then compile the structure and display the toolbar                */

	if (cfg->toolbar_custom)
	{
		glong i;


		GnomeUIInfo newbutton = GNOMEUIINFO_ITEM_STOCK (N_("New"),
		                        N_("New File"),
		                        file_new, GNOME_STOCK_PIXMAP_NEW);

		GnomeUIInfo openbutton = GNOMEUIINFO_ITEM_STOCK (N_("Open"),
		                         N_("Open File"),
		                         file_open, GNOME_STOCK_PIXMAP_OPEN);

		GnomeUIInfo closebutton = GNOMEUIINFO_ITEM_STOCK (N_("Close"),
		                          N_("Close Current File"),
		                          file_close, GNOME_STOCK_PIXMAP_CLOSE);

		GnomeUIInfo savebutton = GNOMEUIINFO_ITEM_STOCK (N_("Save"),
		                         N_("Save Current File"),
		                         file_save, GNOME_STOCK_PIXMAP_SAVE);

		GnomeUIInfo printbutton = GNOMEUIINFO_ITEM_STOCK (N_("Print"),
		                          N_("Print Current File"),
		                          file_print, GNOME_STOCK_PIXMAP_PRINT);

		GnomeUIInfo reloadbutton = GNOMEUIINFO_ITEM_STOCK (N_("Reload"),
		                           N_("Reload Current File"),
		                           file_reload, GNOME_STOCK_PIXMAP_REFRESH);

		GnomeUIInfo undobutton = GNOMEUIINFO_ITEM_STOCK (N_("Undo"),
		                         N_("Undo Last Change"),
		                         edit_undo, GNOME_STOCK_PIXMAP_UNDO);

		GnomeUIInfo cutbutton = GNOMEUIINFO_ITEM_STOCK (N_("Cut"),
		                        N_("Cut Selection"),
		                        edit_cut, GNOME_STOCK_PIXMAP_CUT);

		GnomeUIInfo copybutton = GNOMEUIINFO_ITEM_STOCK (N_("Copy"),
		                         N_("Copy Selection"),
		                         edit_copy, GNOME_STOCK_PIXMAP_COPY);

		GnomeUIInfo pastebutton = GNOMEUIINFO_ITEM_STOCK (N_("Paste"),
		                          N_("Paste Clipboard"),
		                          edit_paste, GNOME_STOCK_PIXMAP_PASTE);

		GnomeUIInfo searchbutton = GNOMEUIINFO_ITEM_STOCK (N_("Search"),
		                           N_("Search"),
		                           search_search, GNOME_STOCK_PIXMAP_SEARCH);

		GnomeUIInfo prefsbutton = GNOMEUIINFO_ITEM_STOCK (N_("Preferences"),
		                          N_("Edit Preferences"),
		                          show_preferences, GNOME_STOCK_PIXMAP_PREFERENCES);

		GnomeUIInfo helpbutton = GNOMEUIINFO_ITEM_STOCK (N_("Help"),
		                         N_("Help"),
		                         show_help, GNOME_STOCK_PIXMAP_HELP);

		GnomeUIInfo exitbutton = GNOMEUIINFO_ITEM_STOCK (N_("Exit"),
		                         N_("Exit gIDE"),
		                         file_exit, GNOME_STOCK_PIXMAP_EXIT);


		GnomeUIInfo toolbar[50];

		for (i = 0; i < cfg->toolbar_custom_items_no; i++)
		{
			if (!strcmp (cfg->toolbar_custom_items[i], "New"))
			{
				toolbar[i] = newbutton;
			};

			if (!strcmp (cfg->toolbar_custom_items[i], "Open"))
			{
				toolbar[i] = openbutton;
			};
			if (!strcmp (cfg->toolbar_custom_items[i], "Close"))
			{
				toolbar[i] = closebutton;
			};
			if (!strcmp (cfg->toolbar_custom_items[i], "Save"))
			{
				toolbar[i] = savebutton;
			};
			if (!strcmp (cfg->toolbar_custom_items[i], "Reload"))
			{
				toolbar[i] = reloadbutton;
			};
			if (!strcmp (cfg->toolbar_custom_items[i], "Print"))
			{
				toolbar[i] = printbutton;
			};
			if (!strcmp (cfg->toolbar_custom_items[i], "Cut"))
			{
				toolbar[i] = cutbutton;
			};
			if (!strcmp (cfg->toolbar_custom_items[i], "Copy"))
			{
				toolbar[i] = copybutton;
			};
			if (!strcmp (cfg->toolbar_custom_items[i], "Undo"))
			{
				toolbar[i] = undobutton;
			};
			if (!strcmp (cfg->toolbar_custom_items[i], "Paste"))
			{
				toolbar[i] = pastebutton;
			};
			if (!strcmp (cfg->toolbar_custom_items[i], "Search"))
			{
				toolbar[i] = searchbutton;
			};
			if (!strcmp (cfg->toolbar_custom_items[i], "Space"))
			{
				toolbar[i].type = GNOME_APP_UI_SEPARATOR;
			};
			if (!strcmp (cfg->toolbar_custom_items[i], "Preferences"))
			{
				toolbar[i] = prefsbutton;
			};
			if (!strcmp (cfg->toolbar_custom_items[i], "Help"))
			{
				toolbar[i] = helpbutton;
			};
			if (!strcmp (cfg->toolbar_custom_items[i], "Exit"))
			{
				toolbar[i] = exitbutton;
			};

		}
		i = i++;
		toolbar[i].type = GNOME_APP_UI_ENDOFINFO;

		/* destroy an existing toolbar */
		dockitem = gnome_app_get_dock_item_by_name( GNOME_APP( app ),
		           GNOME_APP_TOOLBAR_NAME );

		if( dockitem )
			gtk_widget_destroy( GTK_WIDGET( dockitem ) );

		gnome_app_create_toolbar( GNOME_APP (app), toolbar );

		return;
	}

	if( cfg->toolbar )
	{
		/* If the custom toolbar is not enabled complete and display the
		   real toolbar */

		GnomeUIInfo toolbar[] =
		    {
		        GNOMEUIINFO_ITEM_STOCK (N_("New"),
		                                N_("Create A New File"),
		                                file_new, GNOME_STOCK_PIXMAP_NEW),
		        GNOMEUIINFO_ITEM_STOCK (N_("Open"),
		                                N_("Open File"),
		                                file_open, GNOME_STOCK_PIXMAP_OPEN),
		        GNOMEUIINFO_ITEM_STOCK (N_("Reload"),
		                                N_("Reload Current File"),
		                                file_reload, GNOME_STOCK_PIXMAP_REFRESH),
		        GNOMEUIINFO_ITEM_STOCK (N_("Save"),
		                                N_("Save Current File"),
		                                file_save, GNOME_STOCK_PIXMAP_SAVE),
		        GNOMEUIINFO_ITEM_STOCK (N_("Print"),
		                                N_("Print Current File"),
		                                file_print, GNOME_STOCK_PIXMAP_PRINT),
		        GNOMEUIINFO_ITEM_STOCK (N_("Close"),
		                                N_("Close Current File"),
		                                file_close, GNOME_STOCK_PIXMAP_CLOSE),
		        GNOMEUIINFO_SEPARATOR,
		        GNOMEUIINFO_ITEM_STOCK (N_("Undo"),
		                                N_("Undo Last Change"),
		                                edit_undo, GNOME_STOCK_PIXMAP_UNDO),
		        GNOMEUIINFO_ITEM_STOCK (N_("Redo"),
		                                N_("Redo Last Undo"),
		                                edit_redo, GNOME_STOCK_PIXMAP_REDO),
		        GNOMEUIINFO_SEPARATOR,
		        GNOMEUIINFO_ITEM_STOCK (N_("Cut"),
		                                N_("Cut Selection"),
		                                edit_cut, GNOME_STOCK_PIXMAP_CUT),
		        GNOMEUIINFO_ITEM_STOCK (N_("Copy"),
		                                N_("Copy Selection"),
		                                edit_copy, GNOME_STOCK_PIXMAP_COPY),
		        GNOMEUIINFO_ITEM_STOCK (N_("Paste"),
		                                N_("Paste Cliboard"),
		                                edit_paste, GNOME_STOCK_PIXMAP_PASTE),
		        GNOMEUIINFO_SEPARATOR,
		        GNOMEUIINFO_ITEM_STOCK (N_("Exit"),
		                                N_("Exit gIDE"),
		                                file_exit, GNOME_STOCK_PIXMAP_EXIT),
		        GNOMEUIINFO_END
		    };

		/* destroy an existing toolbar */
		dockitem = gnome_app_get_dock_item_by_name( GNOME_APP( app ),
		           GNOME_APP_TOOLBAR_NAME );

		if( dockitem )
			gtk_widget_destroy( GTK_WIDGET( dockitem ) );

		gnome_app_create_toolbar( GNOME_APP (app), toolbar );

	}
	else
	{
		/* destroy an existing toolbar */
		dockitem = gnome_app_get_dock_item_by_name( GNOME_APP( app ),
		           GNOME_APP_TOOLBAR_NAME );

		if( dockitem )
			gtk_widget_destroy( GTK_WIDGET( dockitem ) );
	}
}

