/*
** Copyright (c) Massachusetts Institute of Technology 1994-1998.
**          All Rights Reserved.
**          Unpublished rights reserved under the copyright laws of
**          the United States.
**
** THIS MATERIAL IS PROVIDED AS IS, WITH ABSOLUTELY NO WARRANTY EXPRESSED
** OR IMPLIED.  ANY USE IS AT YOUR OWN RISK.
**
** This code is distributed freely and may be used freely under the 
** following conditions:
**
**     1. This notice may not be removed or altered.
**
**     2. Works derived from this code are not distributed for
**        commercial gain without explicit permission from MIT 
**        (for permission contact lclint-request@sds.lcs.mit.edu).
*/
# ifndef PROGRAMNODELIST_H
# define PROGRAMNODELIST_H

typedef /*@only@*/ programNode o_programNode;

abst_typedef struct _programNodeList
{
  int nelements;
  int nspace;
  /*@reldef@*/ /*@relnull@*/ o_programNode  *elements;
} *programNodeList ;

/*@iter programNodeList_elements (sef programNodeList x, yield exposed programNode el); @*/
# define programNodeList_elements(x, m_el) \
   { int m_ind; programNode *m_elements = &((x)->elements[0]); \
     for (m_ind = 0 ; m_ind < (x)->nelements; m_ind++) \
       { programNode m_el = *(m_elements++);

# define end_programNodeList_elements }}

extern /*@only@*/ programNodeList programNodeList_new(void);

extern void programNodeList_addh (programNodeList p_s, /*@keep@*/ programNode p_el) ;

extern /*@only@*/ cstring programNodeList_unparse (programNodeList p_s) ;
extern void programNodeList_free (/*@only@*/ programNodeList p_s) ;

/*@constant int programNodeListBASESIZE;@*/
# define programNodeListBASESIZE SMALLBASESIZE

# else
# error "Multiple include"
# endif




