package com.jclark.xsl.expr;

import com.jclark.xsl.om.*;

class SystemPropertyFunction implements Function {
  public ConvertibleExpr makeCallExpr(ConvertibleExpr e[],
				      final NamespacePrefixMap prefixMap)
    throws ParseException {
    if (e.length != 1)
      throw new ParseException("expected one argument");
    final StringExpr se = e[0].makeStringExpr();
    return new ConvertibleVariantExpr() {
      public Variant eval(Node node, ExprContext context) throws XSLException {
	return context.getSystemProperty(prefixMap.expandAttributeName(se.eval(node, context), node));
      }
    };
  }
}
