package com.jclark.xsl.expr;

import com.jclark.xsl.om.*;
import java.util.StringTokenizer;
import java.util.Enumeration;

class ValueIdIterator implements NodeIterator {
  private NodeIterator iter1;
  private NodeIterator iter2;

  ValueIdIterator(NodeIterator iter1) {
    this.iter1 = iter1;
    this.iter2 = new NullNodeIterator();
  }

  static class Iterator implements NodeIterator {
    private Node node;
    private Enumeration ids;
    Iterator(Node node, String str) {
      this.node = node;
      ids = new StringTokenizer(str);
    }
    public Node next() {
      while (ids.hasMoreElements()) {
	Node tem = node.getElementWithId((String)ids.nextElement());
	if (tem != null)
	  return tem;
      }
      return null;
    }
  }

  public Node next() throws XSLException {
    for (;;) {
      Node node = iter2.next();
      if (node != null)
	return node;
      node = iter1.next();
      if (node == null)
	break;
      iter2 = new Iterator(node, Converter.toString(node));
    }
    return null;
  }
}
