package com.jclark.xsl.sax;

import org.xml.sax.*;
import java.io.*;

public class TextFileWriter extends HandlerBase {
  private Writer writer;

  private TextFileWriter(String file, String encoding) throws SAXException {
    OutputStream out;
    try {
      out = new FileOutputStream(file);
    }
    catch (IOException e) {
      throw new SAXException(e);
    }
    if (encoding == null)
      writer = new OutputStreamWriter(out);
    else {
      try {
	writer = new OutputStreamWriter(out, encoding);
      }
      catch (UnsupportedEncodingException e) {
	throw new SAXException("unsupported encoding");
      }
    }
  }

  static public void write(ResultTreeFragment frag, String file, String encoding)
    throws SAXException {
    frag.emit(new TextFileWriter(file, encoding), true);
  }

  static public void write(ResultTreeFragment frag, String file) throws SAXException {
    write(frag, file, null);
  }

  public void endDocument() throws SAXException {
    try {
      writer.close();
    }
    catch (IOException e) {
      throw new SAXException(e);
    }
  }

  public void characters(char cbuf[], int off, int len) throws SAXException {
    try {
      writer.write(cbuf, off, len);
    }
    catch (IOException e) {
      throw new SAXException(e);
    }
  }
}
