package com.jclark.xsl.tr;

import com.jclark.xsl.om.*;
import com.jclark.xsl.expr.Pattern;
import com.jclark.xsl.conv.NumberListFormat;

class MultiLevelNumberAction implements Action {
  private Pattern count;
  private Pattern from;
  private NumberListFormatTemplate formatTemplate;

  MultiLevelNumberAction(Pattern count, Pattern from, NumberListFormatTemplate formatTemplate) {
    this.count = count;
    this.from = from;
    this.formatTemplate = formatTemplate;
  }

  public void invoke(ProcessContext context, Node node, Result result) throws XSLException {
    NumberListFormat format = formatTemplate.instantiate(context, node);
    int n;
    if (count == null) {
      if (node.getType() == Node.ELEMENT)
	n = numberUp(node.getName(), format, context, node, result);
      else
	n = 0;
    }
    else 
      n = numberUp(format, context, node, result);
    if (n == 0)
      result.characters(format.getPrefix(0));
    result.characters(format.getSuffix());
  }
  
  private
  int numberUp(NumberListFormat format, ProcessContext context, Node node, Result result) throws XSLException {
    do {
      Node parent = node.getParent();
      if (count.matches(node, context)) {
	int n = 0;
	for (NodeIterator iter = parent.getChildren();;) {
	  Node tem = iter.next();
	  if (count.matches(tem, context)) {
	    ++n;
	    if (tem.equals(node))
	      break;
	  }
	}
	int i = numberUp(format, context, parent, result);
	result.characters(format.getPrefix(i));
	result.characters(format.formatNumber(i, n));
	return i + 1;
      }
      if (from != null && from.matches(node, context))
	break;
      node = parent;
    } while (node != null);
    return 0;
  }

  private
  int numberUp(Name name, NumberListFormat format, ProcessContext context, Node node, Result result) throws XSLException {
    int i = 0;
    for (Node tem = node.getParent(); tem != null; tem = tem.getParent()) {
      if (name.equals(tem.getName())) {
        i = numberUp(name, format, context, tem, result);
	break;
      }
    }
    int n = 0;
    for (NodeIterator iter = node.getParent().getChildren();;) {
      Node tem = iter.next();
      if (name.equals(tem.getName()) && tem.getType() == Node.ELEMENT) {
	n++;
	if (tem.equals(node))
	  break;
      }
    }
    result.characters(format.getPrefix(i));
    result.characters(format.formatNumber(i, n));
    return i + 1;
  }
}
