/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.basic;

import com.sun.java.swing.DefaultDesktopManager;
import com.sun.java.swing.DesktopManager;
import com.sun.java.swing.Icon;
import com.sun.java.swing.JComponent;
import com.sun.java.swing.JInternalFrame;
import com.sun.java.swing.LookAndFeel;
import com.sun.java.swing.SwingConstants;
import com.sun.java.swing.SwingUtilities;
import com.sun.java.swing.UIManager;
import com.sun.java.swing.plaf.ComponentUI;
import com.sun.java.swing.plaf.InternalFrameUI;
import com.sun.java.swing.plaf.UIResource;
import com.sun.java.swing.plaf.basic.BasicInternalFrameTitlePane;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.IllegalComponentStateException;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.io.Serializable;
import java.util.EventListener;

public class BasicInternalFrameUI
extends InternalFrameUI
implements LayoutManager,
PropertyChangeListener,
Serializable,
MouseListener {
    protected JInternalFrame frame;
    protected EventListener borderListener;
    protected JComponent northPane;
    protected JComponent southPane;
    protected JComponent westPane;
    protected JComponent eastPane;
    protected static DesktopManager sharedDesktopManager;

    public static ComponentUI createUI(JComponent jComponent) {
        return new BasicInternalFrameUI((JInternalFrame)jComponent);
    }

    public BasicInternalFrameUI(JInternalFrame jInternalFrame) {
    }

    public void installUI(JComponent jComponent) {
        this.frame = (JInternalFrame)jComponent;
        this.frame.add((Component)this.frame.getRootPane(), "Center");
        this.installDefaults(this.frame);
        this.borderListener = this.createBorderListener(this.frame);
        this.frame.addPropertyChangeListener(this);
        this.frame.setLayout(this);
        this.setNorthPane(this.createNorthPane(this.frame));
        this.setSouthPane(this.createSouthPane(this.frame));
        this.setEastPane(this.createEastPane(this.frame));
        this.setWestPane(this.createWestPane(this.frame));
        this.installMouseHandlers(this.frame);
        this.frame.setOpaque(true);
        this.frame.setMinimumSize(new Dimension(120, 24));
    }

    public void uninstallUI(JComponent jComponent) {
        if (jComponent != this.frame) {
            throw new IllegalComponentStateException(String.valueOf(this) + " was asked to deinstall() " + jComponent + " when it only knows about " + this.frame + ".");
        }
        this.uninstallDefaults(this.frame);
        this.frame.setCursor(Cursor.getPredefinedCursor(0));
        this.setNorthPane(null);
        this.setSouthPane(null);
        this.setEastPane(null);
        this.setWestPane(null);
        this.frame.setLayout(null);
        this.deinstallMouseHandlers(this.frame);
        this.borderListener = null;
        this.frame.removePropertyChangeListener(this);
        this.frame.remove(this.frame.getRootPane());
        this.frame = null;
    }

    protected void installDefaults(JInternalFrame jInternalFrame) {
        Icon icon = jInternalFrame.getFrameIcon();
        if (icon == null || icon instanceof UIResource) {
            jInternalFrame.setFrameIcon(UIManager.getIcon("InternalFrame.icon"));
        }
        LookAndFeel.installBorder(jInternalFrame, "InternalFrame.border");
    }

    protected void uninstallDefaults(JInternalFrame jInternalFrame) {
        Icon icon = jInternalFrame.getFrameIcon();
        if (icon instanceof UIResource) {
            jInternalFrame.setFrameIcon(null);
        }
        LookAndFeel.uninstallBorder(jInternalFrame);
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        if (this.frame == jComponent) {
            return this.frame.getLayout().preferredLayoutSize(jComponent);
        }
        return new Dimension(100, 100);
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        if (this.frame == jComponent) {
            return this.frame.getLayout().minimumLayoutSize(jComponent);
        }
        return new Dimension(0, 0);
    }

    public Dimension getMaximumSize(JComponent jComponent) {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        JInternalFrame jInternalFrame = (JInternalFrame)propertyChangeEvent.getSource();
        Object object = propertyChangeEvent.getNewValue();
        Object object2 = propertyChangeEvent.getOldValue();
        if ("rootPane".equals(string)) {
            if (object2 != null) {
                this.frame.remove((Component)object2);
            }
            if (object != null) {
                this.frame.add((Component)object);
                return;
            }
        } else if ("isClosed".equals(string)) {
            if (object == Boolean.TRUE) {
                this.closeFrame(jInternalFrame);
                return;
            }
        } else {
            if ("isMaximum".equals(string)) {
                if (object == Boolean.TRUE) {
                    this.maximizeFrame(jInternalFrame);
                    return;
                }
                this.minimizeFrame(jInternalFrame);
                return;
            }
            if ("isIcon".equals(string)) {
                if (object == Boolean.TRUE) {
                    this.iconifyFrame(jInternalFrame);
                    return;
                }
                this.deiconifyFrame(jInternalFrame);
                return;
            }
            if ("isSelected".equals(string)) {
                if (object == Boolean.TRUE && object2 == Boolean.FALSE) {
                    this.activateFrame(jInternalFrame);
                    return;
                }
                if (object == Boolean.FALSE && object2 == Boolean.TRUE) {
                    this.deactivateFrame(jInternalFrame);
                }
            }
        }
    }

    protected void replacePane(JComponent jComponent, JComponent jComponent2) {
        if (jComponent != null) {
            this.deinstallMouseHandlers(jComponent);
            this.frame.remove(jComponent);
        }
        if (jComponent2 != null) {
            this.frame.add(jComponent2);
            this.installMouseHandlers(jComponent2);
        }
    }

    protected void deinstallMouseHandlers(JComponent jComponent) {
        if (jComponent != null) {
            if (this.borderListener instanceof MouseListener) {
                jComponent.removeMouseListener((MouseListener)this.borderListener);
            }
            if (this.borderListener instanceof MouseMotionListener) {
                jComponent.removeMouseMotionListener((MouseMotionListener)this.borderListener);
            }
        }
    }

    protected void installMouseHandlers(JComponent jComponent) {
        if (jComponent != null) {
            if (this.borderListener instanceof MouseListener) {
                jComponent.addMouseListener((MouseListener)this.borderListener);
            }
            if (this.borderListener instanceof MouseMotionListener) {
                jComponent.addMouseMotionListener((MouseMotionListener)this.borderListener);
            }
        }
    }

    protected JComponent createNorthPane(JInternalFrame jInternalFrame) {
        return new BasicInternalFrameTitlePane(jInternalFrame);
    }

    protected JComponent createSouthPane(JInternalFrame jInternalFrame) {
        return null;
    }

    protected JComponent createWestPane(JInternalFrame jInternalFrame) {
        return null;
    }

    protected JComponent createEastPane(JInternalFrame jInternalFrame) {
        return null;
    }

    protected EventListener createBorderListener(JInternalFrame jInternalFrame) {
        return new BorderListener();
    }

    public JComponent getNorthPane() {
        return this.northPane;
    }

    public void setNorthPane(JComponent jComponent) {
        this.replacePane(this.northPane, jComponent);
        this.northPane = jComponent;
    }

    public JComponent getSouthPane() {
        return this.southPane;
    }

    public void setSouthPane(JComponent jComponent) {
        this.southPane = jComponent;
    }

    public JComponent getWestPane() {
        return this.westPane;
    }

    public void setWestPane(JComponent jComponent) {
        this.westPane = jComponent;
    }

    public JComponent getEastPane() {
        return this.eastPane;
    }

    public void setEastPane(JComponent jComponent) {
        this.eastPane = jComponent;
    }

    public void addLayoutComponent(String string, Component component) {
    }

    public void removeLayoutComponent(Component component) {
    }

    public Dimension preferredLayoutSize(Container container) {
        Dimension dimension;
        Insets insets = this.frame.getInsets();
        Dimension dimension2 = this.frame.getRootPane().getPreferredSize();
        dimension2.width += insets.left + insets.right;
        dimension2.height += insets.top + insets.bottom;
        if (this.getNorthPane() != null) {
            dimension = this.getNorthPane().getPreferredSize();
            dimension2.width = Math.max(dimension.width, dimension2.width);
            dimension2.height += dimension.height;
        }
        if (this.getSouthPane() != null) {
            dimension = this.getSouthPane().getPreferredSize();
            dimension2.width = Math.max(dimension.width, dimension2.width);
            dimension2.height += dimension.height;
        }
        if (this.getEastPane() != null) {
            dimension = this.getEastPane().getPreferredSize();
            dimension2.width += dimension.width;
            dimension2.height = Math.max(dimension.height, dimension2.height);
        }
        if (this.getWestPane() != null) {
            dimension = this.getWestPane().getPreferredSize();
            dimension2.width += dimension.width;
            dimension2.height = Math.max(dimension.height, dimension2.height);
        }
        return dimension2;
    }

    public Dimension minimumLayoutSize(Container container) {
        Dimension dimension;
        Insets insets = this.frame.getInsets();
        Dimension dimension2 = this.frame.getRootPane().getMinimumSize();
        dimension2.width += insets.left + insets.right;
        dimension2.height += insets.top + insets.bottom;
        if (this.getNorthPane() != null) {
            dimension = this.getNorthPane().getMinimumSize();
            dimension2.width = Math.max(dimension.width, dimension2.width);
            dimension2.height += dimension.height;
        }
        if (this.getSouthPane() != null) {
            dimension = this.getSouthPane().getMinimumSize();
            dimension2.width = Math.max(dimension.width, dimension2.width);
            dimension2.height += dimension.height;
        }
        if (this.getEastPane() != null) {
            dimension = this.getEastPane().getMinimumSize();
            dimension2.width += dimension.width;
            dimension2.height = Math.max(dimension.height, dimension2.height);
        }
        if (this.getWestPane() != null) {
            dimension = this.getWestPane().getMinimumSize();
            dimension2.width += dimension.width;
            dimension2.height = Math.max(dimension.height, dimension2.height);
        }
        return dimension2;
    }

    public void layoutContainer(Container container) {
        Dimension dimension;
        Insets insets = this.frame.getInsets();
        int n = insets.left;
        int n2 = insets.top;
        int n3 = this.frame.getWidth() - insets.left - insets.right;
        int n4 = this.frame.getHeight() - insets.top - insets.bottom;
        if (this.getNorthPane() != null) {
            dimension = this.getNorthPane().getPreferredSize();
            this.getNorthPane().setBounds(n, n2, n3, dimension.height);
            n2 += dimension.height;
            n4 -= dimension.height;
        }
        if (this.getSouthPane() != null) {
            dimension = this.getSouthPane().getPreferredSize();
            this.getSouthPane().setBounds(n, this.frame.getHeight() - insets.bottom - dimension.height, n3, dimension.height);
            n4 -= dimension.height;
        }
        if (this.getWestPane() != null) {
            dimension = this.getWestPane().getPreferredSize();
            this.getWestPane().setBounds(n, n2, dimension.width, n4);
            n3 -= dimension.width;
            n += dimension.width;
        }
        if (this.getEastPane() != null) {
            dimension = this.getEastPane().getPreferredSize();
            this.getEastPane().setBounds(n3 - dimension.width, n2, dimension.width, n4);
            n3 -= dimension.width;
        }
        if (this.frame.getRootPane() != null) {
            this.frame.getRootPane().setBounds(n, n2, n3, n4);
        }
    }

    protected DesktopManager getDesktopManager() {
        if (this.frame.getDesktopPane() != null && this.frame.getDesktopPane().getDesktopManager() != null) {
            return this.frame.getDesktopPane().getDesktopManager();
        }
        if (sharedDesktopManager == null) {
            sharedDesktopManager = new DefaultDesktopManager();
        }
        return sharedDesktopManager;
    }

    protected void closeFrame(JInternalFrame jInternalFrame) {
        this.getDesktopManager().closeFrame(jInternalFrame);
    }

    protected void maximizeFrame(JInternalFrame jInternalFrame) {
        this.getDesktopManager().maximizeFrame(jInternalFrame);
    }

    protected void minimizeFrame(JInternalFrame jInternalFrame) {
        this.getDesktopManager().minimizeFrame(jInternalFrame);
    }

    protected void iconifyFrame(JInternalFrame jInternalFrame) {
        this.getDesktopManager().iconifyFrame(jInternalFrame);
    }

    protected void deiconifyFrame(JInternalFrame jInternalFrame) {
        this.getDesktopManager().deiconifyFrame(jInternalFrame);
    }

    protected void activateFrame(JInternalFrame jInternalFrame) {
        this.getDesktopManager().activateFrame(jInternalFrame);
    }

    protected void deactivateFrame(JInternalFrame jInternalFrame) {
        this.getDesktopManager().deactivateFrame(jInternalFrame);
    }

    public void mousePressed(MouseEvent mouseEvent) {
        ((BorderListener)this.borderListener).mousePressed(mouseEvent);
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    protected class BorderListener
    extends MouseAdapter
    implements MouseMotionListener,
    SwingConstants,
    Serializable {
        int _x;
        int _y;
        int __x;
        int __y;
        Rectangle startingBounds;
        int resizeDir;
        protected final int RESIZE_NONE = 0;
        int resizeCornerSize = 16;

        public void mouseReleased(MouseEvent mouseEvent) {
            if (this.resizeDir == 0) {
                BasicInternalFrameUI.this.getDesktopManager().endDraggingFrame(BasicInternalFrameUI.this.frame);
            } else {
                BasicInternalFrameUI.this.getDesktopManager().endResizingFrame(BasicInternalFrameUI.this.frame);
            }
            this._x = 0;
            this._y = 0;
            this.__x = 0;
            this.__y = 0;
            this.startingBounds = null;
            this.resizeDir = 0;
        }

        public void mousePressed(MouseEvent mouseEvent) {
            Point point = SwingUtilities.convertPoint((Component)mouseEvent.getSource(), mouseEvent.getX(), mouseEvent.getY(), null);
            this.__x = mouseEvent.getX();
            this.__y = mouseEvent.getY();
            this._x = point.x;
            this._y = point.y;
            this.startingBounds = BasicInternalFrameUI.this.frame.getBounds();
            if (!BasicInternalFrameUI.this.frame.isSelected()) {
                try {
                    BasicInternalFrameUI.this.frame.setSelected(true);
                }
                catch (PropertyVetoException propertyVetoException) {}
            }
            if (mouseEvent.getClickCount() > 1 && mouseEvent.getSource() == BasicInternalFrameUI.this.getNorthPane()) {
                if (BasicInternalFrameUI.this.frame.isIconifiable() && BasicInternalFrameUI.this.frame.isIcon()) {
                    try {
                        BasicInternalFrameUI.this.frame.setIcon(false);
                    }
                    catch (PropertyVetoException propertyVetoException) {}
                } else if (BasicInternalFrameUI.this.frame.isMaximizable()) {
                    if (!BasicInternalFrameUI.this.frame.isMaximum()) {
                        try {
                            BasicInternalFrameUI.this.frame.setMaximum(true);
                        }
                        catch (PropertyVetoException propertyVetoException) {}
                    } else {
                        try {
                            BasicInternalFrameUI.this.frame.setMaximum(false);
                        }
                        catch (PropertyVetoException propertyVetoException) {}
                    }
                }
            }
            if (!BasicInternalFrameUI.this.frame.isResizable() || mouseEvent.getSource() == BasicInternalFrameUI.this.getNorthPane()) {
                this.resizeDir = 0;
                BasicInternalFrameUI.this.getDesktopManager().beginDraggingFrame(BasicInternalFrameUI.this.frame);
                return;
            }
            if (mouseEvent.getSource() == BasicInternalFrameUI.this.frame) {
                Insets insets = BasicInternalFrameUI.this.frame.getInsets();
                if (mouseEvent.getX() <= insets.left) {
                    this.resizeDir = mouseEvent.getY() < this.resizeCornerSize + insets.top ? 8 : (mouseEvent.getY() > BasicInternalFrameUI.this.frame.getHeight() - this.resizeCornerSize - insets.bottom ? 6 : 7);
                } else if (mouseEvent.getX() >= BasicInternalFrameUI.this.frame.getWidth() - insets.right) {
                    this.resizeDir = mouseEvent.getY() < this.resizeCornerSize + insets.top ? 2 : (mouseEvent.getY() > BasicInternalFrameUI.this.frame.getHeight() - this.resizeCornerSize - insets.bottom ? 4 : 3);
                } else if (mouseEvent.getY() <= insets.top) {
                    this.resizeDir = mouseEvent.getX() < this.resizeCornerSize + insets.left ? 8 : (mouseEvent.getX() > BasicInternalFrameUI.this.frame.getWidth() - this.resizeCornerSize - insets.right ? 2 : 1);
                } else if (mouseEvent.getY() >= BasicInternalFrameUI.this.frame.getHeight() - insets.bottom) {
                    this.resizeDir = mouseEvent.getX() < this.resizeCornerSize + insets.left ? 6 : (mouseEvent.getX() > BasicInternalFrameUI.this.frame.getWidth() - this.resizeCornerSize - insets.right ? 4 : 5);
                }
                BasicInternalFrameUI.this.getDesktopManager().beginResizingFrame(BasicInternalFrameUI.this.frame, this.resizeDir);
                return;
            }
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            if (this.startingBounds == null) {
                return;
            }
            Point point = SwingUtilities.convertPoint((Component)mouseEvent.getSource(), mouseEvent.getX(), mouseEvent.getY(), null);
            if (mouseEvent.getSource() == BasicInternalFrameUI.this.getNorthPane()) {
                if (BasicInternalFrameUI.this.frame.isMaximum()) {
                    return;
                }
                Insets insets = BasicInternalFrameUI.this.frame.getInsets();
                Dimension dimension = BasicInternalFrameUI.this.frame.getParent().getSize();
                int n = dimension.width;
                int n2 = dimension.height;
                int n3 = this.startingBounds.x - (this._x - point.x);
                int n4 = this.startingBounds.y - (this._y - point.y);
                if (n3 + insets.left <= -this.__x) {
                    n3 = -this.__x - insets.left;
                }
                if (n4 + insets.top <= -this.__y) {
                    n4 = -this.__y - insets.top;
                }
                if (n3 + this.__x + insets.right > n) {
                    n3 = n - this.__x - insets.right;
                }
                if (n4 + this.__y + insets.bottom > n2) {
                    n4 = n2 - this.__y - insets.bottom;
                }
                BasicInternalFrameUI.this.getDesktopManager().dragFrame(BasicInternalFrameUI.this.frame, n3, n4);
                return;
            }
            if (!BasicInternalFrameUI.this.frame.isResizable()) {
                return;
            }
            Dimension dimension = BasicInternalFrameUI.this.frame.getMinimumSize();
            Dimension dimension2 = BasicInternalFrameUI.this.frame.getMaximumSize();
            int n = this._x - point.x;
            int n5 = this._y - point.y;
            int n6 = BasicInternalFrameUI.this.frame.getX();
            int n7 = BasicInternalFrameUI.this.frame.getY();
            int n8 = BasicInternalFrameUI.this.frame.getWidth();
            int n9 = BasicInternalFrameUI.this.frame.getHeight();
            switch (this.resizeDir) {
                case 0: {
                    return;
                }
                case 1: {
                    if (this.startingBounds.height + n5 < dimension.height) {
                        n5 = -(this.startingBounds.height - dimension.height);
                    } else if (this.startingBounds.height + n5 > dimension2.height) {
                        n5 = this.startingBounds.height - dimension.height;
                    }
                    n6 = this.startingBounds.x;
                    n7 = this.startingBounds.y - n5;
                    n8 = this.startingBounds.width;
                    n9 = this.startingBounds.height + n5;
                    break;
                }
                case 2: {
                    if (this.startingBounds.height + n5 < dimension.height) {
                        n5 = -(this.startingBounds.height - dimension.height);
                    } else if (this.startingBounds.height + n5 > dimension2.height) {
                        n5 = this.startingBounds.height - dimension.height;
                    }
                    if (this.startingBounds.width - n < dimension.width) {
                        n = this.startingBounds.width - dimension.width;
                    } else if (this.startingBounds.width - n > dimension2.width) {
                        n = -(this.startingBounds.width - dimension.width);
                    }
                    n6 = this.startingBounds.x;
                    n7 = this.startingBounds.y - n5;
                    n8 = this.startingBounds.width - n;
                    n9 = this.startingBounds.height + n5;
                    break;
                }
                case 3: {
                    if (this.startingBounds.width - n < dimension.width) {
                        n = this.startingBounds.width - dimension.width;
                    } else if (this.startingBounds.width - n > dimension2.width) {
                        n = -(this.startingBounds.width - dimension.width);
                    }
                    n8 = this.startingBounds.width - n;
                    n9 = this.startingBounds.height;
                    break;
                }
                case 4: {
                    if (this.startingBounds.width - n < dimension.width) {
                        n = this.startingBounds.width - dimension.width;
                    } else if (this.startingBounds.width - n > dimension2.width) {
                        n = -(this.startingBounds.width - dimension.width);
                    }
                    if (this.startingBounds.height - n5 < dimension.height) {
                        n5 = this.startingBounds.height - dimension.height;
                    } else if (this.startingBounds.height - n5 > dimension2.height) {
                        n5 = -(this.startingBounds.height - dimension.height);
                    }
                    n8 = this.startingBounds.width - n;
                    n9 = this.startingBounds.height - n5;
                    break;
                }
                case 5: {
                    if (this.startingBounds.height - n5 < dimension.height) {
                        n5 = this.startingBounds.height - dimension.height;
                    } else if (this.startingBounds.height - n5 > dimension2.height) {
                        n5 = -(this.startingBounds.height - dimension.height);
                    }
                    n8 = this.startingBounds.width;
                    n9 = this.startingBounds.height - n5;
                    break;
                }
                case 6: {
                    if (this.startingBounds.height - n5 < dimension.height) {
                        n5 = this.startingBounds.height - dimension.height;
                    } else if (this.startingBounds.height - n5 > dimension2.height) {
                        n5 = -(this.startingBounds.height - dimension.height);
                    }
                    if (this.startingBounds.width + n < dimension.width) {
                        n = -(this.startingBounds.width - dimension.width);
                    } else if (this.startingBounds.width + n > dimension2.width) {
                        n = this.startingBounds.width - dimension.width;
                    }
                    n6 = this.startingBounds.x - n;
                    n7 = this.startingBounds.y;
                    n8 = this.startingBounds.width + n;
                    n9 = this.startingBounds.height - n5;
                    break;
                }
                case 7: {
                    if (this.startingBounds.width + n < dimension.width) {
                        n = -(this.startingBounds.width - dimension.width);
                    } else if (this.startingBounds.width + n > dimension2.width) {
                        n = this.startingBounds.width - dimension.width;
                    }
                    n6 = this.startingBounds.x - n;
                    n7 = this.startingBounds.y;
                    n8 = this.startingBounds.width + n;
                    n9 = this.startingBounds.height;
                    break;
                }
                case 8: {
                    if (this.startingBounds.width + n < dimension.width) {
                        n = -(this.startingBounds.width - dimension.width);
                    } else if (this.startingBounds.width + n > dimension2.width) {
                        n = this.startingBounds.width - dimension.width;
                    }
                    if (this.startingBounds.height + n5 < dimension.height) {
                        n5 = -(this.startingBounds.height - dimension.height);
                    } else if (this.startingBounds.height + n5 > dimension2.height) {
                        n5 = this.startingBounds.height - dimension.height;
                    }
                    n6 = this.startingBounds.x - n;
                    n7 = this.startingBounds.y - n5;
                    n8 = this.startingBounds.width + n;
                    n9 = this.startingBounds.height + n5;
                    break;
                }
                default: {
                    return;
                }
            }
            BasicInternalFrameUI.this.getDesktopManager().resizeFrame(BasicInternalFrameUI.this.frame, n6, n7, n8, n9);
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            if (!BasicInternalFrameUI.this.frame.isResizable()) {
                return;
            }
            if (mouseEvent.getSource() == BasicInternalFrameUI.this.frame) {
                Insets insets = BasicInternalFrameUI.this.frame.getInsets();
                if (mouseEvent.getX() <= insets.left) {
                    if (mouseEvent.getY() < this.resizeCornerSize + insets.top) {
                        BasicInternalFrameUI.this.frame.setCursor(Cursor.getPredefinedCursor(6));
                        return;
                    }
                    if (mouseEvent.getY() > BasicInternalFrameUI.this.frame.getHeight() - this.resizeCornerSize - insets.bottom) {
                        BasicInternalFrameUI.this.frame.setCursor(Cursor.getPredefinedCursor(4));
                        return;
                    }
                    BasicInternalFrameUI.this.frame.setCursor(Cursor.getPredefinedCursor(10));
                    return;
                }
                if (mouseEvent.getX() >= BasicInternalFrameUI.this.frame.getWidth() - insets.right) {
                    if (mouseEvent.getY() < this.resizeCornerSize + insets.top) {
                        BasicInternalFrameUI.this.frame.setCursor(Cursor.getPredefinedCursor(7));
                        return;
                    }
                    if (mouseEvent.getY() > BasicInternalFrameUI.this.frame.getHeight() - this.resizeCornerSize - insets.bottom) {
                        BasicInternalFrameUI.this.frame.setCursor(Cursor.getPredefinedCursor(5));
                        return;
                    }
                    BasicInternalFrameUI.this.frame.setCursor(Cursor.getPredefinedCursor(11));
                    return;
                }
                if (mouseEvent.getY() <= insets.top) {
                    if (mouseEvent.getX() < this.resizeCornerSize + insets.left) {
                        BasicInternalFrameUI.this.frame.setCursor(Cursor.getPredefinedCursor(6));
                        return;
                    }
                    if (mouseEvent.getX() > BasicInternalFrameUI.this.frame.getWidth() - this.resizeCornerSize - insets.right) {
                        BasicInternalFrameUI.this.frame.setCursor(Cursor.getPredefinedCursor(7));
                        return;
                    }
                    BasicInternalFrameUI.this.frame.setCursor(Cursor.getPredefinedCursor(8));
                    return;
                }
                if (mouseEvent.getY() >= BasicInternalFrameUI.this.frame.getHeight() - insets.bottom) {
                    if (mouseEvent.getX() < this.resizeCornerSize + insets.left) {
                        BasicInternalFrameUI.this.frame.setCursor(Cursor.getPredefinedCursor(4));
                        return;
                    }
                    if (mouseEvent.getX() > BasicInternalFrameUI.this.frame.getWidth() - this.resizeCornerSize - insets.right) {
                        BasicInternalFrameUI.this.frame.setCursor(Cursor.getPredefinedCursor(5));
                        return;
                    }
                    BasicInternalFrameUI.this.frame.setCursor(Cursor.getPredefinedCursor(9));
                }
                return;
            }
            BasicInternalFrameUI.this.frame.setCursor(Cursor.getPredefinedCursor(0));
        }

        public void mouseExited(MouseEvent mouseEvent) {
            BasicInternalFrameUI.this.frame.setCursor(Cursor.getPredefinedCursor(0));
        }

        BorderListener() {
            BasicInternalFrameUI.this = BasicInternalFrameUI.this;
        }
    }
}

