/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.basic;

import com.sun.java.swing.Icon;
import com.sun.java.swing.JComboBox;
import com.sun.java.swing.JComponent;
import com.sun.java.swing.JList;
import com.sun.java.swing.JOptionPane;
import com.sun.java.swing.JScrollPane;
import com.sun.java.swing.JTextField;
import com.sun.java.swing.LookAndFeel;
import com.sun.java.swing.UIManager;
import com.sun.java.swing.plaf.ComponentUI;
import com.sun.java.swing.plaf.basic.AbstractOptionPaneUI;
import com.sun.java.swing.text.JTextComponent;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;

public class BasicOptionPaneUI
extends AbstractOptionPaneUI
implements PropertyChangeListener {
    public static final int MIN_WIDTH = 262;
    public static final int MIN_HEIGHT = 90;
    public static final String[] yesNoOptions = new String[]{"Yes", "No"};
    public static final String[] yesNoCancelOptions = new String[]{"Yes", "No", "Cancel"};
    public static final String[] defaultOptions = new String[]{"OK"};
    public static final String[] okCancelOptions = new String[]{"OK", "Cancel"};
    protected JOptionPane optionPane;
    protected JComponent inputComponent;
    protected PropertyChangeListener propListener;

    public static ComponentUI createUI(JComponent jComponent) {
        return new BasicOptionPaneUI();
    }

    public void installUI(JComponent jComponent) {
        this.optionPane = (JOptionPane)jComponent;
        this.installDefaults(jComponent);
        Dimension dimension = this.getMinimumOptionPaneSize();
        if (dimension != null) {
            this.optionPane.setMinimumSize(dimension);
        }
        this.validateComponent();
        jComponent.setOpaque(true);
        this.installListeners(jComponent);
    }

    public void uninstallUI(JComponent jComponent) {
        if ((JOptionPane)jComponent == this.optionPane) {
            this.emptyContainer(this.optionPane);
            this.uninstallListeners(jComponent);
            this.uninstallDefaults(jComponent);
            this.optionPane = null;
        }
    }

    protected void installDefaults(JComponent jComponent) {
        LookAndFeel.installColorsAndFont(jComponent, "OptionPane.background", "OptionPane.foreground", "OptionPane.font");
        LookAndFeel.installBorder(jComponent, "OptionPane.border");
    }

    protected void uninstallDefaults(JComponent jComponent) {
        LookAndFeel.uninstallBorder(jComponent);
    }

    protected void installListeners(JComponent jComponent) {
        this.propListener = this.createPropertyChangeListener(jComponent);
        if (this.propListener != null) {
            this.optionPane.addPropertyChangeListener(this.propListener);
        }
    }

    protected void uninstallListeners(JComponent jComponent) {
        if (this.propListener != null) {
            this.optionPane.removePropertyChangeListener(this.propListener);
            this.propListener = null;
        }
    }

    protected PropertyChangeListener createPropertyChangeListener(JComponent jComponent) {
        return this;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string;
        if (propertyChangeEvent.getSource() == this.optionPane && ((string = propertyChangeEvent.getPropertyName()).equals("options") || string.equals("initialValue") || string.equals("icon") || string.equals("messageType") || string.equals("optionType") || string.equals("message") || string.equals("selectionValues") || string.equals("initialSelectionValue") || string.equals("wantsInput"))) {
            this.validateComponent();
        }
    }

    public Icon getIcon() {
        Icon icon;
        Icon icon2 = icon = this.optionPane == null ? null : this.optionPane.getIcon();
        if (icon == null && this.optionPane != null) {
            icon = this.getIconForType(this.optionPane.getMessageType());
        }
        return icon;
    }

    public Icon getIconForType(int n) {
        if (n < 0 || n > 3) {
            return null;
        }
        switch (n) {
            case 0: {
                return UIManager.getIcon("OptionPane.errorIcon");
            }
            case 1: {
                return UIManager.getIcon("OptionPane.informationIcon");
            }
            case 2: {
                return UIManager.getIcon("OptionPane.warningIcon");
            }
            case 3: {
                return UIManager.getIcon("OptionPane.questionIcon");
            }
        }
        return null;
    }

    public int getMaxCharactersPerLineCount() {
        return this.optionPane.getMaxCharactersPerLineCount();
    }

    public Object getMessage() {
        this.inputComponent = null;
        if (this.optionPane != null) {
            if (this.optionPane.getWantsInput()) {
                JComponent jComponent;
                JComponent jComponent2;
                Object object = this.optionPane.getMessage();
                Object[] objectArray = this.optionPane.getSelectionValues();
                Object object2 = this.optionPane.getInitialSelectionValue();
                if (objectArray != null) {
                    if (objectArray.length < 20) {
                        jComponent2 = new JComboBox();
                        int n = 0;
                        int n2 = objectArray.length;
                        while (n < n2) {
                            ((JComboBox)jComponent2).addItem(objectArray[n]);
                            ++n;
                        }
                        if (object2 != null) {
                            ((JComboBox)jComponent2).setSelectedItem(object2);
                        }
                        this.inputComponent = jComponent2;
                        jComponent = jComponent2;
                    } else {
                        jComponent2 = new JList(objectArray);
                        JScrollPane jScrollPane = new JScrollPane(jComponent2);
                        ((JList)jComponent2).setVisibleRowCount(10);
                        if (object2 != null) {
                            ((JList)jComponent2).setSelectedValue(object2, true);
                        }
                        jComponent2.addMouseListener(new ListSelectionListener());
                        jComponent = jScrollPane;
                        this.inputComponent = jComponent2;
                    }
                } else {
                    jComponent2 = new JTextField(20);
                    if (object2 != null) {
                        ((JTextComponent)jComponent2).setText(object2.toString());
                    }
                    ((JTextField)jComponent2).addActionListener(new TextFieldActionListener());
                    jComponent = this.inputComponent = jComponent2;
                }
                jComponent2 = object == null ? new Object[]{jComponent} : new Object[]{object, jComponent};
                return jComponent2;
            }
            return this.optionPane.getMessage();
        }
        return null;
    }

    public Object[] getButtons() {
        if (this.optionPane != null) {
            Object[] objectArray = this.optionPane.getOptions();
            if (objectArray == null) {
                int n = this.optionPane.getOptionType();
                if (n == 0) {
                    return yesNoOptions;
                }
                if (n == 1) {
                    return yesNoCancelOptions;
                }
                if (n == 2) {
                    return okCancelOptions;
                }
                return defaultOptions;
            }
            return objectArray;
        }
        return null;
    }

    public Container getContainer() {
        return this.optionPane;
    }

    public int getInitialIndex() {
        if (this.optionPane != null) {
            Object object = this.optionPane.getInitialValue();
            Object[] objectArray = this.optionPane.getOptions();
            if (objectArray == null) {
                return 0;
            }
            if (object != null) {
                int n = objectArray.length - 1;
                while (n >= 0) {
                    if (objectArray[n].equals(object)) {
                        return n;
                    }
                    --n;
                }
            }
        }
        return -1;
    }

    protected void resetInputValue() {
        if (this.inputComponent != null && this.inputComponent instanceof JTextField) {
            this.optionPane.setInputValue(((JTextField)this.inputComponent).getText());
            return;
        }
        if (this.inputComponent != null && this.inputComponent instanceof JComboBox) {
            this.optionPane.setInputValue(((JComboBox)this.inputComponent).getSelectedItem());
            return;
        }
        if (this.inputComponent != null) {
            this.optionPane.setInputValue(((JList)this.inputComponent).getSelectedValue());
        }
    }

    public void createdButtonFired(int n) {
        if (this.optionPane != null) {
            Object[] objectArray = this.optionPane.getOptions();
            if (objectArray == null) {
                int n2 = this.optionPane.getOptionType();
                if (this.inputComponent != null && (n2 == 0 || n2 == 1 || n2 == 2) && n == 0) {
                    this.resetInputValue();
                }
                if (n2 == 2 && n == 1) {
                    this.optionPane.setValue(new Integer(2));
                    return;
                }
                this.optionPane.setValue(new Integer(n));
                return;
            }
            this.optionPane.setValue(objectArray[n]);
        }
    }

    public Dimension getMinimumOptionPaneSize() {
        return new Dimension(262, 90);
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        if ((JOptionPane)jComponent == this.optionPane) {
            Dimension dimension = this.getMinimumOptionPaneSize();
            LayoutManager layoutManager = jComponent.getLayout();
            if (layoutManager != null) {
                Dimension dimension2 = layoutManager.preferredLayoutSize(jComponent);
                if (dimension != null) {
                    return new Dimension(Math.max(dimension2.width, dimension.width), Math.max(dimension2.height, dimension.height));
                }
                return dimension2;
            }
            return dimension;
        }
        return null;
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        return this.getPreferredSize(jComponent);
    }

    public Dimension getMaximumSize(JComponent jComponent) {
        return this.getPreferredSize(jComponent);
    }

    public Insets getInsets(JComponent jComponent) {
        return null;
    }

    public boolean getSizeButtonsToSameWidth() {
        return true;
    }

    public void selectInitialValue() {
        if (this.inputComponent != null) {
            this.inputComponent.requestFocus();
            return;
        }
        super.selectInitialValue();
    }

    private class ListSelectionListener
    extends MouseAdapter
    implements Serializable {
        public void mousePressed(MouseEvent mouseEvent) {
            if (mouseEvent.getClickCount() == 2) {
                JList jList = (JList)mouseEvent.getSource();
                int n = jList.locationToIndex(mouseEvent.getPoint());
                BasicOptionPaneUI.this.optionPane.setInputValue(jList.getModel().getElementAt(n));
            }
        }

        ListSelectionListener() {
            BasicOptionPaneUI.this = BasicOptionPaneUI.this;
        }
    }

    private class TextFieldActionListener
    implements ActionListener,
    Serializable {
        public void actionPerformed(ActionEvent actionEvent) {
            BasicOptionPaneUI.this.optionPane.setInputValue(((JTextField)actionEvent.getSource()).getText());
        }

        TextFieldActionListener() {
            BasicOptionPaneUI.this = BasicOptionPaneUI.this;
        }
    }
}

