/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.text.html;

import com.sun.java.swing.ImageIcon;
import java.awt.Color;
import java.awt.Component;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;

class Utilities {
    public static String colorToHex(Color color) {
        String string = new String("#");
        String string2 = Integer.toHexString(color.getRed());
        if (string2.length() > 2) {
            throw new Error("invalid red value");
        }
        string = string2.length() < 2 ? String.valueOf(string) + "0" + string2 : String.valueOf(string) + string2;
        string2 = Integer.toHexString(color.getGreen());
        if (string2.length() > 2) {
            throw new Error("invalid green value");
        }
        string = string2.length() < 2 ? String.valueOf(string) + "0" + string2 : String.valueOf(string) + string2;
        string2 = Integer.toHexString(color.getBlue());
        if (string2.length() > 2) {
            throw new Error("invalid green value");
        }
        string = string2.length() < 2 ? String.valueOf(string) + "0" + string2 : String.valueOf(string) + string2;
        return string;
    }

    public static boolean endTagNeeded(String string) {
        if (string.equals("base") || string.equals("isindex") || string.equals("link") || string.equals("meta")) {
            return false;
        }
        if (string.equals("body") || string.equals("head") || string.equals("script") || string.equals("style") || string.equals("title") || string.equals("p") || string.equals("pre") || string.equals("code") || string.equals("center") || string.equals("div") || string.equals("blockquote") || string.equals("kbd") || string.equals("b") || string.equals("i") || string.equals("u") || string.equals("cite") || string.equals("big") || string.equals("small") || string.equals("dfn") || string.equals("em") || string.equals("samp") || string.equals("strike") || string.equals("strong") || string.equals("sub") || string.equals("sup") || string.equals("tt") || string.equals("_var")) {
            return true;
        }
        return true;
    }

    public static final Color hexToColor(String string) {
        if (string.length() != 7) {
            throw new Error("invalid hex color string length");
        }
        if (string.startsWith("#")) {
            string.substring(1, string.length());
            Color color = Color.decode(string);
            return color;
        }
        return null;
    }

    static final int stringToHex(String string) {
        if (string.length() != 2) {
            throw new Error("invalid hex string" + string);
        }
        int n = Character.digit(string.charAt(0), 16) * 16;
        int n2 = Character.digit(string.charAt(1), 16);
        return n2 + n;
    }

    public static final Color stringToColor(String string) {
        Color color = null;
        if (string.charAt(0) == '#') {
            color = Utilities.hexToColor(string);
        } else if (string.equalsIgnoreCase("Black")) {
            color = Utilities.hexToColor("#000000");
        } else if (string.equalsIgnoreCase("Silver")) {
            color = Utilities.hexToColor("#C0C0C0");
        } else if (string.equalsIgnoreCase("Gray")) {
            color = Utilities.hexToColor("#808080");
        } else if (string.equalsIgnoreCase("White")) {
            color = Utilities.hexToColor("#FFFFFF");
        } else if (string.equalsIgnoreCase("Maroon")) {
            color = Utilities.hexToColor("#800000");
        } else if (string.equalsIgnoreCase("Red")) {
            color = Utilities.hexToColor("#FF0000");
        } else if (string.equalsIgnoreCase("Purple")) {
            color = Utilities.hexToColor("#800080");
        } else if (string.equalsIgnoreCase("Fuchsia")) {
            color = Utilities.hexToColor("#FF00FF");
        } else if (string.equalsIgnoreCase("Green")) {
            color = Utilities.hexToColor("#008000");
        } else if (string.equalsIgnoreCase("Lime")) {
            color = Utilities.hexToColor("#00FF00");
        } else if (string.equalsIgnoreCase("Olive")) {
            color = Utilities.hexToColor("#808000");
        } else if (string.equalsIgnoreCase("Yellow")) {
            color = Utilities.hexToColor("#FFFF00");
        } else if (string.equalsIgnoreCase("Navy")) {
            color = Utilities.hexToColor("#000080");
        } else if (string.equalsIgnoreCase("Blue")) {
            color = Utilities.hexToColor("#0000FF");
        } else if (string.equalsIgnoreCase("Teal")) {
            color = Utilities.hexToColor("#008080");
        } else if (string.equalsIgnoreCase("Aqua")) {
            color = Utilities.hexToColor("#00FFFF");
        }
        return color;
    }

    public static String removeSurroundingQuotes(String string) {
        String string2 = new String(string);
        if (string.startsWith("\"") && string.endsWith("\"")) {
            string2 = new String(string.substring(1, string.length() - 1));
        }
        return string2;
    }

    public static ImageIcon loadImage(Component component, String string) {
        Object object;
        Toolkit toolkit = component.getToolkit();
        if (toolkit == null) {
            return null;
        }
        URL uRL = null;
        try {
            uRL = new URL(string);
            object = uRL.openConnection().getInputStream();
            ((InputStream)object).close();
        }
        catch (MalformedURLException malformedURLException) {
            object = new File(string);
            if (!((File)object).canRead()) {
                return null;
            }
        }
        catch (IOException iOException) {
            return null;
        }
        object = uRL != null ? toolkit.getImage(uRL) : toolkit.getImage(string);
        MediaTracker mediaTracker = new MediaTracker(component);
        mediaTracker.addImage((Image)object, 0);
        try {
            mediaTracker.waitForID(0);
        }
        catch (InterruptedException interruptedException) {
            System.out.println(interruptedException);
            return null;
        }
        ImageIcon imageIcon = new ImageIcon((Image)object);
        if (imageIcon.getIconWidth() == -1 || imageIcon.getIconHeight() == -1) {
            return null;
        }
        return imageIcon;
    }

    Utilities() {
    }
}

