/*
 * Decompiled with CFR 0.152.
 */
import com.sun.java.swing.JComponent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Window;
import java.awt.event.MouseEvent;

public class VertScaleCanvas
extends JComponent {
    protected ClogDisplay parent;
    protected ProgramCanvas canvas;
    protected int vgap;
    protected int lineSize;
    protected int _xPix;
    private Font vCanFont;
    private JProcess currProc;
    protected boolean setupComplete;

    public VertScaleCanvas(ClogDisplay clogDisplay) {
        this.parent = clogDisplay;
        this.canvas = clogDisplay.canvas;
        this.setup();
    }

    public VertScaleCanvas() {
    }

    private void setup() {
        this.setupComplete = false;
        this.adjustCanvasStuff();
        ((Component)((Object)this)).enableEvents(16L);
    }

    private void adjustCanvasStuff() {
        ((Component)((Object)this)).setCursor(new Cursor(12));
        this.setToolTipText("Double click on process # to get process controls");
        this.vCanFont = new Font("Serif", 0, 12);
        ((Component)((Object)this)).setFont(this.vCanFont);
        FontMetrics fontMetrics = ((Component)((Object)this)).getToolkit().getFontMetrics(this.vCanFont);
        this.lineSize = fontMetrics.getHeight();
        this._xPix = fontMetrics.stringWidth(new String("0000"));
    }

    public void paintComponent(Graphics graphics) {
        if (this.setupComplete) {
            this.drawStuff(graphics, 0, this.vgap, this.canvas._yPix);
        }
    }

    public Dimension getPreferredSize() {
        return new Dimension(this._xPix, this.canvas._yPix);
    }

    public void drawStuff(Graphics graphics, int n, int n2, int n3) {
        int n4 = this.canvas.dtypeV.size();
        graphics.setColor(this.parent.rulerColor);
        graphics.fillRect(n, n2, this._xPix, n3);
        int n5 = 0;
        while (n5 < n4) {
            int n6 = (Integer)this.canvas.dtypeV.elementAt(n5);
            graphics.setColor(this.parent.rulerColor);
            graphics.fill3DRect(n, n2 + n5 * this.canvas.eachDispHt, this._xPix, this.canvas.hBWt, true);
            graphics.fill3DRect(n, n2 + (n5 + 1) * this.canvas.eachDispHt - this.canvas.hBWt, this._xPix, this.canvas.hBWt, true);
            if (n6 != 1) {
                graphics.setColor(Color.black);
                int n7 = 0;
                while (n7 < this.canvas.procVector.size()) {
                    int n8 = n;
                    int n9 = (int)Math.rint((double)(n5 * this.canvas.eachDispHt) + this.canvas.getProcYCord(n7) + (double)this.lineSize / 4.0 + (double)n2);
                    int n10 = ((JProcess)this.canvas.procVector.elementAt((int)n7)).procId;
                    graphics.drawString(this.getNumString(n10, 4), n8, n9);
                    ++n7;
                }
            }
            ++n5;
        }
    }

    public String getNumString(int n, int n2) {
        String string = Integer.toString(n);
        int n3 = n2 - string.length();
        int n4 = 0;
        while (n4 < n3) {
            string = " " + string;
            ++n4;
        }
        return string;
    }

    public void processMouseEvent(MouseEvent mouseEvent) {
        if (mouseEvent.getID() == 500) {
            if (mouseEvent.getClickCount() == 2) {
                this.handleProcDlg(mouseEvent);
                return;
            }
        } else {
            super.processMouseEvent(mouseEvent);
        }
    }

    private void handleProcDlg(MouseEvent mouseEvent) {
        int n = mouseEvent.getY();
        if (n < this.vgap || n >= this.vgap + this.canvas.allDispHt) {
            return;
        }
        int n2 = (n - this.vgap) / this.canvas.eachDispHt;
        if ((Integer)this.canvas.dtypeV.elementAt(n2) != 0) {
            return;
        }
        int n3 = this.canvas.findIndex((n - this.vgap) % this.canvas.eachDispHt);
        if (n3 > -1) {
            this.currProc = (JProcess)this.canvas.procVector.elementAt(n3);
            this.parent.procDlg.reset(this.currProc);
            ((Window)((Object)this.parent.procDlg)).show();
            ((Window)((Object)this.parent.procDlg)).toFront();
        }
    }

    void setupComplete() {
        this.setupComplete = true;
        ((Component)((Object)this)).repaint();
    }

    void setVerticalGap(int n) {
        this.vgap = n;
    }
}

