
/*
 * Computer Algebra Kit (c) 1993,98 by Comp.Alg.Objects.  All Rights Reserved.
 * $Id: despolc.m,v 1.2 1999/07/06 19:48:08 stes Exp $
 */

#include "cakit.h"

@implementation vardnsexpdegsps_polynomial
+ scalarZero:aScalar
{
  return [self error:"Can't create variable dense polynomial without cltn of symbols"];
}

- scalarZero
{
  return [self subclassResponsibility:_cmd];
}

- symbols
{
  return [self subclassResponsibility:_cmd];
}

- (BOOL) sameClass:b
{
  id aScalar = [self scalarZero];
  id aSymbols = [self symbols];
  id bScalar = [b scalarZero];
  id bSymbols = [b symbols];

  if ([super sameClass:b] == NO)
    return NO;
  if (aScalar != bScalar && [aScalar notEqual:bScalar])
    return NO;
  if (aSymbols != bSymbols && [aSymbols notEqual:bSymbols])
    return NO;

  return YES;
}

- (BOOL)isVariableDense		
{
  return YES;
}
- (BOOL)isVariableSparse	
{
  return NO;
}
- (BOOL)isRecursive		
{
  return NO;
}
- (BOOL)isExpanded		
{
  return YES;
}
- (BOOL)isDegreeDense		
{
  return NO;
}
- (BOOL)isDegreeSparse		
{
  return YES;
}

- emptyScalarZero:aZero
{
  id symbols = [self symbols];
  id classCarrier = [aZero class_vardnsexpdegsps_polynomial];
  return [classCarrier scalarZero:aZero symbols:symbols];
}

- emptyVariableDense:aCltn
{
  id scalarZero = [self scalarZero];
  assert (isa == [scalarZero class_vardnsexpdegsps_polynomial]);
  assert ([aCltn size] == [[self symbols] size]);
  return [isa scalarZero:scalarZero symbols:aCltn];
}

- emptyVariableSparse
{
  id classCarrier;
  id scalarZero = [self scalarZero];
  classCarrier = [scalarZero class_varspsexpdegsps_polynomial];
  return [classCarrier scalarZero:scalarZero];
}

- emptyExpanded
{
  return [self empty];
}

- emptyRecursive
{
  id classCarrier;
  id scalarZero = [self scalarZero];
  id symbols = [self symbols];
  classCarrier = [scalarZero class_vardnsrecdegsps_polynomial];
  return [classCarrier scalarZero:scalarZero symbols:symbols];
}

- emptyDegreeSparse
{
  return [self empty];
}

- emptyDegreeDense
{
  id classCarrier;
  id scalarZero = [self scalarZero];
  id symbols = [self symbols];
  classCarrier = [scalarZero class_vardnsexpdegdns_polynomial];
  return [classCarrier scalarZero:scalarZero symbols:symbols];
}

@end
 
