
/*
 * Computer Algebra Kit (c) 1992,99 by Comp.Alg.Objects.  All Rights Reserved.
 * $Id: integer.h,v 1.2 1999/07/06 19:48:09 stes Exp $
 */

#ifndef __CAINTEGER_HEADER__
#define __CAINTEGER_HEADER__

#include "cobject.h"

#define Integer BigInt

typedef unsigned short bigintwrd_t;

typedef bigintwrd_t *bigintdig_t;

typedef struct bigint
  {
    int sign;
    int count;
    int capacity;
    bigintdig_t digits;
  }
 *bigint_t;
#if (0)				/* public and private structure must match exactly */
typedef struct bigint
  {
    int sign;
    int count;
    int capacity;
    void *digits;
  }
 *bigint_t;
#endif /* 0 */

typedef unsigned short int DIGIT;

/* the following type is declared here only to be included once
 * there is *no* special treatment of small integers in CAInteger
 */
typedef struct bigintobj
  {
    short int hit;
    short int val;
    id obj;
  }
 *bigintobj_t;

typedef struct bigintobj *bigintobjseq_t;
typedef struct bigintobj bigintobj_c;
typedef struct
  {
    id proto;
  }
bigintobj_args;

#define bigintobj_isvalue	0
#define bigintobj_pervalue	0

@interface BigInt : CAObject
{
  struct bigint value;
}
- check;

- _setUpInteger;
+ new;
+ str:(STR)aString;
+ int:(int)intValue;
- factorial:(int)n;
+ factorial:(int)n;
+ fibonacci:(int)n;
- copy;
- deepCopy;
- release;
- empty;
- (bigint_t) bigint_value;
- bigint_value:(bigint_t)aValue;
- (bigint_t) bigint_reference;
- bigint_reference:(bigint_t)aReference;
- class_vector;
- class_vardnsrecdegsps_polynomial;
- class_vardnsrecdegdns_polynomial;
- class_vardnsexpdegsps_polynomial;

- (unsigned) hash;
- (BOOL) isEqual:b;
- (BOOL) notEqual:b;
- (int) numDigits;
- (BOOL) isDigit;

- insertDigit:(DIGIT)d;
- (DIGIT) removeDigit;

- (DIGIT) digitAt:(int)i;
- (DIGIT) lastDigit;
- (DIGIT) leadingDigit;

- (STR) str;
- str:(STR)aString;

- asNumerical;
- asModp:(unsigned short)p;
- (DIGIT) digitValue;
- digitValue:(DIGIT)aValue;
- (unsigned long) ulongValue;
- ulongValue:(unsigned long)aValue;
- (int) intValue;
- intValue:(int)aValue;
- (double) doubleValue;
- (float) floatValue;

- (int) sign;
- (int) compare:b;

- zero;
- (BOOL) isZero;
- (BOOL) notZero;
- (BOOL) isOpposite:b;
- (BOOL) notOpposite:b;
- negate;
- negateSelf;
- _double:(int)v;
- _doubleSelf:(int)v;
- double;
- doubleSelf;
- _add:(int)v:b:(int)w;
- _addSelf:(int)v:b:(int)w;
- add:b;
- addSelf:b;
- subtract:b;
- subtractSelf:b;
- addDigit:(DIGIT)d;
- addSelfDigit:(DIGIT)d;
- subtractDigit:(DIGIT)d;
- subtractSelfDigit:(DIGIT)d;

- one;
- minusOne;
- _add:(int)v:B multiply:b:(int)w;
- _addSelf:(int)v:B multiply:b:(int)w;
- _multiply:a:(int)v add:B:(int)w;
- _multiplySelf:a:(int)v add:B:(int)w;
- _multiply:a:(int)v add:B multiply:b:(int)w;
- _multiplySelf:a:(int)v add:B multiply:b:(int)w;
- (BOOL) isOne;
- (BOOL) notOne;
- (BOOL) isMinusOne;
- (BOOL) notMinusOne;
- square;
- squareSelf;
- multiply:b;
- multiplySelf:b;
- multiplyDigit:(DIGIT)d;
- multiplySelfDigit:(DIGIT)d;
- inverse;

- divide:b;
- divideSelf:b;
- quotientSelf:b;
- divideDigit:(DIGIT)b;
- divideSelfDigit:(DIGIT)b;
- quotientDigit:(DIGIT)b;
- quotientSelfDigit:(DIGIT)d;
- remainder:b quotient:(id *)q;
- remainderSelf:b quotient:(id *)q;
- quotientDigit:(DIGIT)d remainder:(DIGIT *)r;
- quotientSelfDigit:(DIGIT)d remainder:(DIGIT *)r;
- (DIGIT) remainderDigit:(DIGIT)d;

- (BOOL) isEven;
- (BOOL) isOdd;

- gcd:b;

- (BOOL) printsLeadingSign;
- printOn:(IOD)aFile;

- fileOutOn:aFiler;
- fileInFrom:aFiler;
@end

#endif /* __CAINTEGER_HEADER__ */
 
