
/*
 * Computer Algebra Kit (c) 1993,99 by Comp.Alg.Objects.  All Rights Reserved.
 * $Id: ivectorc.h,v 1.2 1999/07/06 19:48:10 stes Exp $
 */

#ifndef __bigintobj_vector_header__
#define __bigintobj_vector_header__

#include "vectorc.h"

typedef struct bigintobjvec
  {
    int n;
    int c;
    bigintobjseq_t ptr;
  }
 *bigintobjvec_t;

typedef struct bigintobjvec bigintobjvec_c;
typedef struct
  {
    bigintobj_args sargs;
  }
bigintobjvec_args;

#define bigintobjvec_isvalue	0
#define bigintobjvec_pervalue	0

typedef struct bigintobjvec_ix
  {
    int i;
    int n;
  }
 *bigintobjvec_ixt;

@interface bigintobj_vector : vectorc
{
  id scalarZero;
  struct bigintobjvec value;
}

- check;

- _setUpScalarZero:aScalarZero numScalars:(int)numScalars;
+ scalarZero:aScalarZero numScalars:(int)numScalars;
- copy;
- deepCopy;
- release;
- (bigintobjvec_t)bigintobjvec_value;
- bigintobjvec_value:(bigintobjvec_t)aValue;
- (bigintobjvec_t)bigintobjvec_reference;
- bigintobjvec_reference:(bigintobjvec_c *)aReference;

- capacity:(int)aCapacity;
- numScalars:(int)numScalars;

- scalarZero;
- (int) numScalars;

- insertScalar:aScalar;
- insertScalar:aScalar at:(int)i;

- removeScalar;
- removeScalarAt:(int)i;

- placeScalar:aScalar at:(int)i;
- replaceScalarAt:(int)i with:aScalar;

- eachScalar;
- elt_bigintobjvec_ix:(bigintobjvec_ixt)ix;

- dotMultiply:b;
- dotSquare;

- fileOutOn:aFiler;
- fileInFrom:aFiler;
- (unsigned) hash;
- (BOOL) isEqual:b;
- (BOOL) notEqual:b;
- (BOOL) isZero;
- (BOOL) notZero;
- (BOOL) isOpposite:b;
- (BOOL) notOpposite:b;
- negate;
- negateSelf;
- _double:(int)v;
- _doubleSelf:(int)v;
- double;
- doubleSelf;
- _add:(int)v:b:(int)w;
- _addSelf:(int)v:b:(int)w;
- add:b;
- addSelf:b;
- subtract:b;
- subtractSelf:b;
- multiplyScalar:s;
- multiplySelfScalar:s;
- divideScalar:s;
- divideSelfScalar:s;
- _add:(int)v:B multiplyScalar:b:(int)w;
- _addSelf:(int)v:B multiplyScalar:b:(int)w;
- _multiplyScalar:a:(int)v add:B:(int)w;
- _multiplySelfScalar:a:(int)v add:B:(int)w;
- _multiplyScalar:a:(int)v add:B multiplyScalar:b:(int)w;
- _multiplySelfScalar:a:(int)v add:B multiplyScalar:b:(int)w;
@end

#endif /* __bigintobj_vector_header__ */
 
