/*
 * GSMPGTST2.c - 2nd mpeg test for color patterns
 *
 * Source Version: 2.0
 * Software Release #92-0043
 *
 */

#include "cpyright.h"

#include "pgs.h"

#define N_MPG  4
#define N      100
#define PAL(i) palettes[(i+palette)%(sizeof(palettes)/sizeof(char *))]

extern void SC_DECLARE(PG_setup_mpeg_device, (PG_device *d));
int palette = 0;
char *palettes[] = {"bw", "rainbow", "iron", "contrast", "cym"};

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* COMPUTE_2D_DATA - compute data for 2D-1D rendering tests */

void compute_2d_data(f, x, y, kmax, lmax)
   REAL *f, *x, *y;
   int kmax, lmax;
   {int k, l, i;
    REAL xmin, xmax, ymin, ymax;
    REAL dx, dy, tol, t, r, fv;

    xmin = -5.0;
    xmax =  5.0;
    ymin = -5.0;
    ymax =  5.0;

    dx = (xmax - xmin)/((REAL) kmax - 1.0);
    dy = (xmax - xmin)/((REAL) kmax - 1.0);

    tol = 1.0e-5;

    for (k = 0; k < kmax; k++)
        for (l = 0; l < lmax; l++)
            {i    = l*kmax + k;
             x[i] = k*dx + xmin;
             y[i] = l*dy + ymin;
             r    = x[i]*x[i] + y[i]*y[i];
             t    = 5.0*atan(y[i]/(x[i] + SMALL));
             r    = POW(r, 0.125);
             fv   = exp(-r)*(1.0 + 0.1*cos(t));
             f[i] = floor(fv/tol)*tol;};

    return;}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

int main(argc, argv)
   int argc;
   char *argv[];
   {PG_device *dev;

    int n, kmax, lmax, kxl;
    int label, centering;
    REAL *x, *y, *f;
    PG_graph *data;

    /*PG_register_device("MPEG", PG_setup_mpeg_device);*/
    dev = PG_make_device("MPEG", "COLOR", "mpgtst2");
    PG_open_device(dev, 0.0, 0.0, 400.0, 400.0);

/* set up data */
    centering = N_CENT;
    kmax      = 20;
    lmax      = 20;
    kxl       = kmax*lmax;
    x         = FMAKE_N(REAL, kxl, "TEST_7:x");
    y         = FMAKE_N(REAL, kxl, "TEST_7:y");
    f         = FMAKE_N(REAL, kxl, "TEST_7:f");
    label     = 'A';

    for (n = 0; n < N_MPG; n++)
        {compute_2d_data(f, x, y, kmax, lmax);
	 data = PG_make_graph_r2_r1(label, "{x, y}->f", FALSE, 
				    kmax, lmax, centering,
				    x, y, f, "xy", "f");

	 PG_set_palette(dev, PAL(n));
	 PG_poly_fill_plot(dev, data);}

    PG_rl_graph(data, TRUE, TRUE);
    PG_close_device(dev);
    PG_rl_all();

    return(0);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
