(require 'cookie)

(setq seeed 0)

(defun printer (string)
  (setq seeed (1+ seeed))
  (concat string (format " %d" seeed)))

(defun test ()
  (interactive)
  (let ((b  (generate-new-buffer "cookie-test")))
    (switch-to-buffer b)
  
    (cookie-create b
		   (function printer)
		   "This is a header."
		   "This is a footer.")
    (cookie-enter-first b "This is the first cookie.")
    (cookie-enter-last b "This is the last cookie.")
    (message (cookie-cookie b (tin-nth b -2)))
    (message (cookie-cookie b (tin-nth b -1)))
    (if (or (tin-nth b 2) (tin-nth b -3))
	(error "Error 78423."))
    (cookie-enter-cookies b '("List one." "List two." "List three."))
    (message "%s" "Entered list.")
    (setq foo (tin-nth b 2))
    (cookie-clear b)
    (cookie-enter-cookies b '("Foo" "Bar" "Baz" "Bie" "LysKOM"))
    (goto-char 1)
;    (switch-to-buffer-other-window (get-buffer-create "*Report*"))
;    (cookie-map-reverse (function (lambda (str) (insert str) (insert ?\n))) b)
    (cookie-filter b (function (lambda (foo) (sit-for 0) (yes-or-no-p foo))))
    (let ((a (point-min))
	  (c (point-max))
	  sell)
      (switch-to-buffer-other-window (get-buffer-create "*Report*"))
      (erase-buffer)
      (while (< a c)
	(setq sel  (tin-get-selection b a))
	(if sel 
	    (insert (format "%d - %s\n" a
			    (cookie-cookie b sel))))
	(setq a (1+ a))))))

(defun d (b tin)
  (message "%s" (cookie-cookie b tin))
  (sit-for 2))

