#|------------------------------------------------------------*-Scheme-*--|
 | File:    modules/mlink/mpath.scm
 |
 |          Copyright (C)1997 Donovan Kolbly <d.kolbly@rscheme.org>
 |          as part of the RScheme project, licensed for free use.
 |          See <http://www.rscheme.org/> for the latest information.
 |
 | File version:     1.11
 | File mod date:    1999.09.13 19:42:54
 | System build:     v0.7.3.1-b39, 1999-12-25
 | Owned by module:  mlink
 |
 `------------------------------------------------------------------------|#

(define *module-search-path* #f)

(set! *module-search-path* #f)  ;; reset to #f on startup

(%early-once-only
(define *default-module-search-path*
  (map string->dir '("~/lib/rs/modules" "[resource]/modules"))))

(define (init-module-search-path)
  (let ((p (getenv "RS_MODULE_PATH")))
    (if p
        (apply append
	       (map (lambda (dirname)
		      (if (or (string=? dirname "@STDPATH@")
			      ;; @STDPATH@ is too hard to remember...
			      (string=? dirname "@")) 
			  *default-module-search-path*
			  (list (string->dir dirname))))
		    (string-split p #\:)))
	*default-module-search-path*)))

(define (module-search-path)
  (or *module-search-path*
      (let ((p (init-module-search-path)))
       (set! *module-search-path* p)
       p)))

(define-method push-module-search-path! ((p <directory-name>))
  (let ((d (append-dirs
	    (append-dirs (process-directory)
			 (current-directory))
	    p)))
    (set! *module-search-path* (cons d (module-search-path)))))

(define-method push-module-search-path! ((p <string>))
  (push-module-search-path! (string->dir p)))

;;;;

(define (get-loaded-module name)
  (let ((m (assq name (installed-modules))))
    (if m
        (cdr m)
        #f)))

;;;;

;; a restricted case of `remove-specials' from rsc
;; because module names with #\.'s in them get #\_ in
;; the filesystem

(define (remove-specials name)
  (list->string
   (map (lambda (ch)
	  (if (eq? ch #\.)
	      #\_
	      ch))
	(string->list name))))

(define (load-compiled-module name)
  (let* ((rel (make <file-name>
		    file-directory: #f
		    filename: (remove-specials (symbol->string name))
		    extension: "mif"))
	 (f (search-for-file rel (module-search-path) '())))
    (and f (link-load-module name f))))

;;;;

(define *module-finders* '())

(define (add-module-finder! proc)
  (set! *module-finders* (append *module-finders* (list proc))))

(%early-once-only
  (add-module-finder! get-loaded-module)
  (add-module-finder! load-compiled-module))

;;;

(define (get-module (n <symbol>))
  (let loop ((mf *module-finders*))
    (if (null? mf)
        (error "~s: couldn't locate module" n)
        (let ((m ((car mf) n)))
	  (if m
	      m
	      (loop (cdr mf)))))))
