/*
   Written by Pieter J. Schoenmakers <tiggr@ics.ele.tue.nl>

   Copyright (C) 1996 Pieter J. Schoenmakers.

   This file is part of TOM.  TOM is distributed under the terms of the
   TOM License, a copy of which can be found in the TOM distribution; see
   the file LICENSE.

   $Id: LTIExtension.h,v 1.12 1998/01/05 00:57:05 tiggr Exp $  */

#import <ltt/ltt.h>

@interface LTIExtension: LTTTop
{
  /* Our structural information.  */
  LTTExtension *structure;

  /* Methods.  */
  TLVector *methods;

  /* Constants.  */
  TLDictionary *constants;

  /* Directly inherited metas by this extension.  */
  TLVector *metas;

  /* Declaration of variables, as output.  */
  TLString *output_var_decl;

  /* The id of this extension.  Only set to !0 if it is discovered to have
     variables.  */
  int eid;

  /* The alignment required by the state in this extension.  */
  int alignment;

  /* The search mark.  */
  int mark;

  /* Various flags, for your pleasure.  */
  unsigned int defined: 1;
  unsigned int declared: 1;
}

+(id) extensionWithStructure: (LTTExtension *) str;

/* Return all state extensions.  */
+(TLVector *) extensions;

/* Return the number of allocated extensions with variables.  For all
   extensions, 0 <= identity < numExtensions.  */
+(int) numExtensions;

-(void) addMethod: (LTIMethod *) m;

-(int) alignment;

-(TLDictionary *) constants;

-(void) digestInfo: (TLCons *) l;

-(int) identity;

-(TLVector *) methods;

-(LTTExtension *) structure;

#ifdef LTIEXTENSION_DECLARE_PRIVATE_METHODS

-initWithStructure: (LTTExtension *) e;

#endif

@end
