/*
   Written by Pieter J. Schoenmakers <tiggr@ics.ele.tue.nl>

   Copyright (C) 1996 Pieter J. Schoenmakers.

   This file is part of TOM.  TOM is distributed under the terms of the
   TOM License, a copy of which can be found in the TOM distribution; see
   the file LICENSE.

   $Id: LTTFile.m,v 1.11 1998/01/20 00:02:21 tiggr Exp $  */

#import "ltt.h"

@implementation LTTFile

+(LTTFile *) fileWithName: (LTTName *) n
		     unit: (LTTUnit *) u
{
  return [(LTTFile *) [self gcAlloc] initWithName: n unit: u];
}

-(void) addItem: (LTTFileItem *) item
{
  [items addElement: item];
}

-(TLVector *) items
{
  return items;
}

-(void) gcReference
{
  MARK (unit);
  MARK (items);

  [super gcReference];
}

-(id) initWithName: (LTTName *) n
	      unit: (LTTUnit *) u
{
  unit = u;
  items = [TLVector vector];
  return [super initWithName: n];
}

-(id <TLString>) interfaceFilename
{
  return [name external];
}

-(id <TLString>) implementationFilename
{
  return [name internal];
}

-(BOOL) loadedImplementation
{
  return loaded_imp;
}

-(BOOL) loadedInfo
{
  return loaded_info;
}

-(BOOL) loadedInterface
{
  return loaded_int;
}

-(void) setLoadedImplementation
{
  loaded_imp = YES;
}

-(void) setLoadedInfo
{
  loaded_info = YES;
}

-(void) setLoadedInterface
{
  loaded_int = YES;
}

-(LTTUnit *) unit
{
  return unit;
}

@end
