/* TOM unit file parser.  -*- objc -*-
   Written by Pieter J. Schoenmakers <tiggr@ics.ele.tue.nl>

   Copyright (C) 1996 Pieter J. Schoenmakers.

   This file is part of TOM.  TOM is distributed under the terms of the
   TOM License, a copy of which can be found in the TOM distribution; see
   the file LICENSE.

   $Id: punit.y,v 1.10 1998/01/05 00:58:27 tiggr Exp $  */

%{

#import "ltt.h"

#define YYDEBUG 1
#define YYERROR_VERBOSE

extern char *ltt_text;

static void
yyerror (char *s)
{
  error (@"parse error at `%s' (%s)", ltt_text, s);
} /* yyerror */

static id enclosing_file_indication;

%}

/* Nothing (yet).  */
%expect 0

%pure_parser

%union {
  /* For boolean and enumerable values, i.e. syntactic meaning  */
  int i;

  /* Everything else (semantics).  */
  id v;
}

%token CLASS END EXTENSION _FILE UNIT USES POSING

%token <v> STRING_CST IDENTIFIER

%type <v> .file_indication. posed_supers .posing. qualified_identifier

%start file

%%
file:
	  unit
	;

unit:
	  UNIT IDENTIFIER
	    {
	      current_acceptor = [current_acceptor startUnitNamed: $2];
	    }
	  complete_decl_list END
	    {
	      current_acceptor = [current_acceptor endUnit];
	    }
	  ';'
	;

complete_decl_list:
	  complete_decl_list_entry
	| complete_decl_list complete_decl_list_entry
	;

complete_decl_list_entry:
	  decl_list_entry
	    {
	      enclosing_file_indication = nil;
	    }
	| enclosing_file_indication '{' plain_decl_list '}'
	    {
	      enclosing_file_indication = nil;
	    }
	;

plain_decl_list:
	  plain_decl_list_entry
	| plain_decl_list plain_decl_list_entry
	;

decl_list_entry:
	  enclosing_file_indication plain_decl_list_entry
	| USES uses_list ';'
	| error
	    {
	      error (AT"parse error at `%s'", ltt_text);
	    }
	;

plain_decl_list_entry:
	  CLASS class_list ';'
	| EXTENSION extension_list ';'
	;

enclosing_file_indication:
	  .file_indication.
	    {
	      enclosing_file_indication = $1;
	    }
	;

class_list:
	  class_list_entry
	| class_list ',' class_list_entry
	;

class_list_entry:
	  IDENTIFIER .posing. .file_indication.
	    {
	      current_acceptor = [current_acceptor class: $1 inFile: $3
						   posing: $2];
	    }
	| error
	;

extension_list:
	  extension_list_entry
	| extension_list ',' extension_list_entry
	;

extension_list_entry:
	  qualified_identifier '(' IDENTIFIER ')' .posing. .file_indication.
	    {
	      if ([$1 consp])
		current_acceptor
		  = [current_acceptor extension: $3 inFile: $6 ofClass: [$1 cdr]
				      inUnit: [$1 car] posing: $5];
	      else
		current_acceptor
		  = [current_acceptor extension: $3 inFile: $6 ofClass: $1
				      inUnit: nil posing: $5];
	    }
	| error
	;

qualified_identifier:
	  IDENTIFIER
	| IDENTIFIER '.' IDENTIFIER
	    {
	      $$ = CONS ($1, $3);
	    }
	;

.posing.:
	  /* empty */ { $$ = nil; }
	| POSING posed_supers
	    {
	      $$ = $2;
	    }
	;

posed_supers:
	  qualified_identifier
	    {
	      $$ = CONS ($1, nil);
	    }
	| posed_supers ',' qualified_identifier
	    {
	      $$ = [$1 nconc: CONS ($3, nil)];
	    }
	;

.file_indication.:
	  /* empty */
	    {
	      $$ = enclosing_file_indication;
	    }
	| _FILE STRING_CST
	    {
	      if (enclosing_file_indication)
		error (AT"duplicate file indication");
	      $$ = $2;
	    }
	;

uses_list:
	  uses_list_entry
	| uses_list ',' uses_list_entry
	;

uses_list_entry:
	  IDENTIFIER
	    {
	      current_acceptor = [current_acceptor usesUnit: $1];
	    }
	;

%%
