/* Interface to TLDate class
   This file is part of TL, Tiggr's Library.
   Written by Tiggr <tiggr@es.ele.tue.nl>
   Copyright (C) 1995, 1996 Pieter J. Schoenmakers
   TL is distributed WITHOUT ANY WARRANTY.
   See the file LICENSE in the TL distribution for details.

   $Id: TLDate.h,v 1.1 1998/01/08 16:13:11 tiggr Exp $  */

#import "TLObject.h"
#import "TLStream.h"
#import "TLNumber.h"
#import "TLString.h"
/* Now, which one defines timeval?  */
#import <sys/time.h>
#import <time.h>

/* Return the time interval from the Unix epoch to now.  */
time_interval time_since_unix_epoch (void);

/* Given a time_interval, return an equivalent unix struct timeval.  */
struct timeval timeval_from_time_interval (time_interval when);

@interface TLDate: TLObject
{
  /* The moment in time we represent, as counted from the Unix epoch.   */
  time_interval when;
}

/******************** creation ********************/

+(TLDate *) dateWithMicroSeconds: (id <TLNumber>) mu;
+(TLDate *) dateWithString: (id <TLString>) s;
+(TLDate *) dateWithTimeval: (struct timeval *) t;
+(TLDate *) dateWithInterval: (time_interval) t;
+(TLDate *) dateWithUnixTime: (time_t) t;

+(TLDate *) distantFuture;
+(TLDate *) distantPast;

+(TLDate *) now;

-initWithNow;
-initWithString: (id <TLString>) s;
-initWithInterval: (time_interval) t;

/* Queries.  */
-(time_interval) interval;
-(unsigned long) microSeconds;
-(double) seconds;
-(struct timeval) timeval;

/* Converting to printed representations.  */
-(void) print: (id <TLOutputStream>) stream format: (id <TLString>) format;
-(TLString *) stringUsingFormat: (id <TLString>) format;

#ifdef TLDATE_DECLARE_PRIVATE_METHODS

-(void) print: (id <TLOutputStream>) stream quoted: (BOOL) qp;

#endif

@end
