<copyright> IntArray class.
    Written by <a href="mailto:tiggr@ics.ele.tue.nl">Pieter J. Schoenmakers</a>

    Copyright &copy; 1995-1997 Pieter J. Schoenmakers.

    This file is part of TOM.  TOM is distributed under the terms of the
    TOM License, a copy of which can be found in the TOM distribution; see
    the file LICENSE.

    <id>$Id: IntArray.t,v 1.6 1998/01/05 01:06:17 tiggr Exp $</id>
    </copyright>

implementation class
IntArray: Array

extern instance (id)
  with dynamic elements;

end;

implementation instance
IntArray

protected extern id
  initWithEnumerator Enumerator e;

Any
  at int index
{
  int i = self[index];
  = Any ([IntNumber with i]);
}

byte
  at int index
{
  int i = self[index];
  = byte (i);
}

char
  at int index
{
  int i = self[index];
  = char (i);
}

extern int
  at int index;

long
  at int index
{
  int i = self[index];
  = i;
}

float
  at int index
{
  int i = self[index];
  = float (i);
}

double
  at int index
{
  int i = self[index];
  = double (i);
}

extern int
  elementByteSize;

extern int
  hash;

extern (pointer, int)
  pointerToElements (int, int) (start, len);

/******************** copying ********************/
<doc> <h4>Copying</h4> </doc>

<doc> Return the {MutableIntArray} class.  </doc>
class (State)
  mutableCopyClass
{
  = [MutableIntArray self];
}

end;
