<copyright> MutableObjectArray class.
    Written by <a href="mailto:tiggr@ics.ele.tue.nl">Pieter J. Schoenmakers</a>

    Copyright &copy; 1995-1997 Pieter J. Schoenmakers.

    This file is part of TOM.  TOM is distributed under the terms of the
    TOM License, a copy of which can be found in the TOM distribution; see
    the file LICENSE.

    <id>$Id: MutableObjectArray.t,v 1.31 1998/03/09 00:03:00 tiggr Exp $</id>
    </copyright>

implementation class
MutableObjectArray: ObjectArray, MutableArray

<doc> Return a newly allocated {MutableObjectArray} with {num} copies of
    the {object}.  </doc>
instance (id)
    with int num
  copies All object
{
  instance (id) a = [self withCapacity num];
  int i;

  for (i = 0; i < num; i++)
    a[i] = object;

  = a;
}

end;

implementation instance
MutableObjectArray

void
  freeze
{
  //  isa = [ObjectArray self];
}

extern id
  initWithCapacity int capacity;

protected id
  initWithEnumerator Enumerator e
{
  [super (ObjectArray) initWithEnumerator e];

  capacity = length;

  = self;
}

extern void
  insert All object
      at int index;

extern Any
  removeAt int index;

extern void
  removeElements (int, int) (start, length);

extern void
  resize (int, int) (start, num);

extern void
  set All object
   at int index;

extern void
  swap (int, int) (i, j);

void
  encodeUsingCoder Encoder coder
{
  /* This do-nothing method is needed to get the version information on
     the MutableObjectArray class into the stream.  */
  if (![coder hasBeenCodedFor [MutableObjectArray self]])
    [super encodeUsingCoder coder];
}

void
  initWithCoder Decoder coder
{
  if (![coder hasBeenCodedFor [MutableObjectArray self]])
    {
      [super initWithCoder coder];
      capacity = length;
    }
}

end;
