/*
 * ===========================
 * VDK Builder
 * Version 0.1.1
 * Revision 0.0
 * March 1999
 * ===========================
 *
 * Copyright (C) 1998,1999 Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * Based on VDK Library
 * Copyright (C) 1998, Mario Motta
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 *
 */

#include <vdkb/vdkb_evcontain.h>
#include <vdkb/vdkb_labelbutton.h>
#include <vdkb/vdkb_form.h>
#include <vdk/vdk.h>
#include <vdkb/vdkb_utils.h>
#include <vdkb/vdkb_parser.h>
#include <vdkb/vdkb_prjman.h>
#include <vdkb/vdkb_objinspect.h>
#include <stdlib.h>
#include <vdkb/vdkb_toolbar.h>
#include <vdkb/vdkb_tooldialog.h>
#include <vdkb/vdkb_fixed.h>
#include <vdkb/vdkb_widpopmenu.h>
/*
================================
symbolic constants to templatize
a bit
================================
*/
// for methods and other stuff
#define CLASS VDKBToolbar
// put here vdk class name string
#define VDK_CLASS "VDKToolbar"
// put here vdk class name
#define VDK_ANCESTOR  VDKToolbar
// put here here the widget will be named
// (name+counter)
#define VDK_WIDGET "toolbar"
//=================================================================
static char buff[128];
static GtkWidget* new_pixmap_file (char *pixfile,
				   GdkWindow *window,
				   GdkColor  *background);
static void gtk_toolbar_remove (GtkContainer *container,
				GtkWidget    *widget);
int CLASS::Counter = 0;

/*
   properties
*/
char* vdktoolbar_props[] =
{
  "Orientation",
  "Style",
  "Relief",
  "Spacing",
  0
};

char* vdktoolbar_signals[] =
{
"clicked_signal", 0
};
char* vdktoolbar_nicknames[] =
{
"Clicked",0
};

DEFINE_EVENT_LIST(CLASS,VDKBEventContainer);
DEFINE_SIGNAL_LIST(CLASS,VDKBEventContainer);


/*
 */
bool
CLASS:: DelBox(VDKObject* sender)
{
  // destroy inner gtk+ placeholder widget
  gtk_widget_destroy(container);
  // call ancestor delete box
  VDKBEventContainer::DelBox(sender);
  // notify to inspector that object was deleted
  VDKBGuiForm* ownerform = dynamic_cast<VDKBGuiForm*>(Owner());
  if(ownerform)
    {
      VDKBProjectManager* prjman =
	dynamic_cast<VDKBProjectManager*>(ownerform->Owner());
      if(prjman && prjman->objInspector)
	prjman->objInspector->SetActive(NULL);
    }
return true;
}

/*
 */
bool
CLASS::SetBoxSize(VDKObject* sender)
{
  VDKBGuiForm* ownerform = dynamic_cast<VDKBGuiForm*>(Owner());
  if(ownerform)
    {
      ownerform->SetBoxSize(NULL);
    }
  return true;
}
/*
 */
bool
CLASS::RemoveButton(VDKObject* sender)
{
if( (buttonlist.size() <= 0) || (ButtonSelected < 0) )
  return true;
else if(ButtonSelected >= 0)
  {
    gtk_toolbar_remove (GTK_CONTAINER(container),
			buttonlist[ButtonSelected].button);
    buttonlist.unlink(ButtonSelected);
    removebutton->Enabled = buttonlist.size() > 0 ;
    ButtonSelected = -1;
  }
return true;
}
/*
 */
bool
CLASS::AddButton(VDKObject* sender)
{
  ToolButtonData tbdata;
  GtkWidget *pixmap;
  GtkWidget *button;
  Vdkb_tooldialogForm* dlg =
    new Vdkb_tooldialogForm(Owner(),
			    NULL,
			    &(tbdata.pix),
			    &(tbdata.tip),
			    &(tbdata.text));
  dlg->Setup();
  dlg->ShowModal();
  if(tbdata.pix.isNull())
    return true;
  pixmap = new_pixmap_file ( (char*) tbdata.pix,
			    Owner()->Window()->window,
			    &Widget()->style->bg[GTK_STATE_NORMAL]);

  button = gtk_toolbar_append_item (GTK_TOOLBAR (container),
			tbdata.text.isNull() ? NULL: (char*) tbdata.text,
			NULL,
			NULL,
			pixmap,
			GTK_SIGNAL_FUNC(CLASS::OnButtonSignal),
                        (gpointer) this);
  // add button to button list
  tbdata.button = button;
  buttonlist.add(tbdata);
  removebutton->Enabled = buttonlist.size() > 0 ;
  return true;
}

/*
set button insensitive to
indicate button selected
inelegant, but nothing better for now
*/
void
CLASS::OnButtonSignal(GtkWidget *wid, gpointer gp)
{
  int t = 0;
  g_return_if_fail(wid != NULL);
  g_return_if_fail(gp != NULL);

  CLASS* toolbar = reinterpret_cast<CLASS*> (gp);

  if(toolbar->ButtonSelected >= 0)
      gtk_widget_set_sensitive(toolbar->
		      buttonlist[toolbar->ButtonSelected].button,true);
  TBDListIterator li(toolbar->buttonlist);
  for(;li;li++,t++)
    if(wid == li.current().button)
      break;
  if(t < toolbar->buttonlist.size())
    toolbar->ButtonSelected = t;
  else
    toolbar->ButtonSelected = -1;
  if(toolbar->ButtonSelected >= 0)
      gtk_widget_set_sensitive(toolbar->
		 buttonlist[toolbar->ButtonSelected].button,false);
  return;
}

//===========================================
/*
 */
CLASS::CLASS(char* name, VDKForm* owner):
  VDKBEventContainer(name,owner)
{
  Counter++;
  VDKBObject::object = this;
  VDKBEventContainer::mode = mode;
  Init();
}

/*
 */
CLASS::CLASS(char* name,VDKBEventContainer* outer):
    VDKBEventContainer(name,outer->Owner())
{
  VDKBObject::object = this;
  Counter++;
  outerbox = outer;
  Init();
 }
/*
 */
void
CLASS::Init()
{
  int t;
  for(t=0; vdktoolbar_props[t]; t++)
    proplist.add(VDKBProperty(vdktoolbar_props[t]));
  for(t=0; vdktoolbar_signals[t]; t++)
    siglist.add(VDKBSignal(vdktoolbar_signals[t],
			   this,
			   vdktoolbar_nicknames[t]));
  ButtonSelected = -1;
  AddBox();
  // makes a pop menu
  popmenu = new VDKBContainerPopMenu(this);
  addbutton = new VDKMenuItem(popmenu,"Add a toolbar button");
  removebutton = new VDKMenuItem(popmenu,"Remove selected button");
  popmenu->Separator();
  removebutton->Enabled =
    (buttonlist.size() > 0) && (ButtonSelected >= 0) ;
  delBox = new VDKMenuItem(popmenu,"Remove toolbar");
  setsize = new VDKMenuItem(popmenu,"Set min size");

  SignalConnect(addbutton,"activate",&CLASS::AddButton);
  SignalConnect(removebutton,"activate",&CLASS::RemoveButton);
  SignalConnect(delBox,"activate",&CLASS::DelBox);
  SignalConnect(setsize,"activate",&CLASS::SetBoxSize);

  CONNECT_COMMON_EVENTS;
  /* assign this as parent so this can receive signals  */
  popmenu->Parent(this);
  popmenu->Setup();
  /*
    better add it to owner, so will be surely
    destroyed even if never popped
  */
  Owner()->AddItem(popmenu);
}
/*
 */
void
CLASS::AddBox()
{
  // by default horizontal and shows both icon and etxt
  container = gtk_toolbar_new(GTK_ORIENTATION_HORIZONTAL,GTK_TOOLBAR_BOTH);
  gtk_toolbar_set_space_size(GTK_TOOLBAR(container),2);
  gtk_toolbar_set_button_relief (GTK_TOOLBAR (container), GTK_RELIEF_NONE);
  gtk_widget_set_usize(GTK_WIDGET(container),-1,30);
  gtk_container_add(GTK_CONTAINER(widget),container);
  gtk_widget_show(container);
}

/*
extra args unused
 */
void
CLASS::AddWidget(VDKObject* wid, int justify,
			int expand, int fill , int padding,
			bool forceArgs)
{
  gtk_toolbar_append_widget(GTK_TOOLBAR(container),wid->Widget(),NULL,NULL);
  gtk_widget_show(wid->Widget());
  VDKBEventContainer::Add(wid,l_justify,expand,fill,padding);
}
/*
extra args used
 */
void
CLASS::Add(VDKObject* wid, int justify,
			int expand, int fill , int padding,
			bool forceArgs)
{
AddWidget(wid);
}
/*
  This method is called by global MakeWidget() in vdkb_design.cc
  MakeWidget() scans a table that maps class id's with each
  static MakeWidget() for each class. Class id's are generated
  during clicks on widget palette.
  On return:
  0 - successfull
  1 - unsupported widget
  2 - target is not a container
  3 - no active widget
*/
int
CLASS::MakeWidget(VDKBGuiForm* owner, GdkEvent* ev)
{
  // autogenerate first suitable frame counter
  // to ensure unicity
  int result = 0;
  for(sprintf(buff,"%s%d",VDK_WIDGET,CLASS::Counter);
      owner->ChildWithName(buff)!= (VDKObject*) NULL;
      CLASS::Counter++)
    sprintf(buff,"%s%d",VDK_WIDGET,CLASS::Counter);
  CLASS* box = new CLASS(buff,owner);
  if(owner->Active)
    {
      VDKBEventContainer* container =
	dynamic_cast<VDKBEventContainer*>(owner->Active);
      if(container)
	{
	  if(ev && dynamic_cast<VDKBFixed*>(container))
	    {
	      GdkEventButton* event = (GdkEventButton*) ev;
	      sprintf(buff,"%d",int(event->x));
	      box->SetPropValue(JUSTIFY_INTERNAL,buff);
	      sprintf(buff,"%d",int(event->y));
	      box->SetPropValue( EXPAND_INTERNAL,buff);
	      box->SetSize(30,30);
	      // others than justify and flag unuseful
	      container->AddWidget(box,int(event->x),
				   int(event->y),
				   true,true,true);
	    }
	  else
	    container->AddWidget(box);
	  box->outerbox = container;
	}
      else if(! owner->Active->AddToParent(box,ev))
	// target isn't a container
	  result =  2;
    }
  else
    // no active widget
    result = 3;
  // 0 on success
  if(result)
    box->Destroy();
 return result;
}
////////////////////////////////////////////////////////////////////
/*
 */
void
CLASS::WriteOnFrm(FILE* fp, VDKBObject* parentobj)
{
  VDKBObject::WriteOnFrm(fp,parentobj);
  fprintf(fp,"\n\tBorderWidth:%s;", (char*) GetProp("BorderWidth"));
  fprintf(fp,"\n\tSpacing:%s;", (char*) GetProp("Spacing"));
  fprintf(fp,"\n\tOrientation:%s;", (char*) GetProp("Orientation"));
  fprintf(fp,"\n\tStyle:%s;", (char*) GetProp("Style"));
  fprintf(fp,"\n\tRelief:%s;", (char*) GetProp("Relief"));
  fprintf(fp,"\n\tButtons:%d;", buttonlist.size());
  fprintf(fp,"\n\tPixmaps:\"");
  int t,last = buttonlist.size();
  if(last)
    {
      for(t = 0; t < last-1 ; t++)
	fprintf(fp,"%s,", (char*) buttonlist[t].pix);
      fprintf(fp,"%s\";", (char*) buttonlist[last-1].pix);
      fprintf(fp,"\n\tTips:\"");
      for(t = 0; t < last-1 ; t++)
	fprintf(fp,"%s,",
		(char*) buttonlist[t].tip.isNull() ? NIHIL_PROP :
		(char*) buttonlist[t].tip);
      fprintf(fp,"%s\";", (char*) buttonlist[last-1].tip.isNull() ? NIHIL_PROP:
	      (char*) buttonlist[last-1].tip);
      fprintf(fp,"\n\tTexts:\"");
      for(t = 0; t < last-1 ; t++)
	fprintf(fp,"%s,", (char*) buttonlist[t].text.isNull() ? NIHIL_PROP :
		(char*) buttonlist[t].text);
      fprintf(fp,"%s\";", (char*) buttonlist[last-1].text.isNull() ? NIHIL_PROP :
	      (char*) buttonlist[t].text);
    }
}

char*
CLASS::CreateSource(char* buffer,VDKBParser& parser)
{
  char* source;
  char obj_name[128];
  char obj_parent[128];
  char temp[256];
  char bw[16];
  char arg[128];
  // get name, mode and parent
  if ( !parser.GetParam(obj_name,buffer,"this:") ||
       !parser.GetParam(obj_parent,buffer,"parent:")
       )
    return NULL;
  else
    source = new char[8192];
  sprintf(temp,"\n%s = new %s(this);",obj_name,VDK_CLASS);
  strcpy(source,temp);
  // get size
  VDKPoint size = parser.Size(buffer);
  if(size.X() > 0 || size.Y() > 0)
    {
      sprintf(temp,"\n%s->SetSize(%d,%d);",obj_name,size.X(),size.Y());
      strcat(source,temp);
    }
  if(strcmp(obj_parent,NIHIL_PROP))
    sprintf(temp,"\n%s->Add(%s",obj_parent,obj_name);
  else
    sprintf(temp,"\nAdd(%s",obj_name);
  strcat(source,temp);
  // prepares arguments for add widget to container
  char justify[16],expand[16],fill[16],padding[16];
  if(parser.GetParam(justify,buffer,PROP_JUSTIFY_INTERNAL) &&
     parser.GetParam(expand,buffer,PROP_EXPAND_INTERNAL) &&
     parser.GetParam(fill,buffer,PROP_FILL_INTERNAL) &&
     parser.GetParam(padding,buffer,PROP_PADDING_INTERNAL))
    {
      sprintf(temp,",%s,%s,%s,%s);",
	      justify,expand,fill,padding);
      strcat(source,temp);
    }
  else
    {
      sprintf(temp,");");
      strcat(source,temp);
    }

  if(parser.GetParam(bw,buffer,"BorderWidth:") &&
     strcmp(bw,NIHIL_PROP))
    {
      sprintf(temp,"\n%s->BorderWidth(%s);",obj_name,bw);
      strcat(source,temp);
    }
  if(parser.GetParam(arg,buffer,"Spacing:") && strcmp(arg,NIHIL_PROP))
    {
      sprintf(temp,"\n%s->Spacing = %s;",obj_name,arg);
      strcat(source,temp);
    }
  // other props
  if(parser.GetParam(arg,buffer,"Orientation:") && strcmp(arg,NIHIL_PROP))
   {
     sprintf(temp,"\n%s->Orientation = (GtkOrientation) %s;",obj_name,arg);
     strcat(source,temp);
   }
  if(parser.GetParam(arg,buffer,"Style:") && strcmp(arg,NIHIL_PROP))
   {
     sprintf(temp,"\n%s->Style = (GtkToolbarStyle) %s;",obj_name,arg);
     strcat(source,temp);
   }
  if(parser.GetParam(arg,buffer,"Relief:") && strcmp(arg,NIHIL_PROP))
    {
      sprintf(temp,"\n%s->Relief = (GtkReliefStyle) %s;",obj_name,arg);
      strcat(source,temp);
    }
  // create buttons
  CLASS::CreateButtons(buffer,parser,source,obj_name);
  return source;
}
/*
 */
void
CLASS::CreateButtons(char* buffer,
			   VDKBParser& parser,
			   char* source,
			   char* obj_name)
{
  TBDList buttonlist;
  VDKString Nihil = NIHIL_PROP;
  int n = 0, t = 0 ;
  char tmp[512];
  char arg[16],*local,*p;
  if(parser.GetParam(arg,buffer,"Buttons:"))
    n = atoi(arg);
  else
    return ;
  local = new char[4096];
  // now in local there are a list of pixmaps
  if(!parser.GetParam(local,buffer,"Pixmaps:"))
    {
      delete[] local;
      return ;
    }
  p = strtok(local,",");
  while(p)
    {
      ToolButtonData tbdata;
      tbdata.pix = p;
      buttonlist.add(tbdata);
      p = strtok(NULL,",");
    }
  // for safe
  if( buttonlist.size() != n)
    return ;
  // now in local there are a list of tips
  if(!parser.GetParam(local,buffer,"Tips:"))
    {
      delete[] local;
      return;
    }
  t = 0;
  p = strtok(local,",");
  while(p && (t < buttonlist.size()))
    {

      buttonlist[t].tip = p;
      t++;
      p = strtok(NULL,",");
    }
  // now in local there are a list of tips
  if(!parser.GetParam(local,buffer,"Texts:"))
    {
      delete[] local;
      return;
    }
  t = 0;
  p = strtok(local,",");
  while(p && (t < buttonlist.size()))
    {

      buttonlist[t].text = p;
      t++;
      p = strtok(NULL,",");
    }
  delete[] local;
  // write code to add button
  TBDListIterator li(buttonlist);
  for(;li;li++)
    {
      ToolButtonData tbd = li.current();
      sprintf(tmp,"\n%s->AddButton(%s%s%s,%s%s%s,%s%s%s);",
	      obj_name,
	      tbd.pix == Nihil ? "" : "\"",
	      tbd.pix == Nihil ? "NULL" : (char*) tbd.pix,
	      tbd.pix == Nihil ? "" : "\"",
	
	      tbd.tip == Nihil ? "" : "\"",
	      tbd.tip == Nihil ? "NULL" : (char*) tbd.tip,
	      tbd.tip == Nihil ? "" : "\"",

	      tbd.text == Nihil ? "" : "\"",
	      tbd.text == Nihil ? "NULL" : (char*) tbd.text,
	      tbd.text == Nihil ? "" : "\"");
      strcat(source,tmp);
    }
}
/*
 */
bool
CLASS::LoadButtons(char* buffer,VDKBParser& parser)
{
  int n = 0, t = 0 ;
  char arg[16],*local,*p;
  if(parser.GetParam(arg,buffer,"Buttons:"))
    n = atoi(arg);
  else
    return false;
  local = new char[4096];
  // now in local there are a list of pixmaps
  if(!parser.GetParam(local,buffer,"Pixmaps:"))
    {
      delete[] local;
      return false;
    }
  p = strtok(local,",");
  while(p)
    {
      ToolButtonData tbdata;
      tbdata.pix = p;
      buttonlist.add(tbdata);
      p = strtok(NULL,",");
    }
  // for safe
  if( buttonlist.size() != n)
    return false;
  // now in local there are a list of tips
  if(!parser.GetParam(local,buffer,"Tips:"))
    {
      delete[] local;
      return false;
    }
  t = 0;
  p = strtok(local,",");
  while(p && (t < buttonlist.size()))
    {

      buttonlist[t].tip = p;
      t++;
      p = strtok(NULL,",");
    }
  // now in local there are a list of tips
  if(!parser.GetParam(local,buffer,"Texts:"))
    {
      delete[] local;
      return false;
    }
  t = 0;
  p = strtok(local,",");
  while(p && (t < buttonlist.size()))
    {

      buttonlist[t].text = p;
      t++;
      p = strtok(NULL,",");
    }
  delete[] local;
  // add buttons to toolbar
  VDKString Nihil = NIHIL_PROP;
  for(t=0; t< buttonlist.size();t++)
    {

      GtkWidget *pixmap = new_pixmap_file ( (char*) buttonlist[t].pix,
			    Owner()->Window()->window,
			    &Widget()->style->bg[GTK_STATE_NORMAL]);

      GtkWidget * button = gtk_toolbar_append_item (GTK_TOOLBAR (container),
			buttonlist[t].text == Nihil ? NULL:
			(char*) buttonlist[t].text,
			buttonlist[t].tip == Nihil ? NULL:
			(char*) buttonlist[t].tip,
			NULL,
			pixmap,
			GTK_SIGNAL_FUNC(CLASS::OnButtonSignal),
                        (gpointer) this);
     buttonlist[t].button = button;
    }
  removebutton->Enabled = buttonlist.size() > 0 ;
  return true;
}
/*
 */
bool
CLASS::CreateWidget(VDKBGuiForm* owner, char* buffer,VDKBParser& parser)
{
  char obj_name[128];
  char obj_parent[128];
  CLASS* box;
  // get name, mode and parent
  if ( !parser.GetParam(obj_name,buffer,"this:") ||
       !parser.GetParam(obj_parent,buffer,"parent:")
       )
    return false;
  // get mode and size
  VDKPoint size = parser.Size(buffer);
  // get packing args
  int justification = l_justify;
  int expand=0,fill=0,padding=0;
  int bw; // border width
  int space; // spacing
  char arg[32];
  if(parser.GetParam(arg,buffer,PROP_JUSTIFY_INTERNAL))
    justification = atoi(arg);
  if(parser.GetParam(arg,buffer,PROP_EXPAND_INTERNAL))
    expand = atoi(arg);
  if(parser.GetParam(arg,buffer,PROP_FILL_INTERNAL))
    fill = atoi(arg);
  if(parser.GetParam(arg,buffer,PROP_PADDING_INTERNAL))
    padding= atoi(arg);
  if(parser.GetParam(arg,buffer,"BorderWidth:") &&
     strcmp(arg,NIHIL_PROP))
    bw = atoi(arg);
  else
    bw = -1;
  if(parser.GetParam(arg,buffer,"Spacing:") &&
     strcmp(arg,NIHIL_PROP))
    space = atoi(arg);
  else
    space = -1;

  // no parent, widget will be added to owner form innerbox
  if(!strcmp(obj_parent,NIHIL_PROP))
    {
      box = new CLASS(obj_name,owner->InnerBox());
      if(space>=0)
	{
	  box->SetPropValue("Spacing",arg);
	  gtk_toolbar_set_space_size(GTK_TOOLBAR(box->Container()),
				     space);
	}
      box->LoadButtons(buffer, parser);
      owner->AddWidget(box,justification,expand,fill,padding);
    }
  // get parent container address
  else
    {
      VDKObject* p = owner->ChildWithName(obj_parent);
      VDKBEventContainer* container = p ?
	dynamic_cast<VDKBEventContainer*>(p) : (VDKBEventContainer*) NULL;
      if(container)
	{
	  box = new CLASS(obj_name,container);
	  if(space>=0)
	    {
	      box->SetPropValue("Spacing",arg);
	      gtk_toolbar_set_space_size(GTK_TOOLBAR(box->Container()),
				  space);
	    }
	  box->LoadButtons(buffer, parser);
	  container->AddWidget(box,justification,expand,fill,padding,true);
	  box->outerbox = container;
	}
      else
	// FIX ME: user warning
	return false;
    }
  // others props
  if(parser.GetParam(arg,buffer,"Orientation:") && strcmp(arg,NIHIL_PROP))
    {
      gtk_toolbar_set_orientation(GTK_TOOLBAR(box->Container()),
				  (GtkOrientation) atoi(arg));
      box->SetPropValue("Orientation",arg);
    }
  if(parser.GetParam(arg,buffer,"Style:") && strcmp(arg,NIHIL_PROP))
    {
      gtk_toolbar_set_style(GTK_TOOLBAR(box->Container()),
				  (GtkToolbarStyle) atoi(arg));
      box->SetPropValue("Style",arg);
    }
  if(parser.GetParam(arg,buffer,"Relief:") && strcmp(arg,NIHIL_PROP))
    {
      gtk_toolbar_set_button_relief(GTK_TOOLBAR(box->Container()),
				  (GtkReliefStyle) atoi(arg));
      box->SetPropValue("Relief",arg);
    }
  // call ancestor to set common properties
  VDKBObject::CreateWidget(box,buffer,parser);
  if(size.X() > 0 || size.Y() > 0)
    box->ObjectFromVDK()->SetSize(size.X(),size.Y());
  if(bw >= 0)
    {
      box->BorderWidth(bw);
      box->SetPropValue("BorderWidth",arg);
    }
return true;
}
/////////////////////////////////////////////////////
//           OBJECT INSPECTOR MANAGEMENT
////////////////////////////////////////////////////
/*
This is called by object inspector when a widget
is selected by user, thus to allow widget to set
his own property controls.
 */
static char *tb_orientation[] =
{ "horizontal","vertical",0 };
static char* tb_style[] =
{ "icons","text","both",0};
static char *reliefs[] =
{ "normal","half","none",0 };

VDKObjectContainer*
CLASS::ExtraWidget(VDKBObjectInspector* isp)
{
  inspector = isp;
  VDKFrame* tframe = new VDKFrame(inspector,NULL,v_box,shadow_etched_in);

  VDKTable *table = new VDKTable(inspector,5,2);
  table->SetSize(219,-1);
  VDKLabelButton* button = new VDKLabelButton(inspector,"Set border width");
  table->AddToCell(button,0,0);
  int bw = atoi( (char*) GetProp("BorderWidth"));
  border = new VDKSpinButton(inspector, bw, 0, 20 , 1 ,0 );
  table->AddToCell(border,0,1);
  button->Parent(this);
  SignalConnect(button,"clicked",&CLASS::OnBorderWidth);

  VDKLabelButton* setorientation =
    new VDKLabelButton(inspector,"Set orientation");
  table->AddToCell(setorientation,1,0);
  setorientation->Parent(this);
  SignalConnect(setorientation,"clicked",&CLASS::OnSetOrientation);
  int r = atoi(GetProp("Orientation"));
  orientation = new VDKCombo(inspector,NULL);
  orientation->SetSize(100,-1);
  StringList sl;
  int t = 0;
  for(;tb_orientation[t];t++)
    sl.add(VDKString(tb_orientation[t]));
  orientation->PopdownStrings = sl;
  orientation->SelectItem(r);
  table->AddToCell(orientation,1,1);

  VDKLabelButton* setstyle =
    new VDKLabelButton(inspector,"Set style");
  table->AddToCell(setstyle,2,0);
  setstyle->Parent(this);
  SignalConnect(setstyle,"clicked",&CLASS::OnSetStyle);
  r = atoi(GetProp("Style"));
  style = new VDKCombo(inspector,NULL);
  style->SetSize(100,-1);
  StringList st;
  t = 0;
  for(;tb_style[t];t++)
    st.add(VDKString(tb_style[t]));
  style->PopdownStrings = st;
  style->SelectItem(r);
  table->AddToCell(style,2,1);


  VDKLabelButton* setrelief =
    new VDKLabelButton(inspector,"Set relief");
  table->AddToCell(setrelief,3,0);
  setrelief->Parent(this);
  SignalConnect(setrelief,"clicked",&CLASS::OnSetRelief);
  r = atoi(GetProp("Relief"));
  relief = new VDKCombo(inspector,NULL);
  relief->SetSize(100,-1);
  StringList sr;
  t = 0;
  for(;reliefs[t];t++)
    sr.add(VDKString(reliefs[t]));
  relief->PopdownStrings = sr;
  relief->SelectItem(r);
  table->AddToCell(relief,3,1);

  VDKLabelButton* setspacing = new VDKLabelButton(inspector, "Set spacing");
  table->AddToCell(setspacing,4,0);
  setspacing->Parent(this);
  SignalConnect(setspacing,"clicked",&CLASS::OnSetSpacing);
  int sp = atoi( (char*) GetProp("Spacing"));
  spacing = new VDKSpinButton(inspector, sp, 0, 20 , 1 ,0 );
  spacing->SetSize(100,-1);
  table->AddToCell(spacing,4,1);

  tframe->Add(table,l_justify,false,false,false);
  return tframe;
}

/*
 */
bool
CLASS::OnBorderWidth(VDKObject*)
{
  sprintf(buff,"%d",(int) border->ValueAsInt);
  SetPropValue("BorderWidth",buff);
  BorderWidth((int) border->ValueAsInt);
  inspector->FormNeedToBeChanged();
  return true;
}

/*
 */
bool
CLASS::OnSetOrientation(VDKObject*)
{
  int sel = orientation->Selected;
  sprintf(buff,"%d", sel >= 0 ? sel : 0);
  int orient = atoi(buff);
  SetPropValue("Orientation",buff);
  gtk_toolbar_set_orientation(GTK_TOOLBAR(container),
			      (GtkOrientation) orient);
  inspector->FormNeedToBeChanged();
  return true;
}
/*
 */
bool
CLASS::OnSetStyle(VDKObject*)
{
  int sel = style->Selected;
  sprintf(buff,"%d", sel >= 0 ? sel : 0);
  int st = atoi(buff);
  SetPropValue("Style",buff);
  gtk_toolbar_set_style(GTK_TOOLBAR(container),
			(GtkToolbarStyle) st);
  inspector->FormNeedToBeChanged();
  return true;
}

/*
 */
bool
CLASS::OnSetRelief(VDKObject*)
{
  int sel = relief->Selected;
  sprintf(buff,"%d", sel >= 0 ? sel : 0);
  int r = atoi(buff);
  SetPropValue("Relief",buff);
  gtk_toolbar_set_button_relief(GTK_TOOLBAR(container),
			  (GtkReliefStyle) r);
  inspector->FormNeedToBeChanged();
  return true;
}
/*
 */
bool
CLASS::OnSetSpacing(VDKObject*)
{
  sprintf(buff,"%d",(int) spacing->ValueAsInt);
  SetPropValue("Spacing",buff);
  gtk_toolbar_set_space_size(GTK_TOOLBAR(container),
			     (int) spacing->ValueAsInt);
  inspector->FormNeedToBeChanged();
  return true;
}
/*
 */
GtkWidget*
new_pixmap_file (char *pixfile, GdkWindow *window, GdkColor  *background)
{
  GtkWidget *wpixmap;
  GdkPixmap *pixmap;
  GdkBitmap *mask;

  pixmap = gdk_pixmap_create_from_xpm (window, &mask, background, pixfile);
  wpixmap = gtk_pixmap_new (pixmap, mask);
  return wpixmap;
}
/*
 */
static void
gtk_toolbar_remove (GtkContainer *container,
		    GtkWidget    *widget)
{
  GtkToolbar *toolbar;
  GList *children;
  GtkToolbarChild *child;

  g_return_if_fail (container != NULL);
  g_return_if_fail (GTK_IS_TOOLBAR (container));
  g_return_if_fail (widget != NULL);

  toolbar = GTK_TOOLBAR (container);

  for (children = toolbar->children; children; children = children->next)
    {
      child = (GtkToolbarChild *) children->data;

      if ((child->type != GTK_TOOLBAR_CHILD_SPACE) && (child->widget == widget))
	{
	  gboolean was_visible;

	  was_visible = GTK_WIDGET_VISIBLE (widget);
	  gtk_widget_unparent (widget);

	  toolbar->children = g_list_remove_link (toolbar->children, children);
	  g_free (child);
	  g_list_free (children);
	  toolbar->num_children--;

	  if (was_visible && GTK_WIDGET_VISIBLE (container))
	    gtk_widget_queue_resize (GTK_WIDGET (container));

	  break;
	}
    }
}



