MODULE VOScrollerPrefs;

(*
    Copyright (C) 1999  Tim Teulings (rael@edge.ping.de)

    This module is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public License
    as published by the Free Software Foundation; either version 2 of
    the License, or (at your option) any later version.

    This module is distributed in the hope that it will be useful, but
    WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public
    License along with VisualOberon. If not, write to the Free Software Foundation,
    59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*)

IMPORT B   := VOButton,
       F   := VOFrame,
       FG  := VOFrameGroup,
       FSD := VOFrmSelDlg,
       G   := VOGUIObject,
       ISD := VOImgSelDlg,
       L   := VOLabel,
       O   := VOObject,
       P   := VOPanel,
       PG  := VOPrefsGUI,
       PP  := VOPrefsParser,
       S   := VOScroller,
       SP  := VOSpace,
       V   := VOVecImage;

TYPE
  Item*     = POINTER TO ItemDesc;

  (**
   TODO
   Make it only use one ImgSelDlg.
  **)

  ItemDesc* = RECORD (PG.PrefsItemDesc)
                prefs       : S.PrefsDesc;
                frmSelDlg   : FSD.FrmSelDlg;
                frame       : F.Frame;
                imgSelDlg   : ISD.ImgSelDlg;
                image       : V.VecImage;
                upSelDlg    : ISD.ImgSelDlg;
                up          : V.VecImage;
                downSelDlg  : ISD.ImgSelDlg;
                down        : V.VecImage;
                leftSelDlg  : ISD.ImgSelDlg;
                left        : V.VecImage;
                rightSelDlg : ISD.ImgSelDlg;
                right       : V.VecImage;
              END;

VAR
  prefs : Item;

  PROCEDURE (d : Item) Init*;

  BEGIN
    d.Init^;
    d.name:="Scroller";
    PG.settings.AddItem(d);

    NEW(d.frmSelDlg);
    d.frmSelDlg.Init;
    NEW(d.imgSelDlg);
    d.imgSelDlg.Init;
    NEW(d.upSelDlg);
    d.upSelDlg.Init;
    NEW(d.downSelDlg);
    d.downSelDlg.Init;
    NEW(d.leftSelDlg);
    d.leftSelDlg.Init;
    NEW(d.rightSelDlg);
    d.rightSelDlg.Init;
  END Init;

  PROCEDURE (d : Item) GetObject*():G.Object;

  VAR
    button : B.Button;
    frame  : FG.FrameGroup;
    label  : L.Label;
    panel  : P.Panel;
    space  : SP.Space;

  BEGIN
    d.frmSelDlg.SetDisplay(d.display);
    d.frmSelDlg.Forward(FSD.setMsg,d);

    d.imgSelDlg.SetDisplay(d.display);
    d.imgSelDlg.Forward(ISD.setMsg,d);

    d.upSelDlg.SetDisplay(d.display);
    d.upSelDlg.Forward(ISD.setMsg,d);

    d.downSelDlg.SetDisplay(d.display);
    d.downSelDlg.Forward(ISD.setMsg,d);

    d.leftSelDlg.SetDisplay(d.display);
    d.leftSelDlg.Forward(ISD.setMsg,d);

    d.rightSelDlg.SetDisplay(d.display);
    d.rightSelDlg.Forward(ISD.setMsg,d);

    NEW(panel);
    panel.Init;
    panel.Set(P.vertical);

      NEW(frame);
      frame.Init;
      frame.SetFlags({G.horizontalFlex});
      frame.SetTextLabel("Frame");
        button:=PG.CreateFrameButton(d.prefs.frame,d.frame,d.display,d.frmSelDlg,
                                     d.window.keyHandler,"Select frame");
      frame.Add(button);
    panel.Add(frame);

      NEW(space);
      space.Init;
      space.Set(TRUE,SP.normal);
    panel.Add(space);

      NEW(frame);
      frame.Init;
      frame.SetFlags({G.horizontalFlex});
      frame.SetTextLabel("Knob");
        button:=PG.CreateImageButton(d.prefs.knob,d.image,d.display,d.imgSelDlg,
                                     d.window.keyHandler,"Select knob");
      frame.Add(button);
    panel.Add(frame);

      NEW(space);
      space.Init;
      space.Set(TRUE,SP.normal);
    panel.Add(space);

      NEW(frame);
      frame.Init;
      frame.SetFlags({G.horizontalFlex});
      frame.SetTextLabel("Images");

        NEW(label);
        label.Init;

          button:=PG.CreateImageButton(d.prefs.up,d.up,d.display,d.upSelDlg,
                                       d.window.keyHandler,"Up image");
        label.AddTextLabel("Up image",button);

          button:=PG.CreateImageButton(d.prefs.down,d.down,d.display,d.downSelDlg,
                                       d.window.keyHandler,"Down image");
        label.AddTextLabel("Down image",button);

          button:=PG.CreateImageButton(d.prefs.left,d.left,d.display,d.leftSelDlg,
                                       d.window.keyHandler,"Left image");
        label.AddTextLabel("Left image",button);

          button:=PG.CreateImageButton(d.prefs.right,d.right,d.display,d.rightSelDlg,
                                       d.window.keyHandler,"Select image");
        label.AddTextLabel("Right image",button);
      frame.Add(label);
    panel.Add(frame);

    RETURN panel;
  END GetObject;

  PROCEDURE (p : Item) Refresh*;

  BEGIN
    p.prefs:=S.prefs^;

    p.frmSelDlg.SetFrame(p.prefs.frame);
    p.frame.SetInternalFrame(p.prefs.frame);
    p.imgSelDlg.SetImage(p.prefs.knob);
    p.image.Set(p.prefs.knob);
    p.upSelDlg.SetImage(p.prefs.up);
    p.up.Set(p.prefs.up);
    p.downSelDlg.SetImage(p.prefs.down);
    p.down.Set(p.prefs.down);
    p.leftSelDlg.SetImage(p.prefs.left);
    p.left.Set(p.prefs.left);
    p.rightSelDlg.SetImage(p.prefs.right);
    p.right.Set(p.prefs.right);
  END Refresh;

  PROCEDURE (p : Item) LoadPrefs*(appName : ARRAY OF CHAR);

  VAR
    buffer : ARRAY 256 OF CHAR;
    pos    : LONGINT;
    top    : PP.Item;


  BEGIN
    p.LoadPrefs^(appName);

    top:=p.LoadPrefsFile("Scroller",appName);

    IF top#NIL THEN

      IF top.GetStringEntry("SCROLLER/frame",buffer) THEN
        pos:=F.GetFrameEntry(buffer);
        IF pos>=0 THEN
          S.prefs.frame:=pos;
        ELSE
          p.ErrorWrongData("SCROLLER/frame",buffer);
        END;
      END;

      IF top.GetStringEntry("SCROLLER/knob",buffer) THEN
        pos:=V.GetImageEntry(buffer);
        IF pos>=0 THEN
          S.prefs.knob:=pos;
        ELSE
          p.ErrorWrongData("SCROLLER/knob",buffer);
        END;
      END;

      IF top.GetStringEntry("SCROLLER/up",buffer) THEN
        pos:=V.GetImageEntry(buffer);
        IF pos>=0 THEN
          S.prefs.up:=pos;
        ELSE
          p.ErrorWrongData("SCROLLER/up",buffer);
        END;
      END;

      IF top.GetStringEntry("SCROLLER/down",buffer) THEN
        pos:=V.GetImageEntry(buffer);
        IF pos>=0 THEN
          S.prefs.down:=pos;
        ELSE
          p.ErrorWrongData("SCROLLER/down",buffer);
        END;
      END;

      IF top.GetStringEntry("SCROLLER/left",buffer) THEN
        pos:=V.GetImageEntry(buffer);
        IF pos>=0 THEN
          S.prefs.left:=pos;
        ELSE
          p.ErrorWrongData("SCROLLER/left",buffer);
        END;
      END;

      IF top.GetStringEntry("SCROLLER/right",buffer) THEN
        pos:=V.GetImageEntry(buffer);
        IF pos>=0 THEN
          S.prefs.right:=pos;
        ELSE
          p.ErrorWrongData("SCROLLER/right",buffer);
        END;
      END;

    END;
  END LoadPrefs;

  PROCEDURE (p : Item) Apply*;

  BEGIN
    S.prefs^:=p.prefs;
  END Apply;

  PROCEDURE (p : Item) Save*;

  VAR
    block    : PP.BlockItem;
    value    : PP.ValueItem;

  BEGIN
    NEW(block);
    block.Init;
    block.SetName("SCROLLER");
      NEW(value);
      value.Init;
      value.SetValue("frame",F.internalFrames[p.prefs.frame]);
    block.AddItem(value);
      NEW(value);
      value.Init;
      value.SetValue("knob",V.images[p.prefs.knob]);
    block.AddItem(value);
      NEW(value);
      value.Init;
      value.SetValue("up",V.images[p.prefs.up]);
    block.AddItem(value);
      NEW(value);
      value.Init;
      value.SetValue("down",V.images[p.prefs.down]);
    block.AddItem(value);
      NEW(value);
      value.Init;
      value.SetValue("left",V.images[p.prefs.left]);
    block.AddItem(value);
      NEW(value);
      value.Init;
      value.SetValue("right",V.images[p.prefs.right]);
    block.AddItem(value);

    p.SaveItems("Scroller",block);
  END Save;

  PROCEDURE (p : Item) Receive*(message : O.Message);

  BEGIN
    WITH
      message : FSD.SetMsg DO
        p.frame.SetInternalFrame(message.frame);
        p.prefs.frame:=message.frame;
    | message : ISD.SetMsg DO
        IF message.source=p.imgSelDlg THEN
          p.image.Set(message.image);
          p.prefs.knob:=message.image;
        ELSIF message.source=p.upSelDlg THEN
          p.up.Set(message.image);
          p.prefs.up:=message.image;
        ELSIF message.source=p.downSelDlg THEN
          p.down.Set(message.image);
          p.prefs.down:=message.image;
        ELSIF message.source=p.leftSelDlg THEN
          p.left.Set(message.image);
          p.prefs.left:=message.image;
        ELSIF message.source=p.rightSelDlg THEN
          p.right.Set(message.image);
          p.prefs.right:=message.image;
        END;
    ELSE
      p.Receive^(message);
    END;
  END Receive;

BEGIN
  NEW(prefs);
  prefs.Init;

END VOScrollerPrefs.