/****************************************************************************
|                         Digital Audio Processor
|                         =======================
|
| Filename    : comblowp.h
|
| Revision    : 1.1
| Date        : 25/01/96
|
| Object      : DSPKitCombLowPass
|
| Description : DSPKitCombLowPass
|
| (c) Richard Kent 1996
|
| $Id$
|
****************************************************************************/

#ifndef _DSPKIT_COMBLOWPASS_H_
#define _DSPKIT_COMBLOWPASS_H_

#include "processo.h"
#include "feedback.h"
#include "fbdelay.h"
#include "z1lpf.h"
#include "amp.h"
#include "mux.h"

class DSPKitCombLowPass : public DSPKitProcessor
{
  public:

    DSPKitCombLowPass ();
    long setInputAndDelayTime (DSPKitProcessor *ip,double dt);
    void setG (double newG);
    void setG1 (double newG1);
    void setReverbTime (double rt);
    double getReverbTime ();
    
  protected:

    void updateGains ();
    
    double                reverbTime;
    double                delayTime;
    double                g;
    double                g1;
    double                g2;
    DSPKitFeedback        feedback;
    DSPKitFBDelay         delay;
    DSPKitZ1LowPassFilter lpf;
    DSPKitAmp             amp;
    DSPKitMux             mux;
};

#endif

/***************************************************************************/
