/****************************************************************************
|                         Digital Audio Processor
|                         =======================
|
| Filename    : complim.h
|
| Revision    : 1.1
| Date        : 25/01/96
|
| Object      : DSPKitCompressorLimiter
|
| Description : DSPKitCompressorLimiter
|
| (c) Richard Kent 1996
|
| $Id$
|
****************************************************************************/

#ifndef _DSPKIT_COMPRESSORLIMITER_H_
#define _DSPKIT_COMPRESSORLIMITER_H_

#include "compress.h"
#include "limiter.h"

class DSPKitCompressorLimiter : public DSPKitProcessor
{
  public:

    long setInputAndEstimationTime
      (DSPKitProcessor *ip,double et);
    long setInputAndEstimationTime
      (DSPKitProcessor *ip,double compet,double limet);
    void setCompressorThreshold (double value);
    void setLimiterThreshold (double value);
    void setCompressionRatio (double value);

  protected:

    DSPKitCompressor compressor;
    DSPKitLimiter    limiter;
};

inline void DSPKitCompressorLimiter::setCompressorThreshold (double value)
{
  compressor.setThreshold (value);
}

inline void DSPKitCompressorLimiter::setLimiterThreshold (double value)
{
  limiter.setThreshold (value);
}

inline void DSPKitCompressorLimiter::setCompressionRatio (double value)
{
  compressor.setRatio (value);
}

#endif

/***************************************************************************/
