/****************************************************************************
|                         Digital Audio Processor
|                         =======================
|
| Filename    : dpreader.h
|
| Revision    : 1.1
| Date        : 25/01/96
|
| Object      : DSPKitDPReader;
|
| Description : DSPKitDPReader;
|
| (c) Richard Kent 1996
|
| $Id$
|
****************************************************************************/

class DSPKitDPReader;

#ifndef _DSPKIT_DPREADER_H_
#define _DSPKIT_DPREADER_H_

#include "DPSample.h"
#include "processo.h"

class DSPKitDPReader : public DSPKitProcessor
{
  public:

    DSPKitDPReader ();
    long setInput (
      DPSample *newSample,
      long newChannel,
      long newSusLoops,
      long newRelLoops);
    long getSample (double &outputSample);
    DSPKitProcessor *getInput ();
    long getSampleCount () const;
    long getSamplesLeft () const;
    
  protected:

    long     sampleCount;
    long     samplesLeft;
    DPSample *sample;
    long     channel;
    long     susLoops;
    long     relLoops;
    long     susLoopsTemp;
    long     relLoopsTemp;
    long     i;
    long     frames;
    long     increment;
    long     tempSusLoopMode;
    long     tempRelLoopMode;
    long     susLoopStart;
    long     susLoopEnd;
    long     relLoopStart;
    long     relLoopEnd;
    long     check;
    long     checkReset;
};

inline DSPKitProcessor *DSPKitDPReader::getInput ()
{
  return 0;
}

inline long DSPKitDPReader::getSampleCount () const
{
  return sampleCount;
}

inline long DSPKitDPReader::getSamplesLeft () const
{
  return samplesLeft;
}

#endif

/***************************************************************************/
