/****************************************************************************
|                         Digital Audio Processor
|                         =======================
|
| Filename    : dpwriter.h
|
| Revision    : 1.1
| Date        : 25/01/96
|
| Object      : DSPKitDPWriter;
|
| Description : DSPKitDPWriter;
|
| (c) Richard Kent 1996
|
| $Id$
|
****************************************************************************/

class DSPKitDPWriter;

#ifndef _DSPKIT_DPWRITER_H_
#define _DSPKIT_DPWRITER_H_

#include "DPSample.h"
#include "processo.h"

class DSPKitDPWriter : public DSPKitProcessor
{
  public:

    DSPKitDPWriter ();
    void setChannels (
      long newChannel_a,
      long newChannel_b);
    void setChannels (
      long newChannel_a,
      long newChannel_b,
      long newChannel_c,
      long newChannel_d);
    long setInputOutput (
      DSPKitProcessor *ipL,
      DSPKitProcessor *ipR,
      DPSample *newSample);
    long setInputOutput (
      DSPKitProcessor *ipL,
      DSPKitProcessor *ipR,
      DSPKitProcessor *ip3,
      DSPKitProcessor *ip4,
      DPSample *newSample);
    void run ();
    long getSample (double &);
    long getSamplesWritten () const;

  protected:

    long            samplesWritten;
    DSPKitProcessor *inputR;
    DSPKitProcessor *input3;
    DSPKitProcessor *input4;
    DPSample        *sample;
    long            i;
    long            frames;
    long            check;
    long            checkReset;
    long            channel_a;
    long            channel_b;
    long            channel_c;
    long            channel_d;
};

inline long DSPKitDPWriter::getSamplesWritten () const
{
  return samplesWritten;
}

inline long DSPKitDPWriter::getSample (double &)
{
  return 0;
}

#endif

/***************************************************************************/
